/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.AuthenticatedDataParser;
import org.bouncycastle.asn1.cms.ContentInfoParser;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.util.Arrays;

public class CMSAuthenticatedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore _recipientInfoStore;
    AuthenticatedDataParser authData = new AuthenticatedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier macAlg;
    private byte[] mac;
    private AttributeTable authAttrs;
    private AttributeTable unauthAttrs;
    private boolean authAttrNotRead = true;
    private boolean unauthAttrNotRead;

    public CMSAuthenticatedDataParser(byte[] byArray) throws CMSException, IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSAuthenticatedDataParser(InputStream inputStream) throws CMSException, IOException {
        super(inputStream);
        DEREncodable dEREncodable;
        ASN1SetParser aSN1SetParser = this.authData.getRecipientInfos();
        ArrayList<RecipientInfo> arrayList = new ArrayList<RecipientInfo>();
        while ((dEREncodable = aSN1SetParser.readObject()) != null) {
            arrayList.add(RecipientInfo.getInstance((Object)dEREncodable.getDERObject()));
        }
        this.macAlg = this.authData.getMacAlgorithm();
        ContentInfoParser contentInfoParser = this.authData.getEnapsulatedContentInfo();
        ArrayList<RecipientInformation> arrayList2 = new ArrayList<RecipientInformation>();
        Iterator iterator = arrayList.iterator();
        InputStream inputStream2 = ((ASN1OctetStringParser)contentInfoParser.getContent(4)).getOctetStream();
        while (iterator.hasNext()) {
            RecipientInfo recipientInfo = (RecipientInfo)iterator.next();
            DEREncodable dEREncodable2 = recipientInfo.getInfo();
            if (dEREncodable2 instanceof KeyTransRecipientInfo) {
                arrayList2.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)dEREncodable2, null, this.macAlg, inputStream2));
                continue;
            }
            if (dEREncodable2 instanceof KEKRecipientInfo) {
                arrayList2.add(new KEKRecipientInformation((KEKRecipientInfo)dEREncodable2, null, this.macAlg, inputStream2));
                continue;
            }
            if (dEREncodable2 instanceof KeyAgreeRecipientInfo) {
                arrayList2.add(new KeyAgreeRecipientInformation((KeyAgreeRecipientInfo)dEREncodable2, null, this.macAlg, inputStream2));
                continue;
            }
            if (!(dEREncodable2 instanceof PasswordRecipientInfo)) continue;
            arrayList2.add(new PasswordRecipientInformation((PasswordRecipientInfo)dEREncodable2, null, this.macAlg, inputStream2));
        }
        this._recipientInfoStore = new RecipientInformationStore(arrayList2);
    }

    public String getMacAlgOID() {
        return this.macAlg.getObjectId().toString();
    }

    public byte[] getMacAlgParams() {
        try {
            return this.encodeObj(this.macAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getMacAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        return this.getMacAlgorithmParameters(CMSUtils.getProvider(string));
    }

    public AlgorithmParameters getMacAlgorithmParameters(Provider provider) throws CMSException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getMacAlgOID(), this.getMacAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this._recipientInfoStore;
    }

    public byte[] getMac() throws IOException {
        if (this.mac == null) {
            this.getAuthAttrs();
            this.mac = this.authData.getMac().getOctets();
        }
        return Arrays.clone((byte[])this.mac);
    }

    public AttributeTable getAuthAttrs() throws IOException {
        if (this.authAttrs == null && this.authAttrNotRead) {
            ASN1SetParser aSN1SetParser = this.authData.getAuthAttrs();
            this.authAttrNotRead = false;
            if (aSN1SetParser != null) {
                DEREncodable dEREncodable;
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                while ((dEREncodable = aSN1SetParser.readObject()) != null) {
                    ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)dEREncodable;
                    aSN1EncodableVector.add((DEREncodable)aSN1SequenceParser.getDERObject());
                }
                this.authAttrs = new AttributeTable((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector));
            }
        }
        return this.authAttrs;
    }

    public AttributeTable getUnauthAttrs() throws IOException {
        if (this.unauthAttrs == null && this.unauthAttrNotRead) {
            ASN1SetParser aSN1SetParser = this.authData.getUnauthAttrs();
            this.unauthAttrNotRead = false;
            if (aSN1SetParser != null) {
                DEREncodable dEREncodable;
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                while ((dEREncodable = aSN1SetParser.readObject()) != null) {
                    ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)dEREncodable;
                    aSN1EncodableVector.add((DEREncodable)aSN1SequenceParser.getDERObject());
                }
                this.unauthAttrs = new AttributeTable((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector));
            }
        }
        return this.unauthAttrs;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            return dEREncodable.getDERObject().getEncoded();
        }
        return null;
    }
}

