/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.rotate.GUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.commons.business.actions.SetOutputPathSelectionTableAction;
import org.pdfsam.guiclient.commons.business.listeners.CompressCheckBoxItemListener;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.JPdfVersionCombo;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.gui.components.JHelpLabel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.rotate.listeners.RunButtonActionListener;

public class RotateMainGUI
extends AbstractPlugablePanel {
    private static final long serialVersionUID = -3486940947325560929L;
    private static final Logger log = Logger.getLogger((String)RotateMainGUI.class.getPackage().getName());
    private SpringLayout destinationPanelLayout;
    private SpringLayout outputOptionsPanelLayout;
    private SpringLayout rotationPanelLayout;
    private final JPanel destinationPanel = new JPanel();
    private final JPanel topPanel = new JPanel();
    private final JPanel outputOptionsPanel = new JPanel();
    private final JPanel rotationPanel = new JPanel();
    private JPdfSelectionPanel selectionPanel = new JPdfSelectionPanel(Integer.MAX_VALUE, 6, true, false);
    private final JCheckBox overwriteCheckbox = CommonComponentsFactory.getInstance().createCheckBox(1);
    private final JCheckBox outputCompressedCheck = CommonComponentsFactory.getInstance().createCheckBox(2);
    private JTextField destinationTextField = CommonComponentsFactory.getInstance().createTextField(1);
    private JTextField outPrefixTextField = CommonComponentsFactory.getInstance().createTextField(2);
    private JHelpLabel destinationHelpLabel;
    private JHelpLabel prefixHelpLabel;
    private JHelpLabel rotateHelpLabel;
    private JComboBox rotationBox;
    private JComboBox rotationPagesBox;
    private Configuration config;
    private JPdfVersionCombo versionCombo = new JPdfVersionCombo();
    private final JLabel outputVersionLabel = CommonComponentsFactory.getInstance().createLabel(1);
    private final JLabel outPrefixLabel = new JLabel();
    private final JLabel rotateComboLabel = new JLabel();
    private final JLabel rotatePagesComboLabel = new JLabel();
    private final RotateFocusPolicy rotateFocusPolicy = new RotateFocusPolicy();
    private final JButton runButton = CommonComponentsFactory.getInstance().createButton(1);
    private final JButton browseButton = CommonComponentsFactory.getInstance().createButton(2);
    private final EnterDoClickListener runEnterkeyListener = new EnterDoClickListener(this.runButton);
    private final EnterDoClickListener browseEnterkeyListener = new EnterDoClickListener(this.browseButton);
    private static final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private static final String PLUGIN_VERSION = "0.0.5";

    public RotateMainGUI() {
        this.initialize();
    }

    private void initialize() {
        this.config = Configuration.getInstance();
        this.setPanelIcon("/images/rotate.png");
        this.setPreferredSize(new Dimension(500, 550));
        this.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints topConst = new GridBagConstraints();
        topConst.fill = 1;
        topConst.ipady = 5;
        topConst.weightx = 1.0;
        topConst.weighty = 1.0;
        topConst.gridwidth = 3;
        topConst.gridheight = 1;
        topConst.gridx = 0;
        topConst.gridy = 0;
        this.topPanel.add((Component)this.selectionPanel, topConst);
        this.selectionPanel.addPopupMenuAction((AbstractAction)new SetOutputPathSelectionTableAction(this.selectionPanel, this.destinationTextField, null));
        this.rotationPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotation")));
        this.rotationPanel.setPreferredSize(new Dimension(200, 95));
        this.rotationPanel.setMinimumSize(new Dimension(160, 90));
        this.rotationPanelLayout = new SpringLayout();
        this.rotationPanel.setLayout(this.rotationPanelLayout);
        this.rotationBox = new JComboBox();
        this.rotationBox.addItem("90");
        this.rotationBox.addItem("180");
        this.rotationBox.addItem("270");
        this.rotationPagesBox = new JComboBox();
        this.rotationPagesBox.addItem(new StringItem("all", GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"All")));
        this.rotationPagesBox.addItem(new StringItem("even", GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Even")));
        this.rotationPagesBox.addItem(new StringItem("odd", GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Odd")));
        this.rotateComboLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Clockwise rotation (degrees):"));
        this.rotatePagesComboLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Pages:"));
        StringBuffer sb1 = new StringBuffer();
        sb1.append("<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotation") + "</b>");
        sb1.append("<p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the rotation degrees (clockwise).") + "</p>");
        sb1.append("<p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the pages that will be rotated.") + "</p>");
        sb1.append("</body></html>");
        this.rotateHelpLabel = new JHelpLabel(sb1.toString(), true);
        this.rotationPanel.add((Component)this.rotateHelpLabel);
        this.rotationPanel.add(this.rotateComboLabel);
        this.rotationPanel.add(this.rotationBox);
        this.rotationPanel.add(this.rotatePagesComboLabel);
        this.rotationPanel.add(this.rotationPagesBox);
        this.rotationPanel.add((Component)this.rotateHelpLabel);
        topConst.fill = 2;
        topConst.weightx = 0.0;
        topConst.weighty = 0.0;
        topConst.gridwidth = 3;
        topConst.gridheight = 1;
        topConst.gridx = 0;
        topConst.gridy = 1;
        this.topPanel.add((Component)this.rotationPanel, topConst);
        this.destinationPanelLayout = new SpringLayout();
        this.destinationPanel.setLayout(this.destinationPanelLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination folder"));
        this.destinationPanel.setBorder(titledBorder);
        this.destinationPanel.setPreferredSize(new Dimension(200, 160));
        this.destinationPanel.setMinimumSize(new Dimension(160, 150));
        this.destinationPanel.add(this.destinationTextField);
        topConst.fill = 2;
        topConst.weightx = 0.0;
        topConst.weighty = 0.0;
        topConst.gridwidth = 3;
        topConst.gridheight = 1;
        topConst.gridx = 0;
        topConst.gridy = 2;
        this.topPanel.add((Component)this.destinationPanel, topConst);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        this.add(this.topPanel, c);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File chosenFile;
                JFileChooser fileChooser = SharedJFileChooser.getInstance((SharedJFileChooserType)SharedJFileChooserType.NO_FILTER, (int)1, (String)RotateMainGUI.this.destinationTextField.getText());
                if (fileChooser.showOpenDialog(RotateMainGUI.this.browseButton.getParent()) == 0 && (chosenFile = fileChooser.getSelectedFile()) != null) {
                    RotateMainGUI.this.destinationTextField.setText(chosenFile.getAbsolutePath());
                }
            }
        });
        this.destinationPanel.add(this.browseButton);
        this.overwriteCheckbox.setSelected(true);
        this.destinationPanel.add(this.overwriteCheckbox);
        this.outputCompressedCheck.addItemListener((ItemListener)new CompressCheckBoxItemListener(this.versionCombo));
        this.outputCompressedCheck.setSelected(true);
        this.destinationPanel.add(this.outputCompressedCheck);
        this.destinationPanel.add((Component)this.versionCombo);
        this.destinationPanel.add(this.outputVersionLabel);
        String helpTextDest = "<html><body><b>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Destination output directory") + "</b>" + "<p>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"To choose a folder browse or enter the full path to the destination output directory.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Check the box if you want to overwrite the output files if they already exist.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Check the box if you want compressed output files.") + " " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"PDF version 1.5 or above.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Set the pdf version of the ouput document.") + "</p>" + "</body></html>";
        this.destinationHelpLabel = new JHelpLabel(helpTextDest, true);
        this.destinationPanel.add((Component)this.destinationHelpLabel);
        this.outputOptionsPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Output options")));
        this.outputOptionsPanel.setPreferredSize(new Dimension(200, 55));
        this.outputOptionsPanel.setMinimumSize(new Dimension(160, 50));
        this.outputOptionsPanelLayout = new SpringLayout();
        this.outputOptionsPanel.setLayout(this.outputOptionsPanelLayout);
        this.outPrefixLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Output file names prefix:"));
        this.outputOptionsPanel.add(this.outPrefixLabel);
        this.outPrefixTextField.setPreferredSize(new Dimension(180, 20));
        this.outputOptionsPanel.add(this.outPrefixTextField);
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Output files prefix") + "</b>");
        sb.append("<p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"If it contains \"[TIMESTAMP]\" it performs variable substitution.") + "</p>");
        sb.append("<p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Ex. [BASENAME]_prefix_[TIMESTAMP] generates FileName_prefix_20070517_113423471.pdf.") + "</p>");
        sb.append("<br><p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"If it doesn't contain \"[TIMESTAMP]\" it generates oldstyle output file names.") + "</p>");
        sb.append("<br><p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Available variables: [TIMESTAMP], [BASENAME].") + "</p>");
        sb.append("</body></html>");
        this.prefixHelpLabel = new JHelpLabel(sb.toString(), true);
        this.outputOptionsPanel.add((Component)this.prefixHelpLabel);
        c.fill = 2;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 1;
        this.add(this.outputOptionsPanel, c);
        this.runButton.addActionListener((ActionListener)((Object)new RunButtonActionListener(this)));
        this.runButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate selected files"));
        this.runButton.setSize(new Dimension(88, 25));
        c.fill = 0;
        c.ipadx = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 26;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 10, 10);
        this.add(this.runButton, c);
        this.destinationTextField.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.runButton.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.browseButton.addKeyListener((KeyListener)this.browseEnterkeyListener);
        this.setLayout();
    }

    private void setLayout() {
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationTextField, -105, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.destinationTextField, 10, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationTextField, 30, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.destinationTextField, 5, "West", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.overwriteCheckbox, 17, "North", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("North", (Component)this.overwriteCheckbox, 5, "South", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("West", (Component)this.overwriteCheckbox, 0, "West", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputCompressedCheck, 17, "North", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputCompressedCheck, 5, "South", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputCompressedCheck, 0, "West", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputVersionLabel, 17, "North", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputVersionLabel, 8, "South", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputVersionLabel, 0, "West", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("South", (Component)this.versionCombo, 0, "South", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.versionCombo, 2, "East", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.browseButton, 25, "North", (Component)this.browseButton);
        this.destinationPanelLayout.putConstraint("East", (Component)this.browseButton, -10, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.browseButton, 0, "North", (Component)this.destinationTextField);
        this.destinationPanelLayout.putConstraint("West", (Component)this.browseButton, -88, "East", (Component)this.browseButton);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationHelpLabel, -1, "South", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationHelpLabel, -1, "East", (Component)this.destinationPanel);
        this.outputOptionsPanelLayout.putConstraint("South", (Component)this.outPrefixLabel, 20, "North", (Component)this.outputOptionsPanel);
        this.outputOptionsPanelLayout.putConstraint("North", (Component)this.outPrefixLabel, 5, "North", (Component)this.outputOptionsPanel);
        this.outputOptionsPanelLayout.putConstraint("West", (Component)this.outPrefixLabel, 5, "West", (Component)this.outputOptionsPanel);
        this.outputOptionsPanelLayout.putConstraint("South", (Component)this.outPrefixTextField, 0, "South", (Component)this.outPrefixLabel);
        this.outputOptionsPanelLayout.putConstraint("West", (Component)this.outPrefixTextField, 10, "East", (Component)this.outPrefixLabel);
        this.outputOptionsPanelLayout.putConstraint("East", (Component)this.outPrefixTextField, -30, "East", (Component)this.outputOptionsPanel);
        this.outputOptionsPanelLayout.putConstraint("South", (Component)this.prefixHelpLabel, -1, "South", (Component)this.outputOptionsPanel);
        this.outputOptionsPanelLayout.putConstraint("East", (Component)this.prefixHelpLabel, -1, "East", (Component)this.outputOptionsPanel);
        this.rotationPanelLayout.putConstraint("South", (Component)this.rotateComboLabel, 20, "North", (Component)this.rotationPanel);
        this.rotationPanelLayout.putConstraint("North", (Component)this.rotateComboLabel, 5, "North", (Component)this.rotationPanel);
        this.rotationPanelLayout.putConstraint("West", (Component)this.rotateComboLabel, 5, "West", (Component)this.rotationPanel);
        this.rotationPanelLayout.putConstraint("South", (Component)this.rotationBox, 0, "South", (Component)this.rotateComboLabel);
        this.rotationPanelLayout.putConstraint("West", (Component)this.rotationBox, 10, "East", (Component)this.rotateComboLabel);
        this.rotationPanelLayout.putConstraint("South", (Component)this.rotatePagesComboLabel, 15, "North", (Component)this.rotatePagesComboLabel);
        this.rotationPanelLayout.putConstraint("North", (Component)this.rotatePagesComboLabel, 10, "South", (Component)this.rotateComboLabel);
        this.rotationPanelLayout.putConstraint("West", (Component)this.rotatePagesComboLabel, 0, "West", (Component)this.rotateComboLabel);
        this.rotationPanelLayout.putConstraint("South", (Component)this.rotationPagesBox, 0, "South", (Component)this.rotatePagesComboLabel);
        this.rotationPanelLayout.putConstraint("West", (Component)this.rotationPagesBox, 10, "East", (Component)this.rotatePagesComboLabel);
        this.rotationPanelLayout.putConstraint("South", (Component)this.rotateHelpLabel, -1, "South", (Component)this.rotationPanel);
        this.rotationPanelLayout.putConstraint("East", (Component)this.rotateHelpLabel, -1, "East", (Component)this.rotationPanel);
    }

    public String getPluginAuthor() {
        return PLUGIN_AUTHOR;
    }

    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate");
    }

    public String getVersion() {
        return PLUGIN_VERSION;
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.rotateFocusPolicy;
    }

    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        try {
            if (arg0 != null) {
                Element filelist = ((Element)arg0).addElement("filelist");
                PdfSelectionTableItem[] items = this.selectionPanel.getTableRows();
                for (int i = 0; i < items.length; ++i) {
                    Element fileNode = filelist.addElement("file");
                    fileNode.addAttribute("name", items[i].getInputFile().getAbsolutePath());
                    if (!savePasswords) continue;
                    fileNode.addAttribute("password", items[i].getPassword());
                }
                Element rotationElement = ((Element)arg0).addElement("rotation");
                rotationElement.addAttribute("value", this.rotationBox.getSelectedItem().toString());
                Element rotationPagesElement = ((Element)arg0).addElement("pages");
                rotationPagesElement.addAttribute("value", ((StringItem)this.rotationPagesBox.getSelectedItem()).getId());
                Element fileDestination = ((Element)arg0).addElement("destination");
                fileDestination.addAttribute("value", this.destinationTextField.getText());
                Element fileOverwrite = ((Element)arg0).addElement("overwrite");
                fileOverwrite.addAttribute("value", this.overwriteCheckbox.isSelected() ? TRUE : FALSE);
                Element fileCompress = ((Element)arg0).addElement("compressed");
                fileCompress.addAttribute("value", this.outputCompressedCheck.isSelected() ? TRUE : FALSE);
                Element pdfVersion = ((Element)arg0).addElement("pdfversion");
                pdfVersion.addAttribute("value", ((StringItem)this.versionCombo.getSelectedItem()).getId());
                Element filePrefix = ((Element)arg0).addElement("prefix");
                filePrefix.addAttribute("value", this.outPrefixTextField.getText());
            }
            return arg0;
        }
        catch (Exception ex) {
            throw new SaveJobException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void loadJobNode(Node arg0) throws LoadJobException {
        try {
            Node pdfVersion;
            Node filePrefix;
            Node fileCompressed;
            Node fileOverwrite;
            Node fileDestination;
            Node rotationPageNode;
            List fileList = arg0.selectNodes("filelist/file");
            for (int i = 0; fileList != null && i < fileList.size(); ++i) {
                Node fileName;
                Node fileNode = (Node)fileList.get(i);
                if (fileNode == null || (fileName = fileNode.selectSingleNode("@name")) == null || fileName.getText().length() <= 0) continue;
                Node filePwd = fileNode.selectSingleNode("@password");
                this.selectionPanel.getLoader().addFile(new File(fileName.getText()), filePwd != null ? filePwd.getText() : null);
            }
            Node rotationNode = arg0.selectSingleNode("rotation/@value");
            if (rotationNode != null) {
                this.rotationBox.setSelectedItem(rotationNode.getText());
            }
            if ((rotationPageNode = arg0.selectSingleNode("pages/@value")) != null) {
                for (int i = 0; i < this.rotationPagesBox.getItemCount(); ++i) {
                    if (!((StringItem)this.rotationPagesBox.getItemAt(i)).getId().equals(rotationPageNode.getText())) continue;
                    this.rotationPagesBox.setSelectedIndex(i);
                    break;
                }
            }
            if ((fileDestination = arg0.selectSingleNode("destination/@value")) != null) {
                this.destinationTextField.setText(fileDestination.getText());
            }
            if ((fileOverwrite = arg0.selectSingleNode("overwrite/@value")) != null) {
                this.overwriteCheckbox.setSelected(fileOverwrite.getText().equals("true"));
            }
            if ((fileCompressed = arg0.selectSingleNode("compressed/@value")) != null && TRUE.equals(fileCompressed.getText())) {
                this.outputCompressedCheck.doClick();
            }
            if ((filePrefix = arg0.selectSingleNode("prefix/@value")) != null) {
                this.outPrefixTextField.setText(filePrefix.getText());
            }
            if ((pdfVersion = arg0.selectSingleNode("pdfversion/@value")) != null) {
                for (int i = 0; i < this.versionCombo.getItemCount(); ++i) {
                    if (!((StringItem)this.versionCombo.getItemAt(i)).getId().equals(pdfVersion.getText())) continue;
                    this.versionCombo.setSelectedIndex(i);
                    break;
                }
            }
            log.info((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate section loaded."));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
        }
    }

    public void resetPanel() {
        this.selectionPanel.clearSelectionTable();
        this.destinationTextField.setText("");
        this.versionCombo.resetComponent();
        this.outputCompressedCheck.setSelected(false);
        this.overwriteCheckbox.setSelected(false);
        this.outPrefixTextField.setText("pdfsam_");
    }

    public JPdfSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public JCheckBox getOverwriteCheckbox() {
        return this.overwriteCheckbox;
    }

    public JCheckBox getOutputCompressedCheck() {
        return this.outputCompressedCheck;
    }

    public JTextField getDestinationTextField() {
        return this.destinationTextField;
    }

    public JTextField getOutPrefixTextField() {
        return this.outPrefixTextField;
    }

    public JPdfVersionCombo getVersionCombo() {
        return this.versionCombo;
    }

    public JComboBox getRotationBox() {
        return this.rotationBox;
    }

    public JComboBox getRotationPagesBox() {
        return this.rotationPagesBox;
    }

    public class RotateFocusPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(RotateMainGUI.this.selectionPanel.getAddFileButton())) {
                return RotateMainGUI.this.selectionPanel.getRemoveFileButton();
            }
            if (aComponent.equals(RotateMainGUI.this.selectionPanel.getRemoveFileButton())) {
                return RotateMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(RotateMainGUI.this.selectionPanel.getClearButton())) {
                return RotateMainGUI.this.rotationBox;
            }
            if (aComponent.equals(RotateMainGUI.this.rotationBox)) {
                return RotateMainGUI.this.rotationPagesBox;
            }
            if (aComponent.equals(RotateMainGUI.this.rotationPagesBox)) {
                return RotateMainGUI.this.destinationTextField;
            }
            if (aComponent.equals(RotateMainGUI.this.destinationTextField)) {
                return RotateMainGUI.this.browseButton;
            }
            if (aComponent.equals(RotateMainGUI.this.browseButton)) {
                return RotateMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(RotateMainGUI.this.overwriteCheckbox)) {
                return RotateMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(RotateMainGUI.this.outputCompressedCheck)) {
                return RotateMainGUI.this.versionCombo;
            }
            if (aComponent.equals(RotateMainGUI.this.versionCombo)) {
                return RotateMainGUI.this.outPrefixTextField;
            }
            if (aComponent.equals(RotateMainGUI.this.outPrefixTextField)) {
                return RotateMainGUI.this.runButton;
            }
            if (aComponent.equals(RotateMainGUI.this.runButton)) {
                return RotateMainGUI.this.selectionPanel.getAddFileButton();
            }
            return RotateMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(RotateMainGUI.this.runButton)) {
                return RotateMainGUI.this.outPrefixTextField;
            }
            if (aComponent.equals(RotateMainGUI.this.outPrefixTextField)) {
                return RotateMainGUI.this.versionCombo;
            }
            if (aComponent.equals(RotateMainGUI.this.versionCombo)) {
                return RotateMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(RotateMainGUI.this.outputCompressedCheck)) {
                return RotateMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(RotateMainGUI.this.overwriteCheckbox)) {
                return RotateMainGUI.this.browseButton;
            }
            if (aComponent.equals(RotateMainGUI.this.browseButton)) {
                return RotateMainGUI.this.destinationTextField;
            }
            if (aComponent.equals(RotateMainGUI.this.destinationTextField)) {
                return RotateMainGUI.this.rotationPagesBox;
            }
            if (aComponent.equals(RotateMainGUI.this.rotationPagesBox)) {
                return RotateMainGUI.this.rotationBox;
            }
            if (aComponent.equals(RotateMainGUI.this.rotationBox)) {
                return RotateMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(RotateMainGUI.this.selectionPanel.getClearButton())) {
                return RotateMainGUI.this.selectionPanel.getRemoveFileButton();
            }
            if (aComponent.equals(RotateMainGUI.this.selectionPanel.getRemoveFileButton())) {
                return RotateMainGUI.this.selectionPanel.getAddFileButton();
            }
            if (aComponent.equals(RotateMainGUI.this.selectionPanel.getAddFileButton())) {
                return RotateMainGUI.this.runButton;
            }
            return RotateMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getDefaultComponent(Container CycleRootComp) {
            return RotateMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getLastComponent(Container CycleRootComp) {
            return RotateMainGUI.this.runButton;
        }

        public Component getFirstComponent(Container CycleRootComp) {
            return RotateMainGUI.this.selectionPanel.getAddFileButton();
        }
    }
}

