/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LogInputStream
extends FilterInputStream {
    private OutputStream log;

    public LogInputStream(InputStream inputStream, OutputStream outputStream) {
        super(inputStream);
        this.setLog(outputStream);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.log != null) {
            this.log.close();
        }
    }

    public OutputStream getLog() {
        return this.log;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n > -1 && this.log != null) {
            this.log.write(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > -1 && this.log != null) {
            this.log.write(byArray, n, n3);
        }
        return n3;
    }

    public void setLog(OutputStream outputStream) {
        this.log = outputStream;
    }
}

