/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordTag;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableTag
extends ParosAbstractTable
implements TableTag {
    private static final String TABLE_NAME = "TAG";
    private static final String TAGID = "TAGID";
    private static final String HISTORYID = "HISTORYID";
    private static final String TAG = "TAG";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsertTag = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetTagsForHistoryId = null;
    private PreparedStatement psDeleteTag = null;
    private PreparedStatement psDeleteTagsForHistoryId = null;
    private PreparedStatement psGetAllTags = null;

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(connection, "TAG")) {
                DbUtils.executeAndClose(connection.prepareStatement("CREATE cached TABLE TAG (tagid bigint generated by default as identity (start with 1), historyid bigint not null, tag varchar(1024) default '')"));
            }
            this.psRead = connection.prepareStatement("SELECT * FROM TAG WHERE TAGID = ?");
            this.psInsertTag = connection.prepareStatement("INSERT INTO TAG (HISTORYID,TAG) VALUES (?, ?)");
            this.psGetIdLastInsert = connection.prepareCall("CALL IDENTITY();");
            this.psDeleteTag = connection.prepareStatement("DELETE FROM TAG WHERE HISTORYID = ? AND TAG = ?");
            this.psGetTagsForHistoryId = connection.prepareStatement("SELECT * FROM TAG WHERE HISTORYID = ?");
            this.psDeleteTagsForHistoryId = connection.prepareStatement("DELETE FROM TAG WHERE HISTORYID = ?");
            this.psGetAllTags = connection.prepareStatement("SELECT DISTINCT TAG FROM TAG ORDER BY TAG");
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordTag read(long l) throws DatabaseException {
        try {
            this.psRead.setLong(1, l);
            try (ResultSet resultSet = this.psRead.executeQuery();){
                RecordTag recordTag;
                RecordTag recordTag2 = recordTag = this.build(resultSet);
                return recordTag2;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordTag insert(long l, String string) throws DatabaseException {
        try {
            this.psInsertTag.setLong(1, l);
            this.psInsertTag.setString(2, string);
            this.psInsertTag.executeUpdate();
            try (ResultSet resultSet = this.psGetIdLastInsert.executeQuery();){
                resultSet.next();
                long l2 = resultSet.getLong(1);
                RecordTag recordTag = this.read(l2);
                return recordTag;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void delete(long l, String string) throws DatabaseException {
        try {
            this.psDeleteTag.setLong(1, l);
            this.psDeleteTag.setString(2, string);
            this.psDeleteTag.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized List<RecordTag> getTagsForHistoryID(long l) throws DatabaseException {
        try {
            ArrayList<RecordTag> arrayList = new ArrayList<RecordTag>();
            this.psGetTagsForHistoryId.setLong(1, l);
            try (ResultSet resultSet = this.psGetTagsForHistoryId.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(new RecordTag(resultSet.getLong(TAGID), resultSet.getLong(TAGID), resultSet.getString("TAG")));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<String> getAllTags() throws DatabaseException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            try (ResultSet resultSet = this.psGetAllTags.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("TAG"));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void deleteTagsForHistoryID(long l) throws DatabaseException {
        try {
            this.psDeleteTagsForHistoryId.setLong(1, l);
            this.psDeleteTagsForHistoryId.execute();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private RecordTag build(ResultSet resultSet) throws SQLException {
        RecordTag recordTag = null;
        if (resultSet.next()) {
            recordTag = new RecordTag(resultSet.getLong(TAGID), resultSet.getLong(HISTORYID), resultSet.getString("TAG"));
        }
        return recordTag;
    }
}

