/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordContext;
import org.parosproxy.paros.db.RecordSessionUrl;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StandardParameterParser;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class Session {
    private static Logger log = Logger.getLogger(Session.class);
    private static final String ROOT = "session";
    private static final String SESSION_DESC = "sessionDesc";
    private static final String SESSION_ID = "sessionId";
    private static final String SESSION_NAME = "sessionName";
    private ZapXmlConfiguration configuration;
    private Model model = null;
    private String fileName = "";
    private String sessionDesc = "";
    private List<String> excludeFromProxyRegexs = new ArrayList<String>();
    private List<String> excludeFromScanRegexs = new ArrayList<String>();
    private List<String> excludeFromSpiderRegexs = new ArrayList<String>();
    private List<String> globalExcludeURLRegexs = new ArrayList<String>();
    private List<Context> contexts = new ArrayList<Context>();
    private int nextContextIndex = 1;
    private long sessionId = 0L;
    private String sessionName = "";
    private SiteMap siteTree = null;
    private ParameterParser defaultParamParser = new StandardParameterParser();
    private List<OnContextsChangedListener> contextsChangedListeners = new LinkedList<OnContextsChangedListener>();

    protected Session(Model model) {
        this.configuration = new ZapXmlConfiguration();
        this.configuration.setRootElementName(ROOT);
        this.setSessionId(System.currentTimeMillis());
        this.setSessionName(Constant.messages.getString("session.untitled"));
        this.setSessionDesc("");
        if (!Constant.isLowMemoryOptionSet()) {
            this.siteTree = SiteMap.createTree(model);
        }
        this.model = model;
        this.discardContexts();
        this.getNewContext(Constant.messages.getString("context.default.name"));
    }

    private void discardContexts() {
        if (View.isInitialised()) {
            View.getSingleton().discardContexts();
        }
        this.contexts.clear();
        for (OnContextsChangedListener onContextsChangedListener : this.contextsChangedListeners) {
            onContextsChangedListener.contextsChanged();
        }
        this.nextContextIndex = 1;
    }

    protected void discard() {
        try {
            this.model.getDb().getTableHistory().deleteHistorySession(this.getSessionId());
        }
        catch (DatabaseException databaseException) {
            log.warn((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        this.discardContexts();
    }

    protected void close() {
        this.discardContexts();
    }

    public String getSessionDesc() {
        return this.sessionDesc;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SiteMap getSiteTree() {
        return this.siteTree;
    }

    public boolean isNewState() {
        return this.fileName.equals("");
    }

    protected void open(final File file, final SessionListener sessionListener) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    Session.this.open(file.getAbsolutePath());
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (sessionListener != null) {
                    sessionListener.sessionOpened(file, exception);
                }
            }
        });
        thread.setPriority(3);
        thread.start();
    }

    protected void open(final String string, final SessionListener sessionListener) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    Session.this.open(string);
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (sessionListener != null) {
                    sessionListener.sessionOpened(null, exception);
                }
            }
        });
        thread.setPriority(3);
        thread.start();
    }

    protected void open(String string) throws DatabaseException, IOException, Exception {
        List<String> list;
        int n;
        int n2;
        List<Integer> list2;
        if ("hsqldb".equals(this.model.getDb().getType())) {
            this.configuration = new ZapXmlConfiguration(new File(string));
            this.sessionId = this.configuration.getLong(SESSION_ID);
            this.sessionName = this.configuration.getString(SESSION_NAME, "");
            this.sessionDesc = this.configuration.getString(SESSION_DESC, "");
        } else {
            this.setSessionId(Long.parseLong(string));
        }
        this.model.getDb().close(false);
        this.model.getDb().open(string);
        this.fileName = string;
        if (!Constant.isLowMemoryOptionSet()) {
            list2 = new SiteNode(this.siteTree, -1, Constant.messages.getString("tab.sites"));
            this.siteTree.setRoot((TreeNode)((Object)list2));
        }
        list2 = this.model.getDb().getTableHistory().getHistoryIdsOfHistType(this.getSessionId(), 1, 15);
        HistoryReference historyReference = null;
        this.discardContexts();
        this.setExcludeFromProxyRegexs(this.sessionUrlListToStingList(this.model.getDb().getTableSessionUrl().getUrlsForType(1)));
        this.setExcludeFromScanRegexs(this.sessionUrlListToStingList(this.model.getDb().getTableSessionUrl().getUrlsForType(2)));
        this.setExcludeFromSpiderRegexs(this.sessionUrlListToStingList(this.model.getDb().getTableSessionUrl().getUrlsForType(3)));
        for (n2 = 0; n2 < list2.size(); ++n2) {
            n = (Integer)list2.get(n2);
            try {
                historyReference = new HistoryReference(n);
                if (View.isInitialised()) {
                    final HistoryReference exception = historyReference;
                    list = historyReference.getHttpMessage();
                    EventQueue.invokeAndWait(new Runnable((HttpMessage)((Object)list)){
                        final /* synthetic */ HttpMessage val$msg;
                        {
                            this.val$msg = httpMessage;
                        }

                        @Override
                        public void run() {
                            SiteNode siteNode = Session.this.getSiteTree().addPath(exception, this.val$msg);
                            if (siteNode != null) {
                                siteNode.setIncludedInScope(Session.this.isIncludedInScope(siteNode), false);
                                siteNode.setExcludedFromScope(Session.this.isExcludedFromScope(siteNode), false);
                            }
                        }
                    });
                } else {
                    SiteNode exception = this.getSiteTree().addPath(historyReference);
                    if (exception != null) {
                        exception.setIncludedInScope(this.isIncludedInScope(exception), false);
                        exception.setExcludedFromScope(this.isExcludedFromScope(exception), false);
                    }
                }
                historyReference.loadAlerts();
                if (n2 % 100 != 99) continue;
                Thread.yield();
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        list2 = this.model.getDb().getTableHistory().getHistoryIdsOfHistType(this.getSessionId(), 2, 7, 10);
        for (n2 = 0; n2 < list2.size(); ++n2) {
            n = list2.get(n2);
            try {
                historyReference = new HistoryReference(n);
                if (View.isInitialised()) {
                    final HistoryReference historyReference2 = historyReference;
                    list = historyReference.getHttpMessage();
                    EventQueue.invokeAndWait(new Runnable((HttpMessage)((Object)list)){
                        final /* synthetic */ HttpMessage val$msg;
                        {
                            this.val$msg = httpMessage;
                        }

                        @Override
                        public void run() {
                            Session.this.getSiteTree().addPath(historyReference2, this.val$msg);
                        }
                    });
                } else {
                    this.getSiteTree().addPath(historyReference);
                }
                if (n2 % 100 != 99) continue;
                Thread.yield();
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        List<RecordContext> list3 = this.model.getDb().getTableContext().getAllData();
        for (RecordContext recordContext : list3) {
            list = this.getContext(recordContext.getContextId());
            if (list == null) {
                list = new Context(this, recordContext.getContextId());
                this.addContext((Context)((Object)list));
                if (this.nextContextIndex <= recordContext.getContextId()) {
                    this.nextContextIndex = recordContext.getContextId() + 1;
                }
            }
            switch (recordContext.getType()) {
                case 1: {
                    ((Context)((Object)list)).setName(recordContext.getData());
                    if (!View.isInitialised() || ((Context)((Object)list)).getName().equals(String.valueOf(((Context)((Object)list)).getIndex()))) break;
                    View.getSingleton().renameContext((Context)((Object)list));
                    break;
                }
                case 2: {
                    ((Context)((Object)list)).setDescription(recordContext.getData());
                    break;
                }
                case 3: {
                    ((Context)((Object)list)).addIncludeInContextRegex(recordContext.getData());
                    break;
                }
                case 4: {
                    ((Context)((Object)list)).addExcludeFromContextRegex(recordContext.getData());
                    break;
                }
                case 5: {
                    ((Context)((Object)list)).setInScope(Boolean.parseBoolean(recordContext.getData()));
                    break;
                }
                case 6: {
                    ((Context)((Object)list)).getTechSet().include(new Tech(recordContext.getData()));
                    break;
                }
                case 7: {
                    ((Context)((Object)list)).getTechSet().exclude(new Tech(recordContext.getData()));
                }
            }
        }
        for (Context context : this.contexts) {
            Class<?> clazz;
            try {
                list = this.getContextDataStrings(context.getIndex(), 400);
                if (list.size() == 1) {
                    clazz = ExtensionFactory.getAddOnLoader().loadClass(list.get(0));
                    if (clazz == null) {
                        log.error((Object)("Failed to load URL parser for context " + context.getIndex() + " : " + list.get(0)));
                    } else {
                        ParameterParser parameterParser = (ParameterParser)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        list = this.getContextDataStrings(context.getIndex(), 401);
                        if (list.size() == 1) {
                            parameterParser.init(list.get(0));
                        }
                        parameterParser.setContext(context);
                        context.setUrlParamParser(parameterParser);
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)("Failed to load URL parser for context " + context.getIndex()), (Throwable)exception);
            }
            try {
                list = this.getContextDataStrings(context.getIndex(), 402);
                if (list.size() == 1) {
                    clazz = ExtensionFactory.getAddOnLoader().loadClass(list.get(0));
                    if (clazz == null) {
                        log.error((Object)("Failed to load POST parser for context " + context.getIndex() + " : " + list.get(0)));
                    } else {
                        ParameterParser parameterParser = (ParameterParser)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        list = this.getContextDataStrings(context.getIndex(), 403);
                        if (list.size() == 1) {
                            parameterParser.init(list.get(0));
                        }
                        parameterParser.setContext(context);
                        context.setPostParamParser(parameterParser);
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)("Failed to load POST parser for context " + context.getIndex()), (Throwable)exception);
            }
            try {
                list = this.getContextDataStrings(context.getIndex(), 404);
                for (String string2 : list) {
                    context.addDataDrivenNodes(new StructuralNodeModifier(string2));
                }
            }
            catch (Exception exception) {
                log.error((Object)("Failed to load data driven nodes for context " + context.getIndex()), (Throwable)exception);
            }
            context.restructureSiteTree();
        }
        if (View.isInitialised()) {
            View.getSingleton().getSiteTreePanel().expandRoot();
        }
        this.refreshScope();
        System.gc();
    }

    private List<String> sessionUrlListToStingList(List<RecordSessionUrl> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (RecordSessionUrl recordSessionUrl : list) {
            arrayList.add(recordSessionUrl.getUrl());
        }
        return arrayList;
    }

    protected void save(final String string, final SessionListener sessionListener) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    Session.this.save(string);
                }
                catch (Exception exception2) {
                    log.warn((Object)exception2.getMessage(), (Throwable)exception2);
                    exception = exception2;
                }
                if (sessionListener != null) {
                    sessionListener.sessionSaved(exception);
                }
            }
        });
        thread.setPriority(3);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String string) throws Exception {
        this.configuration.save(new File(string));
        if (this.isNewState()) {
            this.model.moveSessionDb(string);
        } else if (!this.fileName.equals(string)) {
            this.model.copySessionDb(this.fileName, string);
        }
        this.fileName = string;
        if (!Constant.isLowMemoryOptionSet()) {
            SiteMap siteMap = this.siteTree;
            synchronized (siteMap) {
                this.saveSiteTree((SiteNode)this.siteTree.getRoot());
            }
        }
        this.model.getDb().getTableSession().update(this.getSessionId(), this.getSessionName());
    }

    protected void snapshot(final String string, final SessionListener sessionListener) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    Session.this.snapshot(string);
                }
                catch (Exception exception2) {
                    log.warn((Object)exception2.getMessage(), (Throwable)exception2);
                    exception = exception2;
                }
                if (sessionListener != null) {
                    sessionListener.sessionSnapshot(exception);
                }
            }
        });
        thread.setPriority(3);
        thread.start();
    }

    protected void snapshot(String string) throws Exception {
        this.configuration.save(new File(string));
        this.model.snapshotSessionDb(this.fileName, string);
    }

    public void setSessionDesc(String string) {
        this.sessionDesc = string;
        this.configuration.setProperty(SESSION_DESC, string);
    }

    public void setSessionId(long l) {
        this.sessionId = l;
        this.configuration.setProperty(SESSION_ID, Long.toString(l));
    }

    public void setSessionName(String string) {
        this.sessionName = string;
        this.configuration.setProperty(SESSION_NAME, string);
    }

    public String getFileName() {
        return this.fileName;
    }

    private void saveSiteTree(SiteNode siteNode) {
        HttpMessage httpMessage = null;
        if (!siteNode.isRoot() && siteNode.getHistoryReference().getHistoryType() < 0) {
            this.saveNodeMsg(httpMessage);
        }
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            try {
                this.saveSiteTree((SiteNode)siteNode.getChildAt(i));
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void saveNodeMsg(HttpMessage httpMessage) {
    }

    public String getSessionFolder() {
        String string = "";
        if (this.fileName.equals("")) {
            string = Constant.getInstance().FOLDER_SESSION;
        } else {
            File file = new File(this.fileName);
            string = file.getParent();
        }
        return string;
    }

    public List<String> getExcludeFromProxyRegexs() {
        return this.excludeFromProxyRegexs;
    }

    private List<String> stripEmptyLines(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.length() <= 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private void refreshScope(SiteNode siteNode) {
        if (siteNode == null) {
            return;
        }
        if (siteNode.isIncludedInScope() == !this.isIncludedInScope(siteNode)) {
            siteNode.setIncludedInScope(!siteNode.isIncludedInScope(), false);
        }
        if (siteNode.isExcludedFromScope() == !this.isExcludedFromScope(siteNode)) {
            siteNode.setExcludedFromScope(!siteNode.isExcludedFromScope(), false);
        }
        if (siteNode.getChildCount() > 0) {
            SiteNode siteNode2 = (SiteNode)siteNode.getFirstChild();
            while (siteNode2 != null) {
                this.refreshScope(siteNode2);
                siteNode2 = (SiteNode)siteNode.getChildAfter(siteNode2);
            }
        }
    }

    private void refreshScope() {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.refreshScope((SiteNode)this.siteTree.getRoot());
            Control.getSingleton().sessionScopeChanged();
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Session.this.refreshScope((SiteNode)Session.this.siteTree.getRoot());
                        Control.getSingleton().sessionScopeChanged();
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    protected boolean isIncludedInScope(SiteNode siteNode) {
        if (siteNode == null) {
            return false;
        }
        return this.isIncludedInScope(siteNode.getHierarchicNodeName());
    }

    private boolean isIncludedInScope(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("?") > 0) {
            string = string.substring(0, string.indexOf("?"));
        }
        for (Context context : this.contexts) {
            if (!context.isInScope() || !context.isIncluded(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedFromScope(SiteNode siteNode) {
        if (siteNode == null) {
            return false;
        }
        return this.isExcludedFromScope(siteNode.getHierarchicNodeName());
    }

    private boolean isExcludedFromScope(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("?") > 0) {
            string = string.substring(0, string.indexOf("?"));
        }
        for (Context context : this.contexts) {
            if (!context.isInScope() || !context.isExcluded(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isInScope(HistoryReference historyReference) {
        if (historyReference == null) {
            return false;
        }
        if (historyReference.getSiteNode() != null) {
            return this.isInScope(historyReference.getSiteNode());
        }
        try {
            return this.isInScope(historyReference.getURI().toString());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean isInScope(SiteNode siteNode) {
        if (siteNode == null) {
            return false;
        }
        return this.isInScope(siteNode.getHierarchicNodeName());
    }

    public boolean isInScope(String string) {
        if (string.indexOf("?") > 0) {
            string = string.substring(0, string.indexOf("?"));
        }
        if (!this.isIncludedInScope(string)) {
            return false;
        }
        return !this.isExcludedFromScope(string);
    }

    public List<SiteNode> getNodesInScopeFromSiteTree() {
        LinkedList<SiteNode> linkedList = new LinkedList<SiteNode>();
        SiteNode siteNode = (SiteNode)this.getSiteTree().getRoot();
        this.fillNodesInScope(siteNode, linkedList);
        return linkedList;
    }

    public List<SiteNode> getTopNodesInScopeFromSiteTree() {
        LinkedList<SiteNode> linkedList = new LinkedList<SiteNode>();
        SiteNode siteNode = (SiteNode)this.getSiteTree().getRoot();
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (!this.isContainsNodesInScope(siteNode2)) continue;
            linkedList.add(siteNode2);
        }
        return linkedList;
    }

    private boolean isContainsNodesInScope(SiteNode siteNode) {
        if (siteNode.isIncludedInScope()) {
            return true;
        }
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (!this.isContainsNodesInScope(siteNode2)) continue;
            return true;
        }
        return false;
    }

    private void fillNodesInScope(SiteNode siteNode, List<SiteNode> list) {
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (this.isInScope(siteNode2)) {
                list.add(siteNode2);
            }
            this.fillNodesInScope(siteNode2, list);
        }
    }

    public List<SiteNode> getNodesInContextFromSiteTree(Context context) {
        LinkedList<SiteNode> linkedList = new LinkedList<SiteNode>();
        SiteNode siteNode = (SiteNode)this.getSiteTree().getRoot();
        this.fillNodesInContext(siteNode, linkedList, context);
        return linkedList;
    }

    private void fillNodesInContext(SiteNode siteNode, List<SiteNode> list, Context context) {
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (context.isInContext(siteNode2)) {
                list.add(siteNode2);
            }
            this.fillNodesInContext(siteNode2, list, context);
        }
    }

    public void setExcludeFromProxyRegexs(List<String> list) throws DatabaseException {
        for (String string : list) {
            Pattern.compile(string, 2);
        }
        this.excludeFromProxyRegexs = this.stripEmptyLines(list);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.excludeFromProxyRegexs);
        arrayList.addAll(this.globalExcludeURLRegexs);
        Control.getSingleton().setExcludeFromProxyUrls(arrayList);
        this.model.getDb().getTableSessionUrl().setUrls(1, this.excludeFromProxyRegexs);
    }

    public void addExcludeFromProxyRegex(String string) throws DatabaseException {
        Pattern.compile(string, 2);
        this.excludeFromProxyRegexs.add(string);
        Control.getSingleton().setExcludeFromProxyUrls(this.excludeFromProxyRegexs);
        this.model.getDb().getTableSessionUrl().setUrls(1, this.excludeFromProxyRegexs);
    }

    public List<String> getExcludeFromScanRegexs() {
        return this.excludeFromScanRegexs;
    }

    public void addExcludeFromScanRegexs(String string) throws DatabaseException {
        Pattern.compile(string, 2);
        this.excludeFromScanRegexs.add(string);
        ExtensionActiveScan extensionActiveScan = (ExtensionActiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionActiveScan");
        if (extensionActiveScan != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.excludeFromScanRegexs);
            arrayList.addAll(this.globalExcludeURLRegexs);
            extensionActiveScan.setExcludeList(arrayList);
        }
        this.model.getDb().getTableSessionUrl().setUrls(2, this.excludeFromScanRegexs);
    }

    public void setExcludeFromScanRegexs(List<String> list) throws DatabaseException {
        for (String object : list) {
            Pattern.compile(object, 2);
        }
        this.excludeFromScanRegexs = this.stripEmptyLines(list);
        ExtensionActiveScan extensionActiveScan = (ExtensionActiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionActiveScan");
        if (extensionActiveScan != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.excludeFromScanRegexs);
            arrayList.addAll(this.globalExcludeURLRegexs);
            extensionActiveScan.setExcludeList(arrayList);
        }
        this.model.getDb().getTableSessionUrl().setUrls(2, this.excludeFromScanRegexs);
    }

    public List<String> getExcludeFromSpiderRegexs() {
        return this.excludeFromSpiderRegexs;
    }

    public void addExcludeFromSpiderRegex(String string) throws DatabaseException {
        Pattern.compile(string, 2);
        this.excludeFromSpiderRegexs.add(string);
        ExtensionSpider extensionSpider = (ExtensionSpider)Control.getSingleton().getExtensionLoader().getExtension("ExtensionSpider");
        if (extensionSpider != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.excludeFromSpiderRegexs);
            arrayList.addAll(this.globalExcludeURLRegexs);
            extensionSpider.setExcludeList(arrayList);
        }
        this.model.getDb().getTableSessionUrl().setUrls(3, this.excludeFromSpiderRegexs);
    }

    public void setExcludeFromSpiderRegexs(List<String> list) throws DatabaseException {
        for (String object : list) {
            Pattern.compile(object, 2);
        }
        this.excludeFromSpiderRegexs = this.stripEmptyLines(list);
        ExtensionSpider extensionSpider = (ExtensionSpider)Control.getSingleton().getExtensionLoader().getExtension("ExtensionSpider");
        if (extensionSpider != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.excludeFromSpiderRegexs);
            arrayList.addAll(this.globalExcludeURLRegexs);
            extensionSpider.setExcludeList(arrayList);
        }
        this.model.getDb().getTableSessionUrl().setUrls(3, this.excludeFromSpiderRegexs);
    }

    public void forceGlobalExcludeURLRefresh() throws DatabaseException {
        List<String> list = this.getExcludeFromProxyRegexs();
        log.debug((Object)("forceGlobalExcludeURLRefresh proxy: " + list.toString()));
        this.setExcludeFromProxyRegexs(list);
        list = this.getExcludeFromScanRegexs();
        log.debug((Object)("forceGlobalExcludeURLRefresh ascan: " + list.toString()));
        this.setExcludeFromScanRegexs(list);
        list = this.getExcludeFromSpiderRegexs();
        log.debug((Object)("forceGlobalExcludeURLRefresh spider: " + list.toString()));
        this.setExcludeFromSpiderRegexs(list);
    }

    public List<String> getGlobalExcludeURLRegexs() {
        return this.globalExcludeURLRegexs;
    }

    public void addGlobalExcludeURLRegexs(String string) throws DatabaseException {
        Pattern.compile(string, 2);
        this.globalExcludeURLRegexs.add(string);
    }

    public void setGlobalExcludeURLRegexs(List<String> list) throws DatabaseException {
        for (String string : list) {
            Pattern.compile(string, 2);
        }
        this.globalExcludeURLRegexs = this.stripEmptyLines(list);
        log.debug((Object)"setGlobalExcludeURLRegexs");
    }

    public void setSessionUrls(int n, List<String> list) throws DatabaseException {
        this.model.getDb().getTableSessionUrl().setUrls(n, list);
    }

    public void setSessionUrl(int n, String string) throws DatabaseException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        this.setSessionUrls(n, arrayList);
    }

    public List<String> getSessionUrls(int n) throws DatabaseException {
        List<RecordSessionUrl> list = this.model.getDb().getTableSessionUrl().getUrlsForType(n);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (RecordSessionUrl recordSessionUrl : list) {
            arrayList.add(recordSessionUrl.getUrl());
        }
        return arrayList;
    }

    public List<String> getContextDataStrings(int n, int n2) throws DatabaseException {
        List<RecordContext> list = this.model.getDb().getTableContext().getDataForContextAndType(n, n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RecordContext recordContext : list) {
            arrayList.add(recordContext.getData());
        }
        return arrayList;
    }

    public void setContextData(int n, int n2, String string) throws DatabaseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.setContextData(n, n2, arrayList);
    }

    public void setContextData(int n, int n2, List<String> list) throws DatabaseException {
        this.model.getDb().getTableContext().setData(n, n2, list);
    }

    public void clearContextDataForType(int n, int n2) throws DatabaseException {
        this.model.getDb().getTableContext().deleteAllDataForContextAndType(n, n2);
    }

    public void clearContextData(int n) throws DatabaseException {
        this.model.getDb().getTableContext().deleteAllDataForContext(n);
    }

    private List<String> techListToStringList(TreeSet<Tech> treeSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Tech> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        return arrayList;
    }

    private List<String> snmListToStringList(List<StructuralNodeModifier> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StructuralNodeModifier structuralNodeModifier : list) {
            arrayList.add(structuralNodeModifier.getConfig());
        }
        return arrayList;
    }

    public void saveContext(Context context) {
        try {
            this.setContextData(context.getIndex(), 1, context.getName());
            this.setContextData(context.getIndex(), 2, context.getDescription());
            this.setContextData(context.getIndex(), 5, Boolean.toString(context.isInScope()));
            this.setContextData(context.getIndex(), 3, context.getIncludeInContextRegexs());
            this.setContextData(context.getIndex(), 4, context.getExcludeFromContextRegexs());
            this.setContextData(context.getIndex(), 6, this.techListToStringList(context.getTechSet().getIncludeTech()));
            this.setContextData(context.getIndex(), 7, this.techListToStringList(context.getTechSet().getExcludeTech()));
            this.setContextData(context.getIndex(), 400, context.getUrlParamParser().getClass().getCanonicalName());
            this.setContextData(context.getIndex(), 401, context.getUrlParamParser().getConfig());
            this.setContextData(context.getIndex(), 402, context.getPostParamParser().getClass().getCanonicalName());
            this.setContextData(context.getIndex(), 403, context.getPostParamParser().getConfig());
            this.setContextData(context.getIndex(), 404, this.snmListToStringList(context.getDataDrivenNodes()));
            this.model.saveContext(context);
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        if (View.isInitialised()) {
            View.getSingleton().changeContext(context);
            this.refreshScope();
        }
    }

    public void saveAllContexts() {
        for (Context context : this.contexts) {
            this.saveContext(context);
        }
    }

    public Context getNewContext(String string) {
        Context context = new Context(this, this.nextContextIndex++);
        context.setName(string);
        this.addContext(context);
        return context;
    }

    public void addContext(Context context) {
        this.contexts.add(context);
        this.model.loadContext(context);
        for (OnContextsChangedListener onContextsChangedListener : this.contextsChangedListeners) {
            onContextsChangedListener.contextAdded(context);
        }
        if (View.isInitialised()) {
            View.getSingleton().addContext(context);
        }
    }

    public void deleteContext(Context context) {
        this.contexts.remove(context);
        try {
            this.clearContextData(context.getIndex());
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        for (OnContextsChangedListener onContextsChangedListener : this.contextsChangedListeners) {
            onContextsChangedListener.contextDeleted(context);
        }
        if (View.isInitialised()) {
            View.getSingleton().deleteContext(context);
            this.refreshScope();
        }
    }

    public Context getContext(int n) {
        for (Context context : this.contexts) {
            if (context.getIndex() != n) continue;
            return context;
        }
        return null;
    }

    public Context getContext(String string) {
        for (Context context : this.contexts) {
            if (!context.getName().equals(string)) continue;
            return context;
        }
        return null;
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    public List<Context> getContextsForNode(SiteNode siteNode) {
        if (siteNode == null) {
            return new ArrayList<Context>();
        }
        return this.getContextsForUrl(siteNode.getHierarchicNodeName());
    }

    public List<Context> getContextsForUrl(String string) {
        ArrayList<Context> arrayList = new ArrayList<Context>();
        if (string.indexOf("?") > 0) {
            string = string.substring(0, string.indexOf("?"));
        }
        for (Context context : this.contexts) {
            if (!context.isInContext(string)) continue;
            arrayList.add(context);
        }
        return arrayList;
    }

    public void exportContext(int n, File file) throws ConfigurationException {
        this.exportContext(this.getContext(n), file);
    }

    public void exportContext(Context context, File file) throws ConfigurationException {
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        zapXmlConfiguration.setProperty("context.name", context.getName());
        zapXmlConfiguration.setProperty("context.desc", context.getDescription());
        zapXmlConfiguration.setProperty("context.inscope", context.isInScope());
        zapXmlConfiguration.setProperty("context.incregexes", context.getIncludeInContextRegexs());
        zapXmlConfiguration.setProperty("context.excregexes", context.getExcludeFromContextRegexs());
        zapXmlConfiguration.setProperty("context.tech.include", this.techListToStringList(context.getTechSet().getIncludeTech()));
        zapXmlConfiguration.setProperty("context.tech.exclude", this.techListToStringList(context.getTechSet().getExcludeTech()));
        zapXmlConfiguration.setProperty("context.urlparser.class", context.getUrlParamParser().getClass().getCanonicalName());
        zapXmlConfiguration.setProperty("context.urlparser.config", context.getUrlParamParser().getConfig());
        zapXmlConfiguration.setProperty("context.postparser.class", context.getPostParamParser().getClass().getCanonicalName());
        zapXmlConfiguration.setProperty("context.postparser.config", context.getPostParamParser().getConfig());
        for (StructuralNodeModifier structuralNodeModifier : context.getDataDrivenNodes()) {
            zapXmlConfiguration.setProperty("context.ddns", structuralNodeModifier.getConfig());
        }
        this.model.exportContext(context, (Configuration)zapXmlConfiguration);
        zapXmlConfiguration.save(file);
    }

    public Context importContext(File file) throws ConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Object object3;
        Object object22;
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(file);
        Context context = this.getNewContext(zapXmlConfiguration.getString("context.name"));
        context.setDescription("context.desc");
        context.setInScope(zapXmlConfiguration.getBoolean("context.inscope"));
        for (Object object22 : zapXmlConfiguration.getList("context.incregexes")) {
            context.addIncludeInContextRegex(object22.toString());
        }
        for (Object object22 : zapXmlConfiguration.getList("context.excregexes")) {
            context.addExcludeFromContextRegex(object22.toString());
        }
        TechSet techSet = new TechSet();
        for (Object object3 : zapXmlConfiguration.getList("context.tech.include")) {
            techSet.include(new Tech(object3.toString()));
        }
        for (Object object3 : zapXmlConfiguration.getList("context.tech.exclude")) {
            techSet.exclude(new Tech(object3.toString()));
        }
        context.setTechSet(techSet);
        object22 = zapXmlConfiguration.getString("context.urlparser.class");
        if (object22 == null) {
            object22 = zapXmlConfiguration.getString("context.urlparser");
        }
        if ((object3 = ExtensionFactory.getAddOnLoader().loadClass((String)object22)) == null) {
            throw new ConfigurationException("Failed to load URL parser for context " + (String)object22);
        }
        Object object4 = (ParameterParser)((Class)object3).getConstructor(new Class[0]).newInstance(new Object[0]);
        object4.init(zapXmlConfiguration.getString("context.urlparser.config"));
        object4.setContext(context);
        context.setUrlParamParser((ParameterParser)object4);
        object4 = zapXmlConfiguration.getString("context.postparser.class");
        String string = zapXmlConfiguration.getString("context.postparser.config");
        if (object4 == null) {
            object4 = zapXmlConfiguration.getString((String)object22);
            string = zapXmlConfiguration.getString("context.urlparser.config");
        }
        if ((object3 = ExtensionFactory.getAddOnLoader().loadClass((String)object4)) == null) {
            throw new ConfigurationException("Failed to load POST parser for context " + (String)object4);
        }
        ParameterParser parameterParser = (ParameterParser)((Class)object3).getConstructor(new Class[0]).newInstance(new Object[0]);
        parameterParser.init(string);
        parameterParser.setContext(context);
        context.setPostParamParser(parameterParser);
        for (Object e : zapXmlConfiguration.getList("context.ddns")) {
            context.addDataDrivenNodes(new StructuralNodeModifier(e.toString()));
        }
        this.model.importContext(context, (Configuration)zapXmlConfiguration);
        context.restructureSiteTree();
        Model.getSingleton().getSession().saveContext(context);
        return context;
    }

    public ParameterParser getUrlParamParser(String string) {
        List<Context> list = this.getContextsForUrl(string);
        if (list.size() > 0) {
            return list.get(0).getUrlParamParser();
        }
        return this.defaultParamParser;
    }

    public ParameterParser getFormParamParser(String string) {
        List<Context> list = this.getContextsForUrl(string);
        if (list.size() > 0) {
            return list.get(0).getPostParamParser();
        }
        return this.defaultParamParser;
    }

    public Map<String, String> getParams(HttpMessage httpMessage, HtmlParameter.Type type) {
        switch (type) {
            case form: {
                return this.getFormParamParser(httpMessage.getRequestHeader().getURI().toString()).getParams(httpMessage, type);
            }
            case url: {
                return this.getUrlParamParser(httpMessage.getRequestHeader().getURI().toString()).getParams(httpMessage, type);
            }
        }
        throw new InvalidParameterException("Type not supported: " + (Object)((Object)type));
    }

    public Map<String, String> getUrlParams(URI uRI) throws URIException {
        return this.getUrlParamParser(uRI.toString()).parse(uRI.getQuery());
    }

    public Map<String, String> getFormParams(URI uRI, String string) throws URIException {
        return this.getFormParamParser(uRI.toString()).parse(string);
    }

    public List<String> getTreePath(URI uRI) throws URIException {
        return this.getUrlParamParser(uRI.toString()).getTreePath(uRI);
    }

    public List<String> getTreePath(HttpMessage httpMessage) throws URIException {
        URI uRI = httpMessage.getRequestHeader().getURI();
        return this.getUrlParamParser(uRI.toString()).getTreePath(httpMessage);
    }

    public void addOnContextsChangedListener(OnContextsChangedListener onContextsChangedListener) {
        this.contextsChangedListeners.add(onContextsChangedListener);
    }

    public void removeOnContextsChangedListener(OnContextsChangedListener onContextsChangedListener) {
        this.contextsChangedListeners.remove(onContextsChangedListener);
    }

    public static interface OnContextsChangedListener {
        public void contextAdded(Context var1);

        public void contextDeleted(Context var1);

        public void contextsChanged();
    }
}

