/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableContext;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableParam;
import org.parosproxy.paros.db.TableScan;
import org.parosproxy.paros.db.TableSession;
import org.parosproxy.paros.db.TableSessionUrl;
import org.parosproxy.paros.db.TableStructure;
import org.parosproxy.paros.db.TableTag;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlDatabaseServer;
import org.zaproxy.zap.db.sql.SqlTableAlert;
import org.zaproxy.zap.db.sql.SqlTableContext;
import org.zaproxy.zap.db.sql.SqlTableHistory;
import org.zaproxy.zap.db.sql.SqlTableParam;
import org.zaproxy.zap.db.sql.SqlTableScan;
import org.zaproxy.zap.db.sql.SqlTableSession;
import org.zaproxy.zap.db.sql.SqlTableSessionUrl;
import org.zaproxy.zap.db.sql.SqlTableStructure;
import org.zaproxy.zap.db.sql.SqlTableTag;

public class SqlDatabase
implements Database {
    private SqlDatabaseServer databaseServer = null;
    private TableHistory tableHistory = null;
    private TableSession tableSession = null;
    private TableAlert tableAlert = null;
    private TableScan tableScan = null;
    private TableTag tableTag = null;
    private TableSessionUrl tableSessionUrl = null;
    private TableParam tableParam = null;
    private TableContext tableContext = null;
    private TableStructure tableStructure = null;
    private static final Logger log = Logger.getLogger(SqlDatabase.class);
    private Vector<DatabaseListener> listenerList = new Vector();

    public SqlDatabase() {
        this.tableAlert = new SqlTableAlert();
        this.tableContext = new SqlTableContext();
        this.tableHistory = new SqlTableHistory();
        this.tableParam = new SqlTableParam();
        this.tableScan = new SqlTableScan();
        this.tableSession = new SqlTableSession();
        this.tableSessionUrl = new SqlTableSessionUrl();
        this.tableTag = new SqlTableTag();
        this.tableStructure = new SqlTableStructure();
        this.addDatabaseListener(DbSQL.getSingleton());
        this.addDatabaseListener(this.tableHistory);
        this.addDatabaseListener(this.tableSession);
        this.addDatabaseListener(this.tableAlert);
        this.addDatabaseListener(this.tableScan);
        this.addDatabaseListener(this.tableTag);
        this.addDatabaseListener(this.tableSessionUrl);
        this.addDatabaseListener(this.tableParam);
        this.addDatabaseListener(this.tableContext);
        this.addDatabaseListener(this.tableStructure);
    }

    @Override
    public DatabaseServer getDatabaseServer() {
        return this.databaseServer;
    }

    protected void setDatabaseServer(SqlDatabaseServer sqlDatabaseServer) {
        this.databaseServer = sqlDatabaseServer;
    }

    @Override
    public TableHistory getTableHistory() {
        return this.tableHistory;
    }

    @Override
    public TableSession getTableSession() {
        return this.tableSession;
    }

    @Override
    public void addDatabaseListener(DatabaseListener databaseListener) {
        this.listenerList.add(databaseListener);
    }

    @Override
    public void removeDatabaseListener(DatabaseListener databaseListener) {
        this.listenerList.remove(databaseListener);
    }

    protected void notifyListenerDatabaseOpen() throws DatabaseException {
        DatabaseListener databaseListener = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            databaseListener = this.listenerList.get(i);
            try {
                databaseListener.databaseOpen(this.getDatabaseServer());
                continue;
            }
            catch (DatabaseUnsupportedException databaseUnsupportedException) {
                log.error((Object)databaseUnsupportedException.getMessage(), (Throwable)databaseUnsupportedException);
            }
        }
    }

    @Override
    public void open(String string) throws ClassNotFoundException, Exception {
        log.debug((Object)("open " + string));
        this.setDatabaseServer(new SqlDatabaseServer(string));
        this.notifyListenerDatabaseOpen();
    }

    @Override
    public void close(boolean bl) {
        this.close(bl, true);
    }

    @Override
    public void deleteSession(String string) {
        log.debug((Object)("deleteSession " + string));
        if (this.databaseServer == null) {
            return;
        }
        this.databaseServer = null;
    }

    @Override
    public void close(boolean bl, boolean bl2) {
        log.debug((Object)"close");
        if (this.databaseServer == null) {
            return;
        }
        try {
            if (bl2) {
                this.getTableHistory().deleteTemporary();
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public boolean isFileBased() {
        return false;
    }

    @Override
    public TableAlert getTableAlert() {
        return this.tableAlert;
    }

    @Override
    public void setTableAlert(TableAlert tableAlert) {
        this.tableAlert = tableAlert;
    }

    @Override
    public TableScan getTableScan() {
        return this.tableScan;
    }

    @Override
    public void setTableScan(TableScan tableScan) {
        this.tableScan = tableScan;
    }

    @Override
    public TableTag getTableTag() {
        return this.tableTag;
    }

    @Override
    public void setTableTag(TableTag tableTag) {
        this.tableTag = tableTag;
    }

    @Override
    public TableSessionUrl getTableSessionUrl() {
        return this.tableSessionUrl;
    }

    @Override
    public void setTableSessionUrl(TableSessionUrl tableSessionUrl) {
        this.tableSessionUrl = tableSessionUrl;
    }

    @Override
    public TableParam getTableParam() {
        return this.tableParam;
    }

    @Override
    public TableContext getTableContext() {
        return this.tableContext;
    }

    @Override
    public TableStructure getTableStructure() {
        return this.tableStructure;
    }

    @Override
    public String getType() {
        return DbSQL.getDbType();
    }
}

