/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class NodeJSAPIGenerator {
    private File dir;
    private boolean optional = false;
    private final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private final String OPTIONAL_MASSAGE = "This component is optional and therefore the API will only work if it is installed";
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    private static final Map<String, String> nameMap;

    public NodeJSAPIGenerator() {
        this.dir = new File("nodejs/api/zapv2");
    }

    public NodeJSAPIGenerator(String string, boolean bl) {
        this.dir = new File(string);
        this.optional = bl;
    }

    public void generateNodeJSFiles(List<ApiImplementor> list) throws IOException {
        for (ApiImplementor apiImplementor : list) {
            this.generateNodeJSComponent(apiImplementor);
        }
    }

    private void generateNodeJSElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        Object object;
        boolean bl;
        String string3;
        block29: {
            string3 = NodeJSAPIGenerator.createClassName(string);
            bl = false;
            String string4 = apiElement.getDescriptionTag();
            if (string4 == null) {
                string4 = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                object = this.msgs.getString(string4);
                writer.write("/**\n");
                writer.write(" * " + (String)object + "\n");
                if (this.optional) {
                    writer.write(" * This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write(" **/\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string4);
                if (!this.optional) break block29;
                writer.write("/**\n");
                writer.write(" * This component is optional and therefore the API will only work if it is installed\n");
                writer.write(" **/\n");
            }
        }
        writer.write(string3 + ".prototype." + NodeJSAPIGenerator.createMethodName(apiElement.getName()) + " = function (");
        if (apiElement.getMandatoryParamNames() != null) {
            for (String string5 : apiElement.getMandatoryParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                writer.write(NodeJSAPIGenerator.safeName(string5.toLowerCase()));
            }
        }
        if (apiElement.getOptionalParamNames() != null) {
            for (String string5 : apiElement.getOptionalParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                writer.write(NodeJSAPIGenerator.safeName(string5.toLowerCase()));
            }
        }
        if (string2.equals("action") || string2.equals("other")) {
            if (bl) {
                writer.write(", ");
            }
            bl = true;
            writer.write(API.API_KEY_PARAM);
        }
        if (bl) {
            writer.write(", ");
        }
        writer.write("callback) {\n");
        if (string2.equals("action") || string2.equals("other")) {
            writer.write("  if (!callback && typeof(" + API.API_KEY_PARAM + ") === 'function') {\n");
            writer.write("    callback = " + API.API_KEY_PARAM + ";\n");
            writer.write("    " + API.API_KEY_PARAM + " = null;\n");
            writer.write("  }\n");
        }
        object = "request";
        if (string2.equals("other")) {
            object = "requestOther";
        }
        writer.write("  this.api." + (String)object + "('/" + string + "/" + string2 + "/" + apiElement.getName() + "/'");
        if (bl) {
            writer.write(", {");
            boolean bl2 = true;
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string6 : apiElement.getMandatoryParamNames()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        writer.write(", ");
                    }
                    writer.write("'" + string6 + "' : " + NodeJSAPIGenerator.safeName(string6.toLowerCase()));
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string6 : apiElement.getOptionalParamNames()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        writer.write(", ");
                    }
                    writer.write("'" + string6 + "' : " + NodeJSAPIGenerator.safeName(string6.toLowerCase()));
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                if (bl2) {
                    bl2 = false;
                } else {
                    writer.write(", ");
                }
                writer.write("'" + API.API_KEY_PARAM + "' : " + API.API_KEY_PARAM);
            }
            writer.write("}");
        }
        writer.write(", callback);\n");
        writer.write("};\n\n");
    }

    private static String safeName(String string) {
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        return string;
    }

    private static String createFileName(String string) {
        return NodeJSAPIGenerator.safeName(string) + ".js";
    }

    private static String createMethodName(String string) {
        return NodeJSAPIGenerator.removeAllFullStopCharacters(NodeJSAPIGenerator.safeName(string));
    }

    private static String createClassName(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private void generateNodeJSComponent(ApiImplementor apiImplementor) throws IOException {
        String string = NodeJSAPIGenerator.createClassName(apiImplementor.getPrefix());
        File file = new File(this.dir, NodeJSAPIGenerator.createFileName(apiImplementor.getPrefix()));
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
        fileWriter.write("'use strict';\n\n");
        fileWriter.write("/**\n");
        fileWriter.write(" * This file was automatically generated.\n");
        fileWriter.write(" */\n");
        fileWriter.write("function " + string + "(clientApi) {\n");
        fileWriter.write("  this.api = clientApi;\n");
        fileWriter.write("}\n\n");
        for (ApiElement apiElement : apiImplementor.getApiViews()) {
            this.generateNodeJSElement(apiElement, apiImplementor.getPrefix(), "view", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiActions()) {
            this.generateNodeJSElement(apiElement, apiImplementor.getPrefix(), "action", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiOthers()) {
            this.generateNodeJSElement(apiElement, apiImplementor.getPrefix(), "other", fileWriter);
        }
        fileWriter.write("module.exports = " + string + ";\n");
        fileWriter.close();
    }

    public static void main(String[] stringArray) throws Exception {
        NodeJSAPIGenerator nodeJSAPIGenerator = new NodeJSAPIGenerator();
        nodeJSAPIGenerator.generateNodeJSFiles(ApiGeneratorUtils.getAllImplementors());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        hashMap.put("boolean", "bool");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

