/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.split.request;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestBodyStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.CaretVisibilityEnforcerOnFocusGain;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.model.DefaultTextHttpMessageLocation;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;
import org.zaproxy.zap.view.messagecontainer.http.SelectableContentHttpMessageContainer;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListenerAdapter;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightsManager;

public class HttpRequestBodyPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView
implements SelectableContentHttpMessageContainer {
    public static final String NAME = "HttpRequestBodySyntaxTextView";
    private MessageLocationProducerFocusListenerAdapter focusListenerAdapter;

    public HttpRequestBodyPanelSyntaxHighlightTextView(RequestBodyStringHttpPanelViewModel requestBodyStringHttpPanelViewModel) {
        super(requestBodyStringHttpPanelViewModel);
        this.getHttpPanelTextArea().setComponentPopupMenu(new HttpPanelSyntaxHighlightTextView.CustomPopupMenu(){
            private static final long serialVersionUID = -426000345249750052L;

            @Override
            public void show(Component component, int n, int n2) {
                if (!HttpRequestBodyPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().isFocusOwner()) {
                    HttpRequestBodyPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().requestFocusInWindow();
                }
                View.getSingleton().getPopupMenu().show(HttpRequestBodyPanelSyntaxHighlightTextView.this, n, n2);
            }
        });
    }

    @Override
    protected HttpRequestBodyPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return (HttpRequestBodyPanelSyntaxHighlightTextArea)super.getHttpPanelTextArea();
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpRequestBodyPanelSyntaxHighlightTextArea();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public Class<? extends MessageLocation> getMessageLocationClass() {
        return TextHttpMessageLocation.class;
    }

    @Override
    public MessageLocation getSelection() {
        return this.getHttpPanelTextArea().getSelection();
    }

    @Override
    public MessageLocationHighlightsManager create() {
        return this.getHttpPanelTextArea().create();
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation) {
        if (!this.supports(messageLocation)) {
            return null;
        }
        TextHttpMessageLocation textHttpMessageLocation = (TextHttpMessageLocation)messageLocation;
        return this.getHttpPanelTextArea().highlightImpl(textHttpMessageLocation, new TextMessageLocationHighlight(Color.LIGHT_GRAY));
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!this.supports(messageLocation) || !(messageLocationHighlight instanceof TextMessageLocationHighlight)) {
            return null;
        }
        TextHttpMessageLocation textHttpMessageLocation = (TextHttpMessageLocation)messageLocation;
        TextMessageLocationHighlight textMessageLocationHighlight = (TextMessageLocationHighlight)messageLocationHighlight;
        return this.getHttpPanelTextArea().highlightImpl(textHttpMessageLocation, textMessageLocationHighlight);
    }

    @Override
    public void removeHighlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!(messageLocationHighlight instanceof TextMessageLocationHighlight)) {
            return;
        }
        this.getHttpPanelTextArea().removeHighlight(((TextMessageLocationHighlight)messageLocationHighlight).getHighlightReference());
    }

    @Override
    public boolean supports(MessageLocation messageLocation) {
        if (!(messageLocation instanceof TextHttpMessageLocation)) {
            return false;
        }
        return ((TextHttpMessageLocation)messageLocation).getLocation() == HttpMessageLocation.Location.REQUEST_BODY;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> clazz) {
        return TextHttpMessageLocation.class.isAssignableFrom(clazz);
    }

    @Override
    public void addFocusListener(MessageLocationProducerFocusListener messageLocationProducerFocusListener) {
        this.getFocusListenerAdapter().addFocusListener(messageLocationProducerFocusListener);
    }

    @Override
    public void removeFocusListener(MessageLocationProducerFocusListener messageLocationProducerFocusListener) {
        this.getFocusListenerAdapter().removeFocusListener(messageLocationProducerFocusListener);
        if (!this.getFocusListenerAdapter().hasFocusListeners()) {
            this.getHttpPanelTextArea().removeFocusListener(this.focusListenerAdapter);
            this.focusListenerAdapter = null;
        }
    }

    @Override
    public HttpMessage getMessage() {
        return this.getHttpPanelTextArea().getMessage();
    }

    @Override
    public Component getComponent() {
        return this.getHttpPanelTextArea();
    }

    @Override
    public boolean isEmpty() {
        return this.getHttpPanelTextArea().getMessage() == null;
    }

    private MessageLocationProducerFocusListenerAdapter getFocusListenerAdapter() {
        if (this.focusListenerAdapter == null) {
            this.focusListenerAdapter = new MessageLocationProducerFocusListenerAdapter(this);
            this.getHttpPanelTextArea().addFocusListener(this.focusListenerAdapter);
        }
        return this.focusListenerAdapter;
    }

    private static class HttpRequestBodyPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = -2102275261139781996L;
        private static final String X_WWW_FORM_URLENCODED = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xWwwFormUrlencoded");
        private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
        private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
        private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");
        private static final String SYNTAX_STYLE_X_WWW_FORM = "application/x-www-form-urlencoded";
        private static RequestBodyTokenMakerFactory tokenMakerFactory = null;
        private CaretVisibilityEnforcerOnFocusGain caretVisiblityEnforcer;

        public HttpRequestBodyPanelSyntaxHighlightTextArea() {
            this.addSyntaxStyle(X_WWW_FORM_URLENCODED, SYNTAX_STYLE_X_WWW_FORM);
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
            this.caretVisiblityEnforcer = new CaretVisibilityEnforcerOnFocusGain((JTextComponent)((Object)this));
        }

        public String getName() {
            return HttpRequestBodyPanelSyntaxHighlightTextView.NAME;
        }

        @Override
        public HttpMessage getMessage() {
            return (HttpMessage)super.getMessage();
        }

        @Override
        public void setMessage(Message message) {
            super.setMessage(message);
            this.caretVisiblityEnforcer.setEnforceVisibilityOnFocusGain(message != null);
        }

        protected MessageLocation getSelection() {
            int n;
            int n2 = this.getSelectionStart();
            if (n2 == (n = this.getSelectionEnd())) {
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_BODY, n2);
            }
            return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_BODY, n2, n, this.getSelectedText());
        }

        protected MessageLocationHighlightsManager create() {
            return new TextMessageLocationHighlightsManager();
        }

        protected MessageLocationHighlight highlightImpl(TextHttpMessageLocation textHttpMessageLocation, TextMessageLocationHighlight textMessageLocationHighlight) {
            textMessageLocationHighlight.setHighlightReference(this.highlight(textHttpMessageLocation.getStart(), textHttpMessageLocation.getEnd(), textMessageLocationHighlight));
            return textMessageLocationHighlight;
        }

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                list.add(new SearchMatch(SearchMatch.Location.REQUEST_BODY, matcher.start(), matcher.end()));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            if (!SearchMatch.Location.REQUEST_BODY.equals((Object)searchMatch.getLocation())) {
                return;
            }
            int n = this.getText().length();
            if (searchMatch.getStart() > n || searchMatch.getEnd() > n) {
                return;
            }
            this.highlight(searchMatch.getStart(), searchMatch.getEnd());
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String string;
            String string2 = null;
            if (httpMessage != null && httpMessage.getRequestHeader() != null && (string = httpMessage.getRequestHeader().getHeader("Content-Type")) != null && !string.isEmpty()) {
                int n = (string = string.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (n != -1) {
                    string = string.substring(0, n).trim();
                }
                string2 = string.contains("javascript") ? "text/javascript" : (string.contains("json") ? "text/json" : (string.contains("xml") ? "text/xml" : string));
            }
            return string2;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new RequestBodyTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class RequestBodyTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public RequestBodyTokenMakerFactory() {
                String string = "org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.lexers.";
                this.putMapping(HttpRequestBodyPanelSyntaxHighlightTextArea.SYNTAX_STYLE_X_WWW_FORM, string + "WwwFormTokenMaker");
                string = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/javascript", string + "JavaScriptTokenMaker");
                this.putMapping("text/json", string + "JsonTokenMaker");
                this.putMapping("text/xml", string + "XMLTokenMaker");
            }
        }
    }
}

