/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.Collection;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.params.ExtensionParams;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.SiteParameters;

public class ParamsAPI
extends ApiImplementor {
    private static final String PREFIX = "params";
    private static final String VIEW_PARAMS = "params";
    private static final String VIEW_PARAMS_PARAM_SITE = "site";
    private ExtensionParams extension;

    public ParamsAPI(ExtensionParams extensionParams) {
        this.extension = extensionParams;
        this.addApiView(new ApiView("params", new String[0], new String[]{VIEW_PARAMS_PARAM_SITE}));
    }

    @Override
    public String getPrefix() {
        return "params";
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        if ("params".equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList("Parameters");
            Collection<SiteParameters> collection = this.extension.getAllSiteParameters();
            for (SiteParameters siteParameters : collection) {
                for (HtmlParameterStats htmlParameterStats : siteParameters.getParams()) {
                    ApiResponseList apiResponseList2 = new ApiResponseList("Parameter");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(VIEW_PARAMS_PARAM_SITE, htmlParameterStats.getSite());
                    hashMap.put("name", htmlParameterStats.getName());
                    hashMap.put("type", htmlParameterStats.getType().name());
                    hashMap.put("timesUsed", String.valueOf(htmlParameterStats.getTimesUsed()));
                    apiResponseList2.addItem(new ApiResponseSet("Stats", hashMap));
                    ApiResponseList apiResponseList3 = new ApiResponseList("Flags");
                    for (String string2 : htmlParameterStats.getFlags()) {
                        apiResponseList3.addItem(new ApiResponseElement("Flag", string2));
                    }
                    if (htmlParameterStats.getFlags().size() > 0) {
                        apiResponseList2.addItem(apiResponseList3);
                    }
                    ApiResponseList apiResponseList4 = new ApiResponseList("Values");
                    for (String string3 : htmlParameterStats.getValues()) {
                        apiResponseList4.addItem(new ApiResponseElement("Value", string3));
                    }
                    if (htmlParameterStats.getValues().size() > 0) {
                        apiResponseList2.addItem(apiResponseList4);
                    }
                    apiResponseList.addItem(apiResponseList2);
                }
            }
            return apiResponseList;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }
}

