/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Desktop;
import java.net.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;

public class DesktopUtils {
    private static BrowserInvoker DEFAULT_INVOKER = BrowserInvoker.desktop;
    private static BrowserInvoker invoker;
    private static BrowserLauncher launcher;
    private static Logger log;

    public static boolean openUrlInBrowser(URI uRI) {
        try {
            switch (DesktopUtils.getInvoker()) {
                case desktop: {
                    if (!Desktop.isDesktopSupported()) break;
                    Desktop.getDesktop().browse(uRI);
                    return true;
                }
                case browserlauncher: {
                    DesktopUtils.getBrowserLauncher().openURLinBrowser(uRI.toString());
                    return true;
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            invoker = BrowserInvoker.none;
        }
        return false;
    }

    public static boolean openUrlInBrowser(String string) {
        try {
            return DesktopUtils.openUrlInBrowser(new URI(string));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            invoker = BrowserInvoker.none;
            return false;
        }
    }

    public static boolean openUrlInBrowser(org.apache.commons.httpclient.URI uRI) {
        try {
            return DesktopUtils.openUrlInBrowser(uRI.toString());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            invoker = BrowserInvoker.none;
            return false;
        }
    }

    public static boolean canOpenUrlInBrowser() {
        switch (DesktopUtils.getInvoker()) {
            case desktop: {
                if (!Desktop.isDesktopSupported()) {
                    return false;
                }
            }
            case browserlauncher: {
                return true;
            }
        }
        return false;
    }

    private static BrowserInvoker getInvoker() {
        if (invoker == null) {
            try {
                invoker = BrowserInvoker.valueOf(Model.getSingleton().getOptionsParam().getConfig().getString("TBA", DEFAULT_INVOKER.name()));
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                invoker = DEFAULT_INVOKER;
            }
        }
        return invoker;
    }

    private static BrowserLauncher getBrowserLauncher() throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        if (launcher == null) {
            DesktopUtils.createBrowserLauncher();
        }
        return launcher;
    }

    private static synchronized void createBrowserLauncher() throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        if (launcher == null) {
            launcher = new BrowserLauncher();
        }
    }

    static {
        DEFAULT_INVOKER = Desktop.isDesktopSupported() ? BrowserInvoker.desktop : BrowserInvoker.browserlauncher;
        invoker = null;
        launcher = null;
        log = Logger.getLogger(DesktopUtils.class);
    }

    private static enum BrowserInvoker {
        desktop,
        browserlauncher,
        none;

    }
}

