/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.VertexBuffer;

class ES2VertexBuffer
extends VertexBuffer {
    private GLContext glCtx;
    protected static final int BYTES_PER_FLOAT = 4;

    ES2VertexBuffer(int n) {
        super(n);
    }

    void enableVertexAttributes(GLContext gLContext) {
        this.glCtx = gLContext;
        gLContext.enableVertexAttributes();
    }

    @Override
    protected void drawQuads(int n) {
        this.glCtx.drawIndexedQuads(this.coordArray, this.colorArray, n);
    }

    @Override
    protected void drawTriangles(int n, float[] fArray, byte[] byArray) {
        this.glCtx.drawTriangleList(n, fArray, byArray);
    }

    public static short[] getQuadIndices16bit(int n) {
        short[] sArray = new short[n * 6];
        for (int i = 0; i != n; ++i) {
            int n2 = i * 4;
            int n3 = i * 6;
            sArray[n3 + 0] = (short)(n2 + 0);
            sArray[n3 + 1] = (short)(n2 + 1);
            sArray[n3 + 2] = (short)(n2 + 2);
            sArray[n3 + 3] = (short)(n2 + 2);
            sArray[n3 + 4] = (short)(n2 + 1);
            sArray[n3 + 5] = (short)(n2 + 3);
        }
        return sArray;
    }

    public int genQuadsIndexBuffer(int n) {
        if (n * 6 > 65536) {
            throw new IllegalArgumentException("vertex indices overflow");
        }
        return this.glCtx.createIndexBuffer16(ES2VertexBuffer.getQuadIndices16bit(n));
    }
}

