/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCipher;
import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.ConstructKeys;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

abstract class AESWrapCipher
extends CipherSpi {
    private static final byte[] IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private static final int blksize = 16;
    private AESCrypt cipher = new AESCrypt();
    private boolean decrypting = false;
    private final int fixedKeySize;

    public AESWrapCipher(int keySize) {
        this.fixedKeySize = keySize;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException(mode + " cannot be used");
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException(padding + " cannot be used");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        int result = 0;
        result = this.decrypting ? inputLen - 8 : inputLen + 8;
        return result < 0 ? 0 : result;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (opmode == 3) {
            this.decrypting = false;
        } else if (opmode == 4) {
            this.decrypting = true;
        } else {
            throw new UnsupportedOperationException("This cipher can only be used for key wrapping and unwrapping");
        }
        AESCipher.checkKeySize(key, this.fixedKeySize);
        this.cipher.init(this.decrypting, key.getAlgorithm(), key.getEncoded());
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("This cipher does not accept any parameters");
        }
        this.engineInit(opmode, key, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("This cipher does not accept any parameters");
        }
        this.engineInit(opmode, key, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (!AESCrypt.isKeySizeValid(encoded.length)) {
            throw new InvalidKeyException("Invalid key length: " + encoded.length + " bytes");
        }
        return encoded.length * 8;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] keyVal = key.getEncoded();
        if (keyVal == null || keyVal.length == 0) {
            throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
        }
        byte[] out = new byte[keyVal.length + 8];
        if (keyVal.length == 8) {
            System.arraycopy(IV, 0, out, 0, IV.length);
            System.arraycopy(keyVal, 0, out, IV.length, 8);
            this.cipher.encryptBlock(out, 0, out, 0);
        } else {
            if (keyVal.length % 8 != 0) {
                throw new IllegalBlockSizeException("length of the to be wrapped key should be multiples of 8 bytes");
            }
            System.arraycopy(IV, 0, out, 0, IV.length);
            System.arraycopy(keyVal, 0, out, IV.length, keyVal.length);
            int N = keyVal.length / 8;
            byte[] buffer = new byte[16];
            for (int j = 0; j < 6; ++j) {
                for (int i = 1; i <= N; ++i) {
                    int T = i + j * N;
                    System.arraycopy(out, 0, buffer, 0, IV.length);
                    System.arraycopy(out, i * 8, buffer, IV.length, 8);
                    this.cipher.encryptBlock(buffer, 0, buffer, 0);
                    int k = 1;
                    while (T != 0) {
                        byte v = (byte)T;
                        int n = IV.length - k;
                        buffer[n] = (byte)(buffer[n] ^ v);
                        T >>>= 8;
                        ++k;
                    }
                    System.arraycopy(buffer, 0, out, 0, IV.length);
                    System.arraycopy(buffer, 8, out, 8 * i, 8);
                }
            }
        }
        return out;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        int wrappedKeyLen = wrappedKey.length;
        if (wrappedKeyLen == 0) {
            throw new InvalidKeyException("The wrapped key is empty");
        }
        if (wrappedKeyLen % 8 != 0) {
            throw new InvalidKeyException("The wrapped key has invalid key length");
        }
        byte[] out = new byte[wrappedKeyLen - 8];
        byte[] buffer = new byte[16];
        if (wrappedKeyLen == 16) {
            this.cipher.decryptBlock(wrappedKey, 0, buffer, 0);
            for (int i = 0; i < IV.length; ++i) {
                if (IV[i] == buffer[i]) continue;
                throw new InvalidKeyException("Integrity check failed");
            }
            System.arraycopy(buffer, IV.length, out, 0, out.length);
        } else {
            System.arraycopy(wrappedKey, 0, buffer, 0, IV.length);
            System.arraycopy(wrappedKey, IV.length, out, 0, out.length);
            int N = out.length / 8;
            for (int j = 5; j >= 0; --j) {
                for (int i = N; i > 0; --i) {
                    int T = i + j * N;
                    System.arraycopy(out, 8 * (i - 1), buffer, IV.length, 8);
                    int k = 1;
                    while (T != 0) {
                        byte v = (byte)T;
                        int n = IV.length - k;
                        buffer[n] = (byte)(buffer[n] ^ v);
                        T >>>= 8;
                        ++k;
                    }
                    this.cipher.decryptBlock(buffer, 0, buffer, 0);
                    System.arraycopy(buffer, IV.length, out, 8 * (i - 1), 8);
                }
            }
            for (int i = 0; i < IV.length; ++i) {
                if (IV[i] == buffer[i]) continue;
                throw new InvalidKeyException("Integrity check failed");
            }
        }
        return ConstructKeys.constructKey(out, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final class AES256
    extends AESWrapCipher {
        public AES256() {
            super(32);
        }
    }

    public static final class AES192
    extends AESWrapCipher {
        public AES192() {
            super(24);
        }
    }

    public static final class AES128
    extends AESWrapCipher {
        public AES128() {
            super(16);
        }
    }

    public static final class General
    extends AESWrapCipher {
        public General() {
            super(-1);
        }
    }
}

