/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.ReferenceNotInitializedException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.DigesterOutputStream;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    private static boolean useC14N11 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.org.apache.xml.internal.security.useC14N11");
        }
    });
    public static final boolean CacheSignedNodes = false;
    static Logger log = Logger.getLogger(Reference.class.getName());
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    Manifest _manifest = null;
    XMLSignatureInput _transformsOutput;
    private Transforms transforms;
    private Element digestMethodElem;
    private Element digestValueElement;

    protected Reference(Document doc, String BaseURI, String ReferenceURI, Manifest manifest, Transforms transforms, String messageDigestAlgorithm) throws XMLSignatureException {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = BaseURI;
        this._manifest = manifest;
        this.setURI(ReferenceURI);
        if (transforms != null) {
            this.transforms = transforms;
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        MessageDigestAlgorithm mda = MessageDigestAlgorithm.getInstance(this._doc, messageDigestAlgorithm);
        this.digestMethodElem = mda.getElement();
        this._constructionElement.appendChild(this.digestMethodElem);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.digestValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "DigestValue");
        this._constructionElement.appendChild(this.digestValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    protected Reference(Element element, String BaseURI, Manifest manifest) throws XMLSecurityException {
        super(element, BaseURI);
        this._baseURI = BaseURI;
        Element el = XMLUtils.getNextElement(element.getFirstChild());
        if ("Transforms".equals(el.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(el.getNamespaceURI())) {
            this.transforms = new Transforms(el, this._baseURI);
            el = XMLUtils.getNextElement(el.getNextSibling());
        }
        this.digestMethodElem = el;
        this.digestValueElement = XMLUtils.getNextElement(this.digestMethodElem.getNextSibling());
        this._manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        if (this.digestMethodElem == null) {
            return null;
        }
        String uri = this.digestMethodElem.getAttributeNS(null, "Algorithm");
        if (uri == null) {
            return null;
        }
        return MessageDigestAlgorithm.getInstance(this._doc, uri);
    }

    public void setURI(String URI2) {
        if (URI2 != null) {
            this._constructionElement.setAttributeNS(null, "URI", URI2);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String Id) {
        if (Id != null) {
            this.setLocalIdAttribute("Id", Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String Type2) {
        if (Type2 != null) {
            this._constructionElement.setAttributeNS(null, "Type", Type2);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean typeIsReferenceToObject() {
        return OBJECT_URI.equals(this.getType());
    }

    public boolean typeIsReferenceToManifest() {
        return MANIFEST_URI.equals(this.getType());
    }

    private void setDigestValueElement(byte[] digestValue) {
        for (Node n = this.digestValueElement.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.digestValueElement.removeChild(n);
        }
        String base64codedValue = Base64.encode(digestValue);
        Text t = this._doc.createTextNode(base64codedValue);
        this.digestValueElement.appendChild(t);
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        this.setDigestValueElement(this.calculateDigest(false));
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr URIAttr = this._constructionElement.getAttributeNodeNS(null, "URI");
            String URI2 = URIAttr == null ? null : URIAttr.getNodeValue();
            ResourceResolver resolver = ResourceResolver.getInstance(URIAttr, this._baseURI, this._manifest._perManifestResolvers);
            if (resolver == null) {
                Object[] exArgs = new Object[]{URI2};
                throw new ReferenceNotInitializedException("signature.Verification.Reference.NoInput", exArgs);
            }
            resolver.addProperties(this._manifest._resolverProperties);
            XMLSignatureInput input = resolver.resolve(URIAttr, this._baseURI);
            return input;
        }
        catch (ResourceResolverException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    public XMLSignatureInput getTransformsInput() throws ReferenceNotInitializedException {
        XMLSignatureInput result;
        XMLSignatureInput input = this.getContentsBeforeTransformation();
        try {
            result = new XMLSignatureInput(input.getBytes());
        }
        catch (CanonicalizationException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (IOException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        result.setSourceURI(input.getSourceURI());
        return result;
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput input, OutputStream os) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput output = null;
            if (transforms != null) {
                this._transformsOutput = output = transforms.performTransforms(input, os);
            } else {
                output = input;
            }
            return output;
        }
        catch (ResourceResolverException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (TransformationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput input = this.getContentsBeforeTransformation();
        return this.getContentsAfterTransformation(input, null);
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            XMLSignatureInput input;
            XMLSignatureInput output = input = this.getContentsBeforeTransformation();
            Transforms transforms = this.getTransforms();
            if (transforms != null) {
                Transform t;
                String URI2;
                for (int i = 0; !(i >= transforms.getLength() || (URI2 = (t = transforms.item(i)).getURI()).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || URI2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || URI2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || URI2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")); ++i) {
                    output = t.performTransform(output, null);
                }
                output.setSourceURI(input.getSourceURI());
            }
            return output;
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (ResourceResolverException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (TransformationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            XMLSignatureInput nodes = this.getNodesetBeforeFirstCanonicalization();
            Set inclusiveNamespaces = new HashSet();
            Transforms transforms = this.getTransforms();
            ElementProxy c14nTransform = null;
            if (transforms != null) {
                for (int i = 0; i < transforms.getLength(); ++i) {
                    Transform t = transforms.item(i);
                    String URI2 = t.getURI();
                    if (!URI2.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !URI2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) continue;
                    c14nTransform = t;
                    break;
                }
            }
            if (c14nTransform != null && c14nTransform.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                InclusiveNamespaces in = new InclusiveNamespaces(XMLUtils.selectNode(c14nTransform.getElement().getFirstChild(), "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", 0), this.getBaseURI());
                inclusiveNamespaces = InclusiveNamespaces.prefixStr2Set(in.getInclusiveNamespaces());
            }
            return nodes.getHTMLRepresentation(inclusiveNamespaces);
        }
        catch (TransformationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidTransformException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public XMLSignatureInput getTransformsOutput() {
        return this._transformsOutput;
    }

    protected XMLSignatureInput dereferenceURIandPerformTransforms(OutputStream os) throws XMLSignatureException {
        try {
            XMLSignatureInput output;
            XMLSignatureInput input = this.getContentsBeforeTransformation();
            this._transformsOutput = output = this.getContentsAfterTransformation(input, os);
            return output;
        }
        catch (XMLSecurityException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        return this.transforms;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            XMLSignatureInput output = this.dereferenceURIandPerformTransforms(null);
            byte[] signedBytes = output.getBytes();
            return signedBytes;
        }
        catch (IOException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    private byte[] calculateDigest(boolean validating) throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            MessageDigestAlgorithm mda = this.getMessageDigestAlgorithm();
            mda.reset();
            DigesterOutputStream diOs = new DigesterOutputStream(mda);
            UnsyncBufferedOutputStream os = new UnsyncBufferedOutputStream(diOs);
            XMLSignatureInput output = this.dereferenceURIandPerformTransforms(os);
            if (useC14N11 && !validating && !output.isOutputStreamSet() && !output.isOctetStream()) {
                if (this.transforms == null) {
                    this.transforms = new Transforms(this._doc);
                    this._constructionElement.insertBefore(this.transforms.getElement(), this.digestMethodElem);
                }
                this.transforms.addTransform("http://www.w3.org/2006/12/xml-c14n11");
                output.updateOutputStream(os, true);
            } else {
                output.updateOutputStream(os);
            }
            ((OutputStream)os).flush();
            return diOs.getDigestValue();
        }
        catch (XMLSecurityException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
        catch (IOException ex) {
            throw new ReferenceNotInitializedException("empty", ex);
        }
    }

    public byte[] getDigestValue() throws Base64DecodingException, XMLSecurityException {
        if (this.digestValueElement == null) {
            Object[] exArgs = new Object[]{"DigestValue", "http://www.w3.org/2000/09/xmldsig#"};
            throw new XMLSecurityException("signature.Verification.NoSignatureElement", exArgs);
        }
        byte[] elemDig = Base64.decode(this.digestValueElement);
        return elemDig;
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] calcDig;
        byte[] elemDig = this.getDigestValue();
        boolean equal = MessageDigestAlgorithm.isEqual(elemDig, calcDig = this.calculateDigest(true));
        if (!equal) {
            log.log(Level.WARNING, "Verification failed for URI \"" + this.getURI() + "\"");
            log.log(Level.WARNING, "Expected Digest: " + Base64.encode(elemDig));
            log.log(Level.WARNING, "Actual Digest: " + Base64.encode(calcDig));
        } else {
            log.log(Level.INFO, "Verification successful for URI \"" + this.getURI() + "\"");
        }
        return equal;
    }

    @Override
    public String getBaseLocalName() {
        return "Reference";
    }
}

