/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class SwitchToRecentDocumentAction
extends AbstractAction
implements PropertyChangeListener {
    public SwitchToRecentDocumentAction() {
        this.putValue("Name", NbBundle.getMessage(SwitchToRecentDocumentAction.class, (String)"CTL_SwitchToRecentDocumentAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent[] topComponentArray = windowManagerImpl.getRecentViewList();
        if (topComponentArray.length == 0) {
            return;
        }
        for (int i = 0; i < topComponentArray.length; ++i) {
            TopComponent topComponent = topComponentArray[i];
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            if (modeImpl == null || modeImpl.getKind() != 1) continue;
            if (modeImpl != windowManagerImpl.getCurrentMaximizedMode()) {
                windowManagerImpl.switchMaximizedMode(null);
            }
            topComponent.requestActive();
            break;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("opened".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        for (ModeImpl modeImpl : WindowManagerImpl.getInstance().getModes()) {
            if (modeImpl.getKind() != 1 || modeImpl.getOpenedTopComponents().isEmpty()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

