#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: lens
version: 4.13.1
id: lens-4.13.1-6a5b95f92a8423d4381fcfe97443e936
key: lens_5CmJxRQcJltGGL1KF3ByDW
license: BSD3
copyright: Copyright (C) 2012-2016 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/lens/
synopsis: Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.
    .
    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.
    .
    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.
    .
    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.
    .
    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.
    .
    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.
    .
    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.
    .
    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.
    .
    /Lenses, Folds and Traversals/
    .
    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:
    .
    .
    <<http://i.imgur.com/ALlbPRa.png>>
    .
    <Hierarchy.png (Local Copy)>
    .
    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.
    .
    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
    .
    For instance:
    .
    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
    .
    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
    .
    /Minimizing Dependencies/
    .
    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.
    .
    /e.g./ for a data type:
    .
    > data Foo a = Foo Int Int a
    .
    You can define lenses such as
    .
    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
    .
    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)
    .
    without the need to use any type that isn'\''t already defined in the @Prelude@.
    .
    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
    .
    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
    .
    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses, Generics
author: Edward A. Kmett
exposed: True
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.Coerce
    Control.Lens.Internal.Context Control.Lens.Internal.Deque
    Control.Lens.Internal.Exception Control.Lens.Internal.FieldTH
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.Review Control.Lens.Internal.Setter
    Control.Lens.Internal.TH Control.Lens.Internal.Zoom
    Control.Lens.Iso Control.Lens.Lens Control.Lens.Level
    Control.Lens.Operators Control.Lens.Plated Control.Lens.Prism
    Control.Lens.Reified Control.Lens.Review Control.Lens.Setter
    Control.Lens.TH Control.Lens.Traversal Control.Lens.Tuple
    Control.Lens.Type Control.Lens.Wrapped Control.Lens.Zoom
    Control.Monad.Error.Lens Control.Parallel.Strategies.Lens
    Control.Seq.Lens Data.Array.Lens Data.Bits.Lens
    Data.ByteString.Lens Data.ByteString.Strict.Lens
    Data.ByteString.Lazy.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lens
    Data.Text.Strict.Lens Data.Text.Lazy.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Lens Data.Vector.Generic.Lens
    Generics.Deriving.Lens GHC.Generics.Lens System.Exit.Lens
    System.FilePath.Lens System.IO.Error.Lens Language.Haskell.TH.Lens
    Numeric.Lens
hidden-modules: Paths_lens
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/lens-4.13.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/lens-4.13.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/lens-4.13.1
hs-libraries: HSlens-4.13.1-5CmJxRQcJltGGL1KF3ByDW
depends:
    array-0.5.1.0-a4b4f31b03b7779670557ea46745a386
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    base-orphans-0.5.0-a13c08e02979420be3bfcfc755842cf4
    bifunctors-5.2.1-ac140f775ddaa28955bf641042d171b3
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    comonad-5-caa084d849f0fd836e529854caff7fc2
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    contravariant-1.4-40742dd1a022cbf40c8c77a36d4f0610
    distributive-0.5.0.2-161dd77efe370865be21560ce248cc64
    exceptions-0.8.2.1-8c1fe53cd5846ab1f6d4c58870c4f8d9
    filepath-1.4.0.0-73e0bec80594160bf6dd6cb25217c6bf
    free-4.12.4-933d8993d0b07bad69ead57266997de9
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    hashable-1.2.4.0-f83fcc5c92d0a1ea59927aca6baa3161
    kan-extensions-5.0.1-e5d990517241029c169facb872795e8a
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    parallel-3.2.1.0-29613111a366ee1bb108c8999c15ba21
    profunctors-5.2-69458fa119e6a2dfd209808104f4439d
    reflection-2.1.1.1-ae18c3b9d268483159599b9d645bf383
    semigroupoids-5.0.1-71b3eb635555631c006bdf0054367a98
    semigroups-0.18.1-34c490e60d2f8a8cae75b79e944c6c08
    tagged-0.8.3-aa128de4449752177a05765fb0ce3959
    template-haskell-2.10.0.0-4b92ab565139fd81021b60a162b59eb8
    text-1.2.2.0-2f82ea4adfdd656d9a8840ad2ee17cc0
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    transformers-compat-0.5.1.4-b5340b5b89d4b4066d5de0d53e173907
    unordered-containers-0.2.6.0-2907cc2989779dea3b04f8a0a144a8a7
    vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
    void-0.7.1-662e5f28c19568c0aec0b2de7532ac34
haddock-interfaces: /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html: /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
