/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFText;

public final class PDFEncryptionJCE
extends PDFObject
implements PDFEncryption {
    private final MessageDigest digest;
    private byte[] encryptionKey;
    private String encryptionDictionary;

    private PDFEncryptionJCE(int objectNumber, PDFEncryptionParams params, PDFDocument pdf) {
        this.setObjectNumber(objectNumber);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        this.setDocument(pdf);
        EncryptionInitializer encryptionInitializer = new EncryptionInitializer(params);
        encryptionInitializer.init();
    }

    public static PDFEncryption make(int objectNumber, PDFEncryptionParams params, PDFDocument pdf) {
        return new PDFEncryptionJCE(objectNumber, params, pdf);
    }

    public byte[] encrypt(byte[] data, PDFObject refObj) {
        PDFObject o;
        for (o = refObj; o != null && !o.hasObjectNumber(); o = o.getParent()) {
        }
        if (o == null) {
            throw new IllegalStateException("No object number could be obtained for a PDF object");
        }
        byte[] key = this.createEncryptionKey(o.getObjectNumber(), o.getGeneration());
        return PDFEncryptionJCE.encryptWithKey(key, data);
    }

    public void applyFilter(AbstractPDFStream stream) {
        stream.getFilterList().addFilter(new EncryptionFilter(stream.getObjectNumber(), stream.getGeneration()));
    }

    public byte[] toPDF() {
        assert (this.encryptionDictionary != null);
        return PDFEncryptionJCE.encode(this.encryptionDictionary);
    }

    public String getTrailerEntry() {
        return "/Encrypt " + this.getObjectNumber() + " " + this.getGeneration() + " R\n";
    }

    private static byte[] encryptWithKey(byte[] key, byte[] data) {
        try {
            Cipher c = PDFEncryptionJCE.initCipher(key);
            return c.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static Cipher initCipher(byte[] key) {
        try {
            Cipher c = Cipher.getInstance("RC4");
            SecretKeySpec keyspec = new SecretKeySpec(key, "RC4");
            c.init(1, keyspec);
            return c;
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private byte[] createEncryptionKey(int objectNumber, int generationNumber) {
        byte[] md5Input = this.prepareMD5Input(objectNumber, generationNumber);
        this.digest.reset();
        byte[] hash = this.digest.digest(md5Input);
        int keyLength = Math.min(16, md5Input.length);
        byte[] key = new byte[keyLength];
        System.arraycopy(hash, 0, key, 0, keyLength);
        return key;
    }

    private byte[] prepareMD5Input(int objectNumber, int generationNumber) {
        byte[] md5Input = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, md5Input, 0, this.encryptionKey.length);
        int i = this.encryptionKey.length;
        md5Input[i++] = (byte)(objectNumber >>> 0);
        md5Input[i++] = (byte)(objectNumber >>> 8);
        md5Input[i++] = (byte)(objectNumber >>> 16);
        md5Input[i++] = (byte)(generationNumber >>> 0);
        md5Input[i++] = (byte)(generationNumber >>> 8);
        return md5Input;
    }

    static /* synthetic */ byte[] access$502(PDFEncryptionJCE x0, byte[] x1) {
        x0.encryptionKey = x1;
        return x1;
    }

    private class EncryptionFilter
    extends PDFFilter {
        private int streamNumber;
        private int streamGeneration;

        EncryptionFilter(int streamNumber, int streamGeneration) {
            this.streamNumber = streamNumber;
            this.streamGeneration = streamGeneration;
        }

        public String getName() {
            return "";
        }

        public PDFObject getDecodeParms() {
            return null;
        }

        public OutputStream applyFilter(OutputStream out) throws IOException {
            byte[] key = PDFEncryptionJCE.this.createEncryptionKey(this.streamNumber, this.streamGeneration);
            Cipher cipher = PDFEncryptionJCE.initCipher(key);
            return new CipherOutputStream(out, cipher);
        }
    }

    private class Rev3Engine
    extends InitializationEngine {
        Rev3Engine(EncryptionSettings encryptionSettings) {
            super(encryptionSettings);
        }

        protected byte[] computeOValueStep3(byte[] hash) {
            for (int i = 0; i < 50; ++i) {
                hash = PDFEncryptionJCE.this.digest.digest(hash);
            }
            return hash;
        }

        protected byte[] computeOValueStep7(byte[] key, byte[] encryptionResult) {
            return this.xorKeyAndEncrypt19Times(key, encryptionResult);
        }

        protected byte[] createEncryptionKeyStep6(byte[] hash) {
            for (int i = 0; i < 50; ++i) {
                PDFEncryptionJCE.this.digest.update(hash, 0, this.encryptionLengthInBytes);
                hash = PDFEncryptionJCE.this.digest.digest();
            }
            return hash;
        }

        protected byte[] computeUValue() {
            PDFEncryptionJCE.this.digest.reset();
            PDFEncryptionJCE.this.digest.update(this.padding);
            PDFEncryptionJCE.this.digest.update(PDFEncryptionJCE.this.getDocumentSafely().getFileIDGenerator().getOriginalFileID());
            byte[] encryptionResult = PDFEncryptionJCE.encryptWithKey(PDFEncryptionJCE.this.encryptionKey, PDFEncryptionJCE.this.digest.digest());
            encryptionResult = this.xorKeyAndEncrypt19Times(PDFEncryptionJCE.this.encryptionKey, encryptionResult);
            byte[] uValue = new byte[32];
            System.arraycopy(encryptionResult, 0, uValue, 0, 16);
            Arrays.fill(uValue, 16, 32, (byte)0);
            return uValue;
        }

        private byte[] xorKeyAndEncrypt19Times(byte[] key, byte[] input) {
            byte[] result = input;
            byte[] encryptionKey = new byte[key.length];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < key.length; ++j) {
                    encryptionKey[j] = (byte)(key[j] ^ i);
                }
                result = PDFEncryptionJCE.encryptWithKey(encryptionKey, result);
            }
            return result;
        }
    }

    private class Rev2Engine
    extends InitializationEngine {
        Rev2Engine(EncryptionSettings encryptionSettings) {
            super(encryptionSettings);
        }

        protected byte[] computeOValueStep3(byte[] hash) {
            return hash;
        }

        protected byte[] computeOValueStep7(byte[] key, byte[] encryptionResult) {
            return encryptionResult;
        }

        protected byte[] createEncryptionKeyStep6(byte[] hash) {
            return hash;
        }

        protected byte[] computeUValue() {
            return PDFEncryptionJCE.encryptWithKey(PDFEncryptionJCE.this.encryptionKey, this.padding);
        }
    }

    private abstract class InitializationEngine {
        protected final byte[] padding = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
        protected final int encryptionLengthInBytes;
        private final int permissions;
        private byte[] oValue;
        private byte[] uValue;
        private final byte[] preparedUserPassword;
        protected final String ownerPassword;

        InitializationEngine(EncryptionSettings encryptionSettings) {
            this.encryptionLengthInBytes = encryptionSettings.encryptionLength / 8;
            this.permissions = encryptionSettings.permissions;
            this.preparedUserPassword = this.preparePassword(encryptionSettings.userPassword);
            this.ownerPassword = encryptionSettings.ownerPassword;
        }

        void run() {
            this.oValue = this.computeOValue();
            this.createEncryptionKey();
            this.uValue = this.computeUValue();
        }

        private byte[] computeOValue() {
            byte[] md5Input = this.prepareMD5Input();
            PDFEncryptionJCE.this.digest.reset();
            byte[] hash = PDFEncryptionJCE.this.digest.digest(md5Input);
            hash = this.computeOValueStep3(hash);
            byte[] key = new byte[this.encryptionLengthInBytes];
            System.arraycopy(hash, 0, key, 0, this.encryptionLengthInBytes);
            byte[] encryptionResult = PDFEncryptionJCE.encryptWithKey(key, this.preparedUserPassword);
            encryptionResult = this.computeOValueStep7(key, encryptionResult);
            return encryptionResult;
        }

        private void createEncryptionKey() {
            PDFEncryptionJCE.this.digest.reset();
            PDFEncryptionJCE.this.digest.update(this.preparedUserPassword);
            PDFEncryptionJCE.this.digest.update(this.oValue);
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 0));
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 8));
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 16));
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 24));
            PDFEncryptionJCE.this.digest.update(PDFEncryptionJCE.this.getDocumentSafely().getFileIDGenerator().getOriginalFileID());
            byte[] hash = PDFEncryptionJCE.this.digest.digest();
            hash = this.createEncryptionKeyStep6(hash);
            PDFEncryptionJCE.access$502(PDFEncryptionJCE.this, new byte[this.encryptionLengthInBytes]);
            System.arraycopy(hash, 0, PDFEncryptionJCE.this.encryptionKey, 0, this.encryptionLengthInBytes);
        }

        protected abstract byte[] computeUValue();

        private byte[] preparePassword(String password) {
            int finalLength = 32;
            byte[] preparedPassword = new byte[finalLength];
            byte[] passwordBytes = password.getBytes();
            System.arraycopy(passwordBytes, 0, preparedPassword, 0, passwordBytes.length);
            System.arraycopy(this.padding, 0, preparedPassword, passwordBytes.length, finalLength - passwordBytes.length);
            return preparedPassword;
        }

        private byte[] prepareMD5Input() {
            if (this.ownerPassword.length() != 0) {
                return this.preparePassword(this.ownerPassword);
            }
            return this.preparedUserPassword;
        }

        protected abstract byte[] computeOValueStep3(byte[] var1);

        protected abstract byte[] computeOValueStep7(byte[] var1, byte[] var2);

        protected abstract byte[] createEncryptionKeyStep6(byte[] var1);
    }

    private static final class EncryptionSettings {
        final int encryptionLength;
        final int permissions;
        final String userPassword;
        final String ownerPassword;

        EncryptionSettings(int encryptionLength, int permissions, String userPassword, String ownerPassword) {
            this.encryptionLength = encryptionLength;
            this.permissions = permissions;
            this.userPassword = userPassword;
            this.ownerPassword = ownerPassword;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Permission {
        PRINT(3),
        EDIT_CONTENT(4),
        COPY_CONTENT(5),
        EDIT_ANNOTATIONS(6),
        FILL_IN_FORMS(9),
        ACCESS_CONTENT(10),
        ASSEMBLE_DOCUMENT(11),
        PRINT_HQ(12);

        private final int mask;

        private Permission(int bit) {
            this.mask = 1 << bit - 1;
        }

        private int removeFrom(int permissions) {
            return permissions - this.mask;
        }

        static int computePermissions(PDFEncryptionParams encryptionParams) {
            int permissions = -4;
            if (!encryptionParams.isAllowPrint()) {
                permissions = PRINT.removeFrom(permissions);
            }
            if (!encryptionParams.isAllowCopyContent()) {
                permissions = COPY_CONTENT.removeFrom(permissions);
            }
            if (!encryptionParams.isAllowEditContent()) {
                permissions = EDIT_CONTENT.removeFrom(permissions);
            }
            if (!encryptionParams.isAllowEditAnnotations()) {
                permissions = EDIT_ANNOTATIONS.removeFrom(permissions);
            }
            if (!encryptionParams.isAllowFillInForms()) {
                permissions = FILL_IN_FORMS.removeFrom(permissions);
            }
            if (!encryptionParams.isAllowAccessContent()) {
                permissions = ACCESS_CONTENT.removeFrom(permissions);
            }
            if (!encryptionParams.isAllowAssembleDocument()) {
                permissions = ASSEMBLE_DOCUMENT.removeFrom(permissions);
            }
            if (!encryptionParams.isAllowPrintHq()) {
                permissions = PRINT_HQ.removeFrom(permissions);
            }
            return permissions;
        }
    }

    private class EncryptionInitializer {
        private final PDFEncryptionParams encryptionParams;
        private int encryptionLength;
        private int version;
        private int revision;

        EncryptionInitializer(PDFEncryptionParams params) {
            this.encryptionParams = new PDFEncryptionParams(params);
        }

        void init() {
            this.encryptionLength = this.encryptionParams.getEncryptionLengthInBits();
            this.determineEncryptionAlgorithm();
            int permissions = Permission.computePermissions(this.encryptionParams);
            EncryptionSettings encryptionSettings = new EncryptionSettings(this.encryptionLength, permissions, this.encryptionParams.getUserPassword(), this.encryptionParams.getOwnerPassword());
            InitializationEngine initializationEngine = this.revision == 2 ? new Rev2Engine(encryptionSettings) : new Rev3Engine(encryptionSettings);
            initializationEngine.run();
            PDFEncryptionJCE.this.encryptionDictionary = this.createEncryptionDictionary(permissions, initializationEngine.oValue, initializationEngine.uValue);
        }

        private void determineEncryptionAlgorithm() {
            if (this.isVersion1Revision2Algorithm()) {
                this.version = 1;
                this.revision = 2;
            } else {
                this.version = 2;
                this.revision = 3;
            }
        }

        private boolean isVersion1Revision2Algorithm() {
            return this.encryptionLength == 40 && this.encryptionParams.isAllowFillInForms() && this.encryptionParams.isAllowAccessContent() && this.encryptionParams.isAllowAssembleDocument() && this.encryptionParams.isAllowPrintHq();
        }

        private String createEncryptionDictionary(int permissions, byte[] oValue, byte[] uValue) {
            return "<< /Filter /Standard\n/V " + this.version + "\n" + "/R " + this.revision + "\n" + "/Length " + this.encryptionLength + "\n" + "/P " + permissions + "\n" + "/O " + PDFText.toHex(oValue) + "\n" + "/U " + PDFText.toHex(uValue) + "\n" + ">>";
        }
    }
}

