/* plank.vapi generated by valac 0.30.0, do not modify. */

namespace Plank {
	namespace DBus {
		[CCode (cheader_filename = "plank.h")]
		public class Client : GLib.Object {
			public bool add_item (string uri);
			public static unowned Plank.DBus.Client get_instance ();
			public int get_items_count ();
			public unowned string[]? get_persistent_applications ();
			public unowned string[]? get_transient_applications ();
			public bool remove_item (string uri);
			public bool is_connected { get; }
			public signal void proxy_changed ();
		}
	}
	namespace Drawing {
		[CCode (cheader_filename = "plank.h")]
		public abstract class AnimatedRenderer : GLib.Object {
			public AnimatedRenderer (Gtk.Widget widget);
			public void animated_draw ();
			protected abstract bool animation_needed (int64 frame_time);
			public abstract void draw (Cairo.Context cr, int64 frame_time);
			protected void force_frame_time_update ();
			protected abstract void initialize_frame (int64 frame_time);
			[CCode (notify = false)]
			public int64 frame_time { get; private set; }
			public Gtk.Widget widget { get; construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class DockSurface : GLib.Object {
			public DockSurface (int width, int height);
			public Plank.Drawing.Color average_color ();
			public void clear ();
			public Plank.Drawing.DockSurface copy ();
			public Plank.Drawing.DockSurface create_mask (double threshold, out Gdk.Rectangle extent);
			public void exponential_blur (int radius);
			public void fast_blur (int radius, int process_count = 1);
			public void gaussian_blur (int radius);
			public Plank.Drawing.DockSurface scaled_copy (int width, int height);
			public Gdk.Pixbuf to_pixbuf ();
			public DockSurface.with_dock_surface (int width, int height, Plank.Drawing.DockSurface model);
			public DockSurface.with_internal (Cairo.ImageSurface image);
			public DockSurface.with_surface (int width, int height, Cairo.Surface model);
			public Cairo.Context Context { get; construct; }
			public int Height { get; construct; }
			public Cairo.Surface Internal { get; construct; }
			public int Width { get; construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class DockTheme : Plank.Drawing.Theme {
			public DockTheme (string name);
			public Plank.Drawing.DockSurface create_background (int width, int height, Gtk.PositionType position, Plank.Drawing.DockSurface model);
			public Plank.Drawing.DockSurface create_indicator (int size, Plank.Drawing.Color color, Plank.Drawing.DockSurface model);
			public Plank.Drawing.DockSurface create_urgent_glow (int size, Plank.Drawing.Color color, Plank.Drawing.DockSurface model);
			public void draw_active_glow (Plank.Drawing.DockSurface surface, Gdk.Rectangle clip_rect, Gdk.Rectangle rect, Plank.Drawing.Color color, double opacity, Gtk.PositionType pos);
			public void draw_item_count (Plank.Drawing.DockSurface surface, int icon_size, Plank.Drawing.Color color, int64 count);
			public void draw_item_progress (Plank.Drawing.DockSurface surface, int icon_size, Plank.Drawing.Color color, double progress);
			protected override void reset_properties ();
			protected override void verify (string prop);
			[Description (blurb = "The amount of time (in ms) for active window indicator animations.", nick = "active-time")]
			public int ActiveTime { get; set; }
			[Description (blurb = "The padding on the bottom dock edge, in tenths of a percent of IconSize.", nick = "bottom-padding")]
			public double BottomPadding { get; set; }
			[Description (blurb = "The amount of time (in ms) for click animations.", nick = "click-time")]
			public int ClickTime { get; set; }
			[Description (blurb = "The opacity value (0 to 1) to fade the dock to when hiding it.", nick = "fade-opacity")]
			public double FadeOpacity { get; set; }
			[Description (blurb = "The time (in ms) to fade the dock in/out on a hide (if FadeOpacity is < 1).", nick = "fade-time")]
			public int FadeTime { get; set; }
			[Description (blurb = "The time (in ms) of each pulse of the hidden-dock urgent glow.", nick = "glow-pulse-time")]
			public int GlowPulseTime { get; set; }
			[Description (blurb = "The size of the urgent glow (shown when dock is hidden), in tenths of a percent of IconSize.", nick = "glow-size")]
			public int GlowSize { get; set; }
			[Description (blurb = "The total time (in ms) to show the hidden-dock urgent glow.", nick = "glow-time")]
			public int GlowTime { get; set; }
			[Description (blurb = "The time (in ms) to slide the dock in/out on a hide (if FadeOpacity is 1).", nick = "hide-time")]
			public int HideTime { get; set; }
			[Description (blurb = "The padding on the left/right dock edges, in tenths of a percent of IconSize.", nick = "horizontal-padding")]
			public double HorizPadding { get; set; }
			[Description (blurb = "The size of the icon-shadow behind every item, in tenths of a percent of IconSize.", nick = "icon-shadow-size")]
			public double IconShadowSize { get; set; }
			[Description (blurb = "The size of item indicators, in tenths of a percent of IconSize.", nick = "indicator-size")]
			public double IndicatorSize { get; set; }
			[Description (blurb = "The time (in ms) to move an item to its new position or its addition/removal to/from the dock.", nick = "item-move-time")]
			public int ItemMoveTime { get; set; }
			[Description (blurb = "The padding between items on the dock, in tenths of a percent of IconSize.", nick = "item-padding")]
			public double ItemPadding { get; set; }
			[Description (blurb = "The height (in percent of IconSize) to bounce an icon when launching an application.", nick = "launch-bounce")]
			public double LaunchBounceHeight { get; set; }
			[Description (blurb = "The amount of time (in ms) to bounce an icon when launching an application.", nick = "launch-bounce-time")]
			public int LaunchBounceTime { get; set; }
			[Description (blurb = "The amount of time (in ms) to slide icons into/out of the dock.", nick = "slide-time")]
			public int SlideTime { get; set; }
			[Description (blurb = "The padding on the top dock edge, in tenths of a percent of IconSize.", nick = "top-padding")]
			public double TopPadding { get; set; }
			[Description (blurb = "The height (in percent of IconSize) to bounce an icon when the application sets urgent.", nick = "urgent-bounce")]
			public double UrgentBounceHeight { get; set; }
			[Description (blurb = "The amount of time (in ms) to bounce an urgent icon.", nick = "urgent-bounce-time")]
			public int UrgentBounceTime { get; set; }
			[Description (blurb = "The hue-shift (-180 to 180) of the urgent indicator color.", nick = "urgent-hue-shift")]
			public int UrgentHueShift { get; set; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class DrawingService : GLib.Object {
			public static Gdk.Pixbuf ar_scale (Gdk.Pixbuf source, int width, int height);
			public static Plank.Drawing.Color average_color (Gdk.Pixbuf source);
			public static string? get_icon_from_file (GLib.File file);
			public static string? get_icon_from_gicon (GLib.Icon? icon);
			public static unowned Gtk.IconTheme get_icon_theme ();
			public static Gdk.Pixbuf load_icon (string names, int width, int height);
			public static Cairo.Surface? load_icon_for_scale (string names, int width, int height, int scale);
			public static GLib.File? try_get_icon_file (string name);
		}
		[CCode (cheader_filename = "plank.h")]
		public class SurfaceCache<G> : GLib.Object {
			public SurfaceCache (Plank.Drawing.SurfaceCacheFlags flags = SurfaceCacheFlags.NONE);
			public void clear ();
			public Plank.Drawing.DockSurface? get_surface<G> (int width, int height, Plank.Drawing.DockSurface model, Plank.Drawing.DrawFunc<G> draw_func, Plank.Drawing.DrawDataFunc<G>? draw_data_func);
			public Plank.Drawing.SurfaceCacheFlags flags { get; construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public abstract class Theme : Plank.Services.Preferences {
			public const string DEFAULT_NAME;
			public const string GTK_THEME_NAME;
			public Theme ();
			public void draw_background (Plank.Drawing.DockSurface surface);
			protected void draw_inner_rect (Cairo.Context cr, int width, int height);
			public static void draw_rounded_line (Cairo.Context cr, double x, double y, double width, double height, bool is_round_left, bool is_round_right, Cairo.Pattern? stroke = null, Cairo.Pattern? fill = null);
			public static void draw_rounded_rect (Cairo.Context cr, double x, double y, double width, double height, double top_radius = 6.0, double bottom_radius = 6.0, double line_width = 1.0);
			public int get_bottom_offset ();
			public static GLib.File? get_theme_folder (string name);
			public static string[] get_theme_list ();
			public int get_top_offset ();
			public void load (string type);
			protected override void reset_properties ();
			protected override void verify (string prop);
			public Theme.with_name (string name);
			[Description (blurb = "The roundness of the bottom corners.", nick = "bottom-roundness")]
			public int BottomRoundness { get; set; }
			[Description (blurb = "The ending color (RGBA) of the fill gradient.", nick = "fill-end-color")]
			public Plank.Drawing.Color FillEndColor { get; set; }
			[Description (blurb = "The starting color (RGBA) of the fill gradient.", nick = "fill-start-color")]
			public Plank.Drawing.Color FillStartColor { get; set; }
			[Description (blurb = "The color (RGBA) of the inner stroke.", nick = "inner-stroke-color")]
			public Plank.Drawing.Color InnerStrokeColor { get; set; }
			[Description (blurb = "The thickness (in pixels) of lines drawn.", nick = "line-width")]
			public int LineWidth { get; set; }
			[Description (blurb = "The color (RGBA) of the outer stroke.", nick = "outer-stroke-color")]
			public Plank.Drawing.Color OuterStrokeColor { get; set; }
			[Description (blurb = "The roundness of the top corners.", nick = "top-roundness")]
			public int TopRoundness { get; set; }
		}
		[CCode (cheader_filename = "plank.h")]
		public struct Color : Gdk.RGBA {
			public void add_hue (double val);
			public void brighten_val (double amount);
			public void darken_by_sat (double amount);
			public void darken_val (double amount);
			public static Plank.Drawing.Color from_prefs_string (string s);
			public void get_hsv (out double h, out double s, out double v);
			public double get_hue ();
			public double get_sat ();
			public double get_val ();
			public void multiply_sat (double amount);
			public void set_hsv (double h, double s, double v);
			public void set_hue (double hue);
			public void set_max_sat (double sat);
			public void set_max_val (double val);
			public void set_min_sat (double sat);
			public void set_min_val (double val);
			public void set_sat (double sat);
			public void set_val (double val);
			public string to_prefs_string ();
		}
		[CCode (cheader_filename = "plank.h")]
		public enum AnimationMode {
			CUSTOM,
			LINEAR,
			EASE_IN_QUAD,
			EASE_OUT_QUAD,
			EASE_IN_OUT_QUAD,
			EASE_IN_CUBIC,
			EASE_OUT_CUBIC,
			EASE_IN_OUT_CUBIC,
			EASE_IN_QUART,
			EASE_OUT_QUART,
			EASE_IN_OUT_QUART,
			EASE_IN_QUINT,
			EASE_OUT_QUINT,
			EASE_IN_OUT_QUINT,
			EASE_IN_SINE,
			EASE_OUT_SINE,
			EASE_IN_OUT_SINE,
			EASE_IN_EXPO,
			EASE_OUT_EXPO,
			EASE_IN_OUT_EXPO,
			EASE_IN_CIRC,
			EASE_OUT_CIRC,
			EASE_IN_OUT_CIRC,
			EASE_IN_ELASTIC,
			EASE_OUT_ELASTIC,
			EASE_IN_OUT_ELASTIC,
			EASE_IN_BACK,
			EASE_OUT_BACK,
			EASE_IN_OUT_BACK,
			EASE_IN_BOUNCE,
			EASE_OUT_BOUNCE,
			EASE_IN_OUT_BOUNCE,
			LAST
		}
		[CCode (cheader_filename = "plank.h")]
		[Flags]
		public enum SurfaceCacheFlags {
			NONE,
			ALLOW_DOWNSCALE,
			ALLOW_UPSCALE,
			ALLOW_SCALE,
			ADAPTIVE_SCALE
		}
		[CCode (cheader_filename = "plank.h")]
		public delegate Plank.Drawing.DockSurface? DrawDataFunc<G> (int width, int height, Plank.Drawing.DockSurface model, G data);
		[CCode (cheader_filename = "plank.h")]
		public delegate Plank.Drawing.DockSurface? DrawFunc<G> (int width, int height, Plank.Drawing.DockSurface model, Plank.Drawing.DrawDataFunc<G>? draw_data_func);
		[CCode (cheader_filename = "plank.h")]
		public static double easing_for_mode (Plank.Drawing.AnimationMode mode, double t, double d);
	}
	namespace Factories {
		[CCode (cheader_filename = "plank.h")]
		public abstract class AbstractMain : Gtk.Application {
			public AbstractMain ();
			public override void activate ();
			protected virtual void create_actions ();
			protected virtual void create_controller ();
			protected virtual void initialize ();
			public bool is_launcher_for_dock (string launcher);
			public override bool local_command_line (ref unowned string[] args, out int exit_status);
			public override void startup ();
			public string[] about_artists { get; set construct; }
			public string[] about_authors { get; set construct; }
			public string[] about_documenters { get; set construct; }
			public Gtk.License about_license_type { get; set construct; }
			public string about_translators { get; set construct; }
			public string app_copyright { get; construct; }
			public string app_dbus { get; construct; }
			public string app_icon { get; construct; }
			public string app_launcher { get; construct; }
			public string build_data_dir { get; construct; }
			public string build_pkg_data_dir { get; construct; }
			public string build_release_name { get; construct; }
			public string build_version { get; construct; }
			public string build_version_info { get; construct; }
			public string dock_name { get; protected set; }
			public string exec_name { get; construct; }
			public string help_url { get; set construct; }
			public string main_url { get; set construct; }
			public string program_name { get; construct; }
			public string translate_url { get; set construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class Factory : GLib.Object {
			public static Plank.Factories.ItemFactory item_factory;
			public static Plank.Factories.AbstractMain main;
			public Factory ();
			public static void init (Plank.Factories.AbstractMain main_class, Plank.Factories.ItemFactory item);
		}
		[CCode (cheader_filename = "plank.h")]
		public class ItemFactory : GLib.Object {
			public GLib.File launchers_dir;
			public ItemFactory ();
			protected Plank.Items.DockElement default_make_element (GLib.File file, string launcher);
			public virtual Plank.Items.DockItem get_item_for_dock ();
			protected string get_launcher_from_dockitem (GLib.File file);
			public Gee.ArrayList<Plank.Items.DockItem> load_items (GLib.File source_dir, string? ordering = null);
			public void make_default_items ();
			public GLib.File? make_dock_item (string uri, GLib.File? target_dir = null);
			public virtual Plank.Items.DockElement make_element (GLib.File file);
		}
	}
	namespace Items {
		[CCode (cheader_filename = "plank.h")]
		public class ApplicationDockItem : Plank.Items.DockItem {
			public ApplicationDockItem ();
			public override bool accept_drop (Gee.ArrayList<string> uris);
			public override bool can_accept_drop (Gee.ArrayList<string> uris);
			public override Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
			public unowned string? get_unity_application_uri ();
			public unowned string? get_unity_dbusname ();
			public bool has_unity_info ();
			public bool is_running ();
			public bool is_window ();
			protected override void load_from_launcher ();
			protected override Plank.Items.Animation on_clicked (Plank.Items.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
			protected override Plank.Items.Animation on_scrolled (Gdk.ScrollDirection direction, Gdk.ModifierType mod, uint32 event_time);
			public static void parse_launcher (string launcher, out string icon, out string text, Gee.ArrayList<string>? actions = null, Gee.Map<string,string>? actions_map = null, Gee.ArrayList<string>? mimes = null);
			public void set_urgent (bool is_urgent);
			public void unity_reset ();
			public void unity_update (string sender_name, GLib.VariantIter prop_iter);
			public ApplicationDockItem.with_dockitem_file (GLib.File file);
			public ApplicationDockItem.with_dockitem_filename (string filename);
			public Bamf.Application? App { internal get; internal set construct; }
			public signal void app_closed ();
			public signal void app_window_added ();
			public signal void app_window_removed ();
			public signal void pin_launcher ();
		}
		[CCode (cheader_filename = "plank.h")]
		public class ApplicationDockItemProvider : Plank.Items.DockItemProvider {
			public ApplicationDockItemProvider (GLib.File launchers_dir);
			public static void acquire_unity_dbus ();
			public override bool add_item_with_uri (string uri, Plank.Items.DockItem? target = null);
			protected virtual void app_opened (Bamf.Application app);
			protected override void connect_element (Plank.Items.DockElement element);
			protected void delay_items_monitor ();
			protected override void disconnect_element (Plank.Items.DockElement element);
			public string get_item_list_string ();
			protected unowned Plank.Items.ApplicationDockItem? item_for_application (Bamf.Application app);
			public override void prepare ();
			public static void release_unity_dbus ();
			protected void resume_items_monitor ();
			public GLib.File LaunchersDir { get; construct; }
			public signal void item_window_added (Plank.Items.ApplicationDockItem item);
		}
		[CCode (cheader_filename = "plank.h")]
		public class DefaultApplicationDockItemProvider : Plank.Items.ApplicationDockItemProvider {
			public DefaultApplicationDockItemProvider (Plank.DockPreferences prefs, GLib.File launchers_dir);
			protected override void app_opened (Bamf.Application app);
			protected override void connect_element (Plank.Items.DockElement element);
			protected override void disconnect_element (Plank.Items.DockElement element);
			protected override void handle_item_deleted (Plank.Items.DockItem item);
			public void pin_item (Plank.Items.DockItem item);
			public override void prepare ();
			protected override void update_visible_elements ();
			public Plank.DockPreferences Prefs { get; construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public abstract class DockContainer : Plank.Items.DockElement {
			protected Gee.ArrayList<Plank.Items.DockElement> internal_elements;
			protected static Plank.Items.PlaceholderDockItem placeholder_item;
			protected Gee.ArrayList<Plank.Items.DockElement> visible_elements;
			public DockContainer ();
			public bool add (Plank.Items.DockElement element, Plank.Items.DockElement? target = null);
			public bool add_all (Gee.ArrayList<Plank.Items.DockElement> elements);
			protected abstract void connect_element (Plank.Items.DockElement element);
			protected abstract void disconnect_element (Plank.Items.DockElement element);
			protected static void move_element (Gee.List<Plank.Items.DockElement> elements, int from, int to, Gee.List<weak Plank.Items.DockElement>? moved = null);
			public virtual bool move_to (Plank.Items.DockElement move, Plank.Items.DockElement target);
			public virtual void prepare ();
			public void prepend (Plank.Items.DockElement element);
			public bool remove (Plank.Items.DockElement element);
			public bool remove_all ();
			public virtual bool replace (Plank.Items.DockElement new_element, Plank.Items.DockElement old_element);
			public override void reset_buffers ();
			protected virtual void update_visible_elements ();
			public Gee.ArrayList<Plank.Items.DockElement> Elements { get; }
			public Gee.ArrayList<Plank.Items.DockElement> VisibleElements { get; }
			public signal void elements_changed (Gee.List<Plank.Items.DockElement> added, Gee.List<Plank.Items.DockElement> removed);
			public signal void positions_changed (Gee.List<weak Plank.Items.DockElement> elements);
			public signal void states_changed ();
		}
		[CCode (cheader_filename = "plank.h")]
		public abstract class DockElement : GLib.Object {
			public DockElement ();
			public virtual bool accept_drop (Gee.ArrayList<string> uris);
			public string as_uri ();
			public virtual bool can_accept_drop (Gee.ArrayList<string> uris);
			public virtual bool can_be_removed ();
			public void clicked (Plank.Items.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
			protected static Gtk.MenuItem create_menu_item (string title, string? icon = null, bool force_show_icon = false);
			protected static Gtk.MenuItem create_menu_item_with_pixbuf (string title, owned Gdk.Pixbuf pixbuf, bool force_show_icon = false);
			public unowned Plank.DockController? get_dock ();
			public virtual Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
			public void hovered ();
			protected virtual Plank.Items.Animation on_clicked (Plank.Items.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
			protected virtual Plank.Items.Animation on_hovered ();
			protected virtual Plank.Items.Animation on_scrolled (Gdk.ScrollDirection direction, Gdk.ModifierType mod, uint32 event_time);
			public abstract void reset_buffers ();
			public void scrolled (Gdk.ScrollDirection direction, Gdk.ModifierType mod, uint32 event_time);
			public virtual string unique_id ();
			public int64 AddTime { get; set; }
			public Plank.Items.PopupButton Button { get; protected set; }
			public Plank.Items.Animation ClickedAnimation { get; protected set; }
			public Plank.Items.DockContainer? Container { get; set; }
			public Plank.Items.Animation HoveredAnimation { get; protected set; }
			public bool IsAttached { get; set; }
			public bool IsVisible { get; set; }
			public int64 LastActive { get; protected set; }
			public int64 LastClicked { get; protected set; }
			public int64 LastHovered { get; protected set; }
			public int64 LastMove { get; protected set; }
			public int64 LastScrolled { get; protected set; }
			public int64 LastUrgent { get; protected set; }
			public int64 LastValid { get; protected set; }
			public int64 RemoveTime { get; set; }
			public Plank.Items.Animation ScrolledAnimation { get; protected set; }
			public string Text { get; set; }
			public signal void needs_redraw ();
		}
		[CCode (cheader_filename = "plank.h")]
		public abstract class DockItem : Plank.Items.DockElement {
			public DockItem ();
			public void copy_values_to (Plank.Items.DockItem target);
			public void @delete ();
			protected virtual void draw_icon (Plank.Drawing.DockSurface surface);
			protected virtual void draw_icon_fast (Plank.Drawing.DockSurface surface);
			public Plank.Drawing.DockSurface? get_background_surface (int width, int height, Plank.Drawing.DockSurface model, Plank.Drawing.DrawDataFunc<Plank.Items.DockItem>? draw_data_func);
			public Plank.Drawing.DockSurface? get_foreground_surface (int width, int height, Plank.Drawing.DockSurface model, Plank.Drawing.DrawDataFunc<Plank.Items.DockItem>? draw_data_func);
			public Plank.Drawing.DockSurface get_surface (int width, int height, Plank.Drawing.DockSurface model);
			public Plank.Drawing.DockSurface get_surface_copy (int width, int height, Plank.Drawing.DockSurface model);
			public virtual bool is_valid ();
			protected virtual void load_from_launcher ();
			public override void reset_buffers ();
			protected void reset_icon_buffer ();
			public void unset_move_state ();
			public Plank.Drawing.Color AverageIconColor { get; protected set; }
			public int64 Count { get; set; }
			public bool CountVisible { get; set; }
			public string DockItemFilename { owned get; }
			protected Gdk.Pixbuf? ForcePixbuf { get; set; }
			public string Icon { get; set; }
			public Plank.Items.IndicatorState Indicator { get; protected set; }
			public int LastPosition { get; protected set; }
			public string Launcher { get; }
			public int Position { get; set; }
			public Plank.Items.DockItemPreferences Prefs { get; construct; }
			public double Progress { get; set; }
			public bool ProgressVisible { get; set; }
			public Plank.Items.ItemState State { get; protected set; }
			public signal void deleted ();
		}
		[CCode (cheader_filename = "plank.h")]
		public class DockItemPreferences : Plank.Services.Preferences {
			public DockItemPreferences ();
			public override void reset_properties ();
			protected override void verify (string prop);
			public DockItemPreferences.with_file (GLib.File file);
			public DockItemPreferences.with_filename (string filename);
			public DockItemPreferences.with_launcher (string launcher);
			[Description (blurb = "The uri for this item.", nick = "launcher")]
			public string Launcher { get; set; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class DockItemProvider : Plank.Items.DockContainer {
			public DockItemProvider ();
			public override bool accept_drop (Gee.ArrayList<string> uris);
			public virtual bool add_item_with_uri (string uri, Plank.Items.DockItem? target = null);
			public override bool can_accept_drop (Gee.ArrayList<string> uris);
			protected override void connect_element (Plank.Items.DockElement element);
			protected override void disconnect_element (Plank.Items.DockElement element);
			protected virtual void handle_item_deleted (Plank.Items.DockItem item);
			public virtual bool item_exists_for_uri (string uri);
			public virtual unowned Plank.Items.DockItem? item_for_uri (string uri);
		}
		[CCode (cheader_filename = "plank.h")]
		public class FileDockItem : Plank.Items.DockItem {
			public FileDockItem ();
			protected override void draw_icon (Plank.Drawing.DockSurface surface);
			protected override void draw_icon_fast (Plank.Drawing.DockSurface surface);
			public override Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
			public void launch ();
			protected override void load_from_launcher ();
			protected override Plank.Items.Animation on_clicked (Plank.Items.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
			public FileDockItem.with_dockitem_file (GLib.File file);
			public FileDockItem.with_dockitem_filename (string filename);
			public FileDockItem.with_file (GLib.File file);
			public GLib.File OwnedFile { get; protected set construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class PlaceholderDockItem : Plank.Items.DockItem {
			public PlaceholderDockItem ();
			public override bool can_be_removed ();
			public override bool is_valid ();
			protected override Plank.Items.Animation on_clicked (Plank.Items.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
		}
		[CCode (cheader_filename = "plank.h")]
		public class PlankDockItem : Plank.Items.DockItem {
			public override bool can_be_removed ();
			public static unowned Plank.Items.PlankDockItem get_instance ();
			public override Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
			protected override Plank.Items.Animation on_clicked (Plank.Items.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
		}
		[CCode (cheader_filename = "plank.h")]
		public class TransientDockItem : Plank.Items.ApplicationDockItem {
			public TransientDockItem ();
			public override bool can_be_removed ();
			public override bool is_valid ();
			public TransientDockItem.with_launcher (string launcher_uri);
		}
		[CCode (cheader_filename = "plank.h")]
		public enum Animation {
			NONE,
			BOUNCE,
			DARKEN,
			LIGHTEN
		}
		[CCode (cheader_filename = "plank.h")]
		public enum IndicatorState {
			NONE,
			SINGLE,
			SINGLE_PLUS
		}
		[CCode (cheader_filename = "plank.h")]
		[Flags]
		public enum ItemState {
			NORMAL,
			ACTIVE,
			URGENT,
			MOVE,
			INVALID
		}
		[CCode (cheader_filename = "plank.h")]
		[Flags]
		public enum PopupButton {
			NONE,
			LEFT,
			MIDDLE,
			RIGHT;
			public static Plank.Items.PopupButton from_event_button (Gdk.EventButton event);
		}
	}
	namespace Services {
		[CCode (cheader_filename = "plank.h")]
		public class Logger : GLib.Object {
			public static void initialize (string app_name);
			public static void notification (string msg, string icon = "");
			public static void verbose (string msg, ...);
			public static Plank.Services.LogLevel DisplayLevel { get; set; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class Paths : GLib.Object {
			public static bool ensure_directory_exists (GLib.File dir);
			public static void initialize (string app_name, string data_folder);
			public static GLib.File AppCacheFolder { get; protected set; }
			public static GLib.File AppConfigFolder { get; protected set; }
			public static GLib.File AppDataFolder { get; protected set; }
			public static string AppName { get; protected set; }
			public static GLib.File AppThemeFolder { get; protected set; }
			public static GLib.File CacheHomeFolder { get; protected set; }
			public static GLib.File ConfigHomeFolder { get; protected set; }
			public static Gee.ArrayList<GLib.File> DataDirFolders { get; protected set; }
			public static GLib.File DataFolder { get; protected set; }
			public static GLib.File DataHomeFolder { get; protected set; }
			public static GLib.File HomeFolder { get; protected set; }
			public static GLib.File ThemeFolder { get; protected set; }
		}
		[CCode (cheader_filename = "plank.h")]
		public abstract class Preferences : GLib.Object {
			public Preferences ();
			public void apply ();
			public void delay ();
			public void @delete ();
			public unowned GLib.File? get_backing_file ();
			public string get_filename ();
			protected void init_from_file (GLib.File file);
			protected void init_from_filename (string filename);
			protected abstract void reset_properties ();
			protected virtual void verify (string prop);
			public Preferences.with_file (GLib.File file);
			public Preferences.with_filename (string filename);
			public signal void deleted ();
		}
		[CCode (cheader_filename = "plank.h")]
		public class System : GLib.Object {
			public static bool is_desktop_session (string session);
			public static void launch (GLib.File app);
			public static void launch_with_files (GLib.File? app, GLib.File[] files);
			public static void open (GLib.File file);
			public static void open_files (GLib.File[] files);
			public static void open_uri (string uri);
		}
		[CCode (cheader_filename = "plank.h")]
		public class Worker : GLib.Object {
			public void add_task (owned GLib.ThreadFunc<weak void*> func, Plank.Services.TaskPriority priority = TaskPriority.DEFAULT);
			public async G add_task_with_result<G> (owned Plank.Services.TaskFunc<G> func, Plank.Services.TaskPriority priority = TaskPriority.DEFAULT) throws GLib.Error;
			public static unowned Plank.Services.Worker get_default ();
		}
		[CCode (cheader_filename = "plank.h")]
		public interface PrefsSerializable : GLib.Object {
			public abstract void prefs_deserialize (string s);
			public abstract string prefs_serialize ();
		}
		[CCode (cheader_filename = "plank.h")]
		public enum LogLevel {
			VERBOSE,
			DEBUG,
			INFO,
			NOTIFY,
			WARN,
			CRITICAL,
			ERROR
		}
		[CCode (cheader_filename = "plank.h")]
		public enum TaskPriority {
			LOW,
			DEFAULT,
			HIGH
		}
		[CCode (cheader_filename = "plank.h")]
		public delegate G TaskFunc<G> () throws GLib.Error;
	}
	namespace Version {
		[CCode (cheader_filename = "plank.h")]
		public const int MAJOR;
		[CCode (cheader_filename = "plank.h")]
		public const int MICRO;
		[CCode (cheader_filename = "plank.h")]
		public const int MINOR;
		[CCode (cheader_filename = "plank.h")]
		public const int NANO;
		[CCode (cheader_filename = "plank.h")]
		public static unowned string? check (uint required_major, uint required_minor, uint required_micro);
		[CCode (cheader_filename = "plank.h")]
		public static uint get_major_version ();
		[CCode (cheader_filename = "plank.h")]
		public static uint get_micro_version ();
		[CCode (cheader_filename = "plank.h")]
		public static uint get_minor_version ();
		[CCode (cheader_filename = "plank.h")]
		public static uint get_nano_version ();
	}
	namespace Widgets {
		[CCode (cheader_filename = "plank.h")]
		public class CompositedWindow : Gtk.Window {
			public CompositedWindow ();
			public override bool draw (Cairo.Context cr);
			public CompositedWindow.with_type (Gtk.WindowType window_type);
		}
		[CCode (cheader_filename = "plank.h")]
		public class DockWindow : Plank.Widgets.CompositedWindow {
			public DockWindow (Plank.DockController controller);
			public override bool button_press_event (Gdk.EventButton event);
			public override bool button_release_event (Gdk.EventButton event);
			public override void drag_begin (Gdk.DragContext context);
			public override bool draw (Cairo.Context cr);
			public override bool enter_notify_event (Gdk.EventCrossing event);
			public override bool leave_notify_event (Gdk.EventCrossing event);
			public override bool map_event (Gdk.EventAny event);
			public bool menu_is_visible ();
			public override bool motion_notify_event (Gdk.EventMotion event);
			public override bool scroll_event (Gdk.EventScroll event);
			public bool update_hovered (int x, int y);
			public void update_icon_region (Plank.Items.ApplicationDockItem appitem);
			public void update_icon_regions ();
			public void update_size_and_position ();
			public Plank.Items.DockItem? HoveredItem { get; private set; }
			public Plank.Items.DockItemProvider? HoveredItemProvider { get; private set; }
			public Plank.DockController controller { private get; construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class HoverWindow : Gtk.Window {
			public HoverWindow ();
			public override bool draw (Cairo.Context cr);
			public void set_text (string text);
			public void show_at (int x, int y, Gtk.PositionType position);
		}
		[CCode (cheader_filename = "plank.h")]
		public class PoofWindow : Plank.Widgets.CompositedWindow {
			public PoofWindow ();
			public override bool draw (Cairo.Context cr);
			public static unowned Plank.Widgets.PoofWindow get_default ();
			public void show_at (int x, int y);
		}
		[CCode (cheader_filename = "plank.h")]
		public class PreferencesWindow : Gtk.Window {
			public PreferencesWindow (Plank.DockPreferences prefs);
			public override bool key_press_event (Gdk.EventKey event);
			public Plank.DockPreferences prefs { get; construct; }
		}
		[CCode (cheader_filename = "plank.h")]
		public class TitledSeparatorMenuItem : Gtk.SeparatorMenuItem {
			public TitledSeparatorMenuItem (string text);
			protected override bool draw (Cairo.Context cr);
			public TitledSeparatorMenuItem.no_line (string text);
		}
	}
	[CCode (cheader_filename = "plank.h")]
	public class DBusManager : GLib.Object {
		public DBusManager (Plank.DockController controller);
		public Plank.DockController controller { private get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockController : Plank.Items.DockContainer {
		public DockController (GLib.File config_folder);
		public void add_default_provider ();
		protected override void connect_element (Plank.Items.DockElement element);
		protected override void disconnect_element (Plank.Items.DockElement element);
		public void initialize ();
		protected override void update_visible_elements ();
		public Gee.ArrayList<weak Plank.Items.DockItem> Items { get; }
		public Gee.ArrayList<weak Plank.Items.DockItem> VisibleItems { get; }
		public GLib.File config_folder { get; construct; }
		public Plank.Items.DockItemProvider? default_provider { get; private set; }
		public Plank.DragManager drag_manager { get; protected set; }
		public Plank.HideManager hide_manager { get; protected set; }
		public GLib.File launchers_folder { get; private set; }
		public Plank.PositionManager position_manager { get; protected set; }
		public Plank.DockPreferences prefs { get; construct; }
		public Plank.DockRenderer renderer { get; protected set; }
		public Plank.Widgets.DockWindow window { get; protected set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockPreferences : Plank.Services.Preferences {
		public const int MAX_ICON_SIZE;
		public const int MAX_ICON_ZOOM;
		public const int MIN_ICON_SIZE;
		public const int MIN_ICON_ZOOM;
		public DockPreferences ();
		public void decrease_icon_size ();
		public void increase_icon_size ();
		public bool is_horizontal_dock ();
		protected override void reset_properties ();
		protected override void verify (string prop);
		public DockPreferences.with_file (GLib.File file);
		public DockPreferences.with_filename (string filename);
		[Description (blurb = "The alignment for the dock on the monitor's edge.  If 0, panel-mode.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", nick = "alignment")]
		public Gtk.Align Alignment { get; set; }
		[Description (blurb = "Whether to automatically pin an application if it seems useful to do.", nick = "auto-pinning")]
		public bool AutoPinning { get; set; }
		[Description (blurb = "Whether to show only windows of the current workspace.", nick = "current-workspace-only")]
		public bool CurrentWorkspaceOnly { get; set; }
		[Description (blurb = "List of *.dockitem files on this dock. DO NOT MODIFY", nick = "dock-items")]
		public string DockItems { get; set; }
		[Description (blurb = "Time (in ms) to wait before hiding the dock.", nick = "hide-delay")]
		public uint HideDelay { get; set; }
		[Description (blurb = "If 0, the dock won't hide.  If 1, the dock intelligently hides.  If 2, the dock auto-hides. If 3, the dock dodges active maximized windows. If 4, the dock dodges every window.", nick = "hide-mode")]
		public Plank.HideType HideMode { get; set; }
		[Description (blurb = "The size of dock icons (in pixels).", nick = "icon-size")]
		public int IconSize { get; set; }
		[Description (blurb = "The alignment of the items in this dock if panel-mode is used.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", nick = "items-alignment")]
		public Gtk.Align ItemsAlignment { get; set; }
		[Description (blurb = "Whether to prevent drag'n'drop actions and lock items on the dock.", nick = "lock-items")]
		public bool LockItems { get; set; }
		[Description (blurb = "The plug-name of the monitor for the dock to show on (e.g. DVI-I-1, HDMI1, LVDS1). Leave this empty to keep on the primary monitor.", nick = "monitor")]
		public string Monitor { get; set; }
		[Description (blurb = "The dock's position offset from center (in percent).", nick = "offset")]
		public int Offset { get; set; }
		[Description (blurb = "Whether to show only pinned applications. Useful for running more then one dock.", nick = "pinned-only")]
		public bool PinnedOnly { get; set; }
		[Description (blurb = "The position for the dock on the monitor.  If 0, left.  If 1, right.  If 2, top.  If 3, bottom.", nick = "position")]
		public Gtk.PositionType Position { get; set; }
		[Description (blurb = "Whether to use pressure-based revealing of the dock if the support is available.", nick = "pressure-reveal")]
		public bool PressureReveal { get; set; }
		[Description (blurb = "Whether to show the item for the dock itself.", nick = "show-dock-item")]
		public bool ShowDockItem { get; set; }
		[Description (blurb = "The name of the dock's theme to use.", nick = "theme")]
		public string Theme { get; set; }
		[Description (blurb = "Time (in ms) to wait before unhiding the dock.", nick = "unhide-delay")]
		public uint UnhideDelay { get; set; }
		[Description (blurb = "Whether the dock will zoom when hovered.", nick = "zoom-enabled")]
		public bool ZoomEnabled { get; set; }
		[Description (blurb = "The dock's icon-zoom (in percent).", nick = "zoom-percent")]
		public uint ZoomPercent { get; set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockRenderer : Plank.Drawing.AnimatedRenderer {
		public DockRenderer (Plank.DockController controller, Gtk.Window window);
		public void animate_items (Gee.List<Plank.Items.DockElement> elements);
		protected override bool animation_needed (int64 frame_time);
		public override void draw (Cairo.Context cr, int64 frame_time);
		public void initialize ();
		protected override void initialize_frame (int64 frame_time);
		public void reset_buffers ();
		public void update_local_cursor (int x, int y);
		public Plank.DockController controller { private get; construct; }
		[CCode (notify = false)]
		public double hide_progress { get; private set; }
		[CCode (notify = false)]
		public Gdk.Point local_cursor { get; private set; }
		public Plank.Drawing.DockTheme theme { get; private set; }
		[CCode (notify = false)]
		public double zoom_in_progress { get; private set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DragManager : GLib.Object {
		public DragManager (Plank.DockController controller);
		public bool drop_is_accepted_by (Plank.Items.DockItem item);
		public void ensure_proxy ();
		public void initialize ();
		public bool DragIsDesktopFile { get; private set; }
		public Plank.Items.DockItem? DragItem { get; private set; }
		public bool ExternalDragActive { get; private set; }
		public bool InternalDragActive { get; private set; }
		public bool RepositionMode { get; private set; }
		public Plank.DockController controller { private get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class HideManager : GLib.Object {
		public HideManager (Plank.DockController controller);
		public void initialize ();
		public void update_barrier ();
		public void update_hovered ();
		public void update_hovered_with_coords (int x, int y);
		public bool Disabled { get; private set; }
		public bool Hidden { get; private set; }
		public bool Hovered { get; private set; }
		public Plank.DockController controller { private get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class PositionManager : GLib.Object {
		public class DockItemDrawValue {
			public Gdk.Rectangle background_region;
			public Plank.PositionManager.PointD center;
			public double darken;
			public Gdk.Rectangle draw_region;
			public Gdk.Rectangle hover_region;
			public double icon_size;
			public double lighten;
			public double opacity;
			public bool show_indicator;
			public Plank.PositionManager.PointD static_center;
			public double zoom;
			public DockItemDrawValue ();
			public void move_in (Gtk.PositionType position, double damount);
			public void move_right (Gtk.PositionType position, double damount);
		}
		public struct PointD {
			public double x;
			public double y;
		}
		public delegate void DockItemDrawValueFunc (Plank.Items.DockItem item, Plank.PositionManager.DockItemDrawValue draw_value);
		public delegate void DrawValuesFunc (Gee.HashMap<Plank.Items.DockElement,Plank.PositionManager.DockItemDrawValue> draw_values);
		public PositionManager (Plank.DockController controller);
		public Gdk.Rectangle get_background_region ();
		public Gdk.Rectangle get_barrier ();
		public Gdk.Rectangle get_cursor_region ();
		public void get_dock_draw_position (out int x, out int y);
		public Gdk.Rectangle get_dock_window_region ();
		public Plank.PositionManager.DockItemDrawValue get_draw_value_for_item (Plank.Items.DockItem item);
		public void get_hover_position (Plank.Items.DockItem hovered, out int x, out int y);
		public Gdk.Rectangle get_hover_region_for_element (Plank.Items.DockElement element);
		public Gdk.Rectangle get_icon_geometry (Plank.Items.ApplicationDockItem item, bool for_hidden);
		public void get_menu_position (Plank.Items.DockItem hovered, Gtk.Requisition requisition, out int x, out int y);
		public static string[] get_monitor_plug_names (Gdk.Screen screen);
		public unowned Plank.Items.DockItem? get_nearest_item_at (int x, int y, Plank.Items.DockContainer? container = null);
		public Gdk.Rectangle get_static_dock_region ();
		public void get_struts (ref ulong[] struts);
		public void get_urgent_glow_position (Plank.Items.DockItem item, out int x, out int y);
		public void initialize ();
		public bool is_horizontal_dock ();
		public void update (Plank.Drawing.DockTheme theme);
		public void update_dock_position ();
		public void update_draw_values (Gee.ArrayList<weak Plank.Items.DockItem> items, Plank.PositionManager.DockItemDrawValueFunc? func = null, Plank.PositionManager.DrawValuesFunc? post_func = null);
		public void update_regions ();
		public Gtk.Align Alignment { get; private set; }
		public int BottomPadding { get; private set; }
		public int GlowSize { get; private set; }
		public int HorizPadding { get; private set; }
		public int IconShadowSize { get; private set; }
		public int IconSize { get; private set; }
		public int IndicatorSize { get; private set; }
		public int ItemPadding { get; private set; }
		public Gtk.Align ItemsAlignment { get; private set; }
		public int LaunchBounceHeight { get; private set; }
		public int LineWidth { get; private set; }
		public int MaxItemCount { get; private set; }
		public int Offset { get; private set; }
		public Gtk.PositionType Position { get; private set; }
		public int TopPadding { get; private set; }
		public int UrgentBounceHeight { get; private set; }
		public int ZoomIconSize { get; private set; }
		public Plank.DockController controller { private get; construct; }
		public bool screen_is_composited { get; private set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public enum HideType {
		NONE,
		INTELLIGENT,
		AUTO,
		DODGE_MAXIMIZED,
		WINDOW_DODGE,
		DODGE_ACTIVE
	}
	[CCode (cheader_filename = "plank.h")]
	public const string G_RESOURCE_PATH;
}
