/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui.midi;

import common.ImageToolBar;
import common.Midi;
import common.SwingWorker;
import common.Util;
import dguitar.gui.DGuitar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MidiTest
extends JDialog
implements ListSelectionListener,
ActionListener,
WindowListener {
    public int defaultInst;
    static int duration;
    private ImageToolBar NoteToolBar;
    private Image playImg;
    private boolean playing;
    private SwingWorker workerPlay;
    private Midi midi;
    JToolBar TB;
    JToggleButton playBtn;
    private JList instruments;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    public MidiTest(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
    }

    public short createMidiTestWindow(Midi midiRef, Image[] notes, Image play) {
        String[] insts;
        this.playing = false;
        this.workerPlay = null;
        this.playImg = play;
        this.setResizable(false);
        this.midi = midiRef;
        this.initComponents();
        short attempts = -1;
        this.addToolBar(notes);
        this.pack();
        boolean testing = false;
        int max = 99;
        attempts = 1;
        do {
            insts = this.midi.getInstrumentStrings();
            if (testing && this.midi.getCurrentDeviceIndex() <= max) {
                insts = null;
            }
            if (insts != null) continue;
            String aux = "Device: " + this.midi.getCurrentDeviceName();
            aux = String.valueOf(aux) + ", no instruments available";
            Util.showDialogOk(this, "Midi instrument list failed", aux);
            this.midi.selectNextAvailableMidiDevice();
            attempts = (short)(attempts + 1);
        } while (insts == null && attempts < this.midi.getNumberOfMidiDevices());
        if (attempts == this.midi.getNumberOfMidiDevices()) {
            attempts = (short)(-1 * attempts);
        }
        if (insts != null) {
            this.setTitle(String.valueOf(this.getTitle()) + ":" + this.midi.getCurrentDeviceName());
            this.instruments.setListData(insts);
            this.instruments.setSelectionMode(0);
            this.instruments.addListSelectionListener(this);
            this.defaultInst = 0;
            if (insts.length >= 24) {
                this.defaultInst = 24;
            }
            this.instruments.setSelectedIndex(this.defaultInst);
            this.instruments.ensureIndexIsVisible(this.defaultInst);
            this.midi.prepareToPlay();
            duration = 4;
            this.createScale();
            this.addWindowListener(this);
        }
        return attempts;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.instruments = new JList();
        this.TB = new JToolBar();
        this.playBtn = new JToggleButton(new ImageIcon(this.playImg));
        this.playBtn.addActionListener(this);
        this.TB.setFloatable(false);
        this.TB.add(this.playBtn);
        this.setDefaultCloseOperation(2);
        this.setTitle(DGuitar.getLang().getString("Midi_Test"));
        this.jLabel1.setText(DGuitar.getLang().getString("Instruments"));
        this.getContentPane().add((Component)this.jLabel1, "North");
        this.jScrollPane1.setViewportView(this.instruments);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.TB, "East");
    }

    public void valueChanged(ListSelectionEvent e) {
        this.createScale();
    }

    private void setCurrentInstrument() {
        int inst = this.instruments.getSelectedIndex();
        this.midi.setInstrument(inst);
    }

    private void addToolBar(Image[] imgs) {
        this.NoteToolBar = new ImageToolBar();
        this.NoteToolBar.setFloatable(false);
        this.NoteToolBar.setNumButtons(8);
        this.NoteToolBar.setImages(imgs);
        this.NoteToolBar.addActionListener(new NoteToolBarListener());
        this.getContentPane().add((Component)this.NoteToolBar, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 300) / 2, (screenSize.height - 300) / 2, 400, 300);
        this.validate();
    }

    private void createScale() {
        this.midi.setSequencePPQ(16);
        this.midi.DELTA = 128 / Util.pow2(duration);
        this.setCurrentInstrument();
        int note = 60;
        while (note <= 66) {
            this.midi.addNote(note);
            ++note;
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        if (!this.playing) {
            this.workerPlay = new SwingWorker(){

                public Object construct() {
                    PropertyResourceBundle l = DGuitar.getLang();
                    JDialog jd = Util.createDialog((JFrame)MidiTest.this.getParent(), l.getString("msgSoundTestInProgress"), l.getString("Midi_Test"), false);
                    jd.setFocusable(true);
                    jd.setVisible(true);
                    MidiTest.this.midi.play();
                    MidiTest.this.playing = false;
                    MidiTest.this.playBtn.setSelected(false);
                    jd.setVisible(false);
                    return null;
                }
            };
            this.playing = true;
            this.workerPlay.start();
        } else {
            this.midi.stop();
            this.playing = false;
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.workerPlay != null) {
            this.workerPlay.interrupt();
            this.midi.stop();
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    class NoteToolBarListener
    implements ActionListener {
        NoteToolBarListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            JButton jbutton = new JButton();
            if (obj.getClass().isInstance(jbutton)) {
                jbutton = (JButton)obj;
                try {
                    duration = Integer.parseInt(jbutton.getActionCommand());
                    MidiTest.this.createScale();
                }
                catch (NumberFormatException NFE) {
                    NFE.printStackTrace();
                }
            }
        }
    }
}

