/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;

public class PayloadScoreQuery
extends SpanQuery {
    private final SpanQuery wrappedQuery;
    private final PayloadFunction function;
    private final boolean includeSpanScore;

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, boolean includeSpanScore) {
        this.wrappedQuery = wrappedQuery;
        this.function = function;
        this.includeSpanScore = includeSpanScore;
    }

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function) {
        this(wrappedQuery, function, true);
    }

    public String getField() {
        return this.wrappedQuery.getField();
    }

    public String toString(String field) {
        return "PayloadSpanQuery[" + this.wrappedQuery.toString(field) + "; " + this.function.toString() + "]";
    }

    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight innerWeight = this.wrappedQuery.createWeight(searcher, needsScores);
        if (!needsScores) {
            return innerWeight;
        }
        return new PayloadSpanWeight(searcher, innerWeight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayloadScoreQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayloadScoreQuery that = (PayloadScoreQuery)((Object)o);
        if (this.wrappedQuery != null ? !this.wrappedQuery.equals((Object)that.wrappedQuery) : that.wrappedQuery != null) {
            return false;
        }
        return !(this.function == null ? that.function != null : !this.function.equals(that.function));
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.wrappedQuery != null ? this.wrappedQuery.hashCode() : 0);
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        return result;
    }

    private class PayloadSpans
    extends Spans
    implements SpanCollector {
        private int payloadsSeen;
        private float payloadScore;
        private final Spans in;

        private PayloadSpans(Spans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
            super(weight, docScorer);
            this.in = spans;
        }

        public int nextStartPosition() throws IOException {
            return this.in.nextStartPosition();
        }

        public int startPosition() {
            return this.in.startPosition();
        }

        public int endPosition() {
            return this.in.endPosition();
        }

        public int width() {
            return this.in.width();
        }

        public void collect(SpanCollector collector) throws IOException {
            this.in.collect(collector);
        }

        protected void doStartCurrentDoc() {
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
        }

        protected void doCurrentSpans() throws IOException {
            this.in.collect((SpanCollector)this);
        }

        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            BytesRef payload = postings.getPayload();
            if (payload == null) {
                return;
            }
            float payloadFactor = this.docScorer.computePayloadFactor(this.docID(), this.in.startPosition(), this.in.endPosition(), payload);
            this.payloadScore = PayloadScoreQuery.this.function.currentScore(this.docID(), PayloadScoreQuery.this.getField(), this.in.startPosition(), this.in.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
            ++this.payloadsSeen;
        }

        protected float getPayloadScore() {
            return PayloadScoreQuery.this.function.docScore(this.docID(), PayloadScoreQuery.this.getField(), this.payloadsSeen, this.payloadScore);
        }

        protected Explanation getPayloadExplanation() {
            return PayloadScoreQuery.this.function.explain(this.docID(), PayloadScoreQuery.this.getField(), this.payloadsSeen, this.payloadScore);
        }

        protected float getSpanScore() throws IOException {
            return super.scoreCurrentDoc();
        }

        protected float scoreCurrentDoc() throws IOException {
            if (PayloadScoreQuery.this.includeSpanScore) {
                return this.getSpanScore() * this.getPayloadScore();
            }
            return this.getPayloadScore();
        }

        public void reset() {
        }

        public int docID() {
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            return this.in.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }

        public long cost() {
            return this.in.cost();
        }

        public float positionsCost() {
            return this.in.positionsCost();
        }
    }

    private class PayloadSpanWeight
    extends SpanWeight {
        private final SpanWeight innerWeight;

        public PayloadSpanWeight(IndexSearcher searcher, SpanWeight innerWeight) throws IOException {
            super((SpanQuery)PayloadScoreQuery.this, searcher, null);
            this.innerWeight = innerWeight;
        }

        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.innerWeight.extractTermContexts(contexts);
        }

        public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
            return this.innerWeight.getSpans(ctx, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            return new PayloadSpans(spans, this, this.innerWeight.getSimScorer(context));
        }

        public void extractTerms(Set<Term> terms) {
            this.innerWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.innerWeight.getValueForNormalization();
        }

        public void normalize(float queryNorm, float topLevelBoost) {
            this.innerWeight.normalize(queryNorm, topLevelBoost);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            PayloadSpans scorer = (PayloadSpans)this.scorer(context);
            if (scorer == null || scorer.advance(doc) != doc) {
                return Explanation.noMatch((String)"No match", (Explanation[])new Explanation[0]);
            }
            scorer.freq();
            Explanation payloadExpl = scorer.getPayloadExplanation();
            if (PayloadScoreQuery.this.includeSpanScore) {
                SpanWeight innerWeight = ((PayloadSpanWeight)scorer.getWeight()).innerWeight;
                Explanation innerExpl = innerWeight.explain(context, doc);
                return Explanation.match((float)scorer.scoreCurrentDoc(), (String)"PayloadSpanQuery, product of:", (Explanation[])new Explanation[]{innerExpl, payloadExpl});
            }
            return scorer.getPayloadExplanation();
        }
    }
}

