/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.SloppyMath;

public class GeoDistanceUtils {
    public static final double vincentyDistance(double lonA, double latA, double lonB, double latB) {
        double lambdaP;
        double cos2SigmaM;
        double cosLambda;
        double cosSigma;
        double sigma;
        double sinSigma;
        double sinLambda;
        double sinAlpha;
        double cos2Alpha;
        double c;
        double L = StrictMath.toRadians(lonB - lonA);
        double oF = 0.9966471893352525;
        double U1 = StrictMath.atan(0.9966471893352525 * StrictMath.tan(StrictMath.toRadians(latA)));
        double U2 = StrictMath.atan(0.9966471893352525 * StrictMath.tan(StrictMath.toRadians(latB)));
        double sU1 = StrictMath.sin(U1);
        double cU1 = StrictMath.cos(U1);
        double sU2 = StrictMath.sin(U2);
        double cU2 = StrictMath.cos(U2);
        double lambda = L;
        double iters = 100.0;
        do {
            if ((sinSigma = Math.sqrt(cU2 * (sinLambda = StrictMath.sin(lambda)) * (cU2 * sinLambda) + (cU1 * sU2 - sU1 * cU2 * (cosLambda = Math.cos(lambda))) * (cU1 * sU2 - sU1 * cU2 * cosLambda))) != 0.0) continue;
            return 0.0;
        } while (StrictMath.abs((lambda = L + (1.0 - (c = 2.0955066654671753E-4 * (cos2Alpha = 1.0 - (sinAlpha = cU1 * cU2 * sinLambda / sinSigma) * sinAlpha) * (4.0 + 0.0033528106647474805 * (4.0 - 3.0 * cos2Alpha)))) * 0.0033528106647474805 * sinAlpha * ((sigma = Math.atan2(sinSigma, cosSigma = sU1 * sU2 + cU1 * cU2 * cosLambda)) + c * sinSigma * ((cos2SigmaM = cosSigma - 2.0 * sU1 * sU2 / cos2Alpha) + c * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iters -= 1.0) > 0.0);
        if (iters == 0.0) {
            return 0.0;
        }
        double uSq = cos2Alpha * 2.723316061075547E11 / 4.0408299984661445E13;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        return 6356752.314245179 * A * (sigma - deltaSigma);
    }

    public static double distanceToDegreesLon(double lat, double distance) {
        lat = StrictMath.toRadians(lat);
        double diameter = SloppyMath.earthDiameter((double)StrictMath.toRadians(lat));
        double a = StrictMath.sin((distance /= 1000.0) / diameter);
        double h = StrictMath.min(1.0, a);
        h *= h;
        double cLat = StrictMath.cos(lat);
        return StrictMath.toDegrees(StrictMath.acos(1.0 - 2.0 * h / (cLat * cLat)));
    }

    public static void closestPointOnBBox(double rMinX, double rMinY, double rMaxX, double rMaxY, double lon, double lat, double[] closestPt) {
        assert (closestPt != null && closestPt.length == 2);
        closestPt[0] = 0.0;
        closestPt[1] = 0.0;
        boolean xSet = true;
        boolean ySet = true;
        if (lon > rMaxX) {
            closestPt[0] = rMaxX;
        } else if (lon < rMinX) {
            closestPt[0] = rMinX;
        } else {
            xSet = false;
        }
        if (lat > rMaxY) {
            closestPt[1] = rMaxY;
        } else if (lat < rMinY) {
            closestPt[1] = rMinY;
        } else {
            ySet = false;
        }
        if (closestPt[0] == 0.0 && !xSet) {
            closestPt[0] = lon;
        }
        if (closestPt[1] == 0.0 && !ySet) {
            closestPt[1] = lat;
        }
    }

    public static double maxRadialDistanceMeters(double centerLon, double centerLat) {
        if (Math.abs(centerLat) == 90.0) {
            return SloppyMath.haversin((double)centerLat, (double)centerLon, (double)0.0, (double)centerLon) * 1000.0;
        }
        return SloppyMath.haversin((double)centerLat, (double)centerLon, (double)centerLat, (double)((180.0 + centerLon) % 360.0)) * 1000.0;
    }

    public static double distanceToDegreesLat(double lat, double distance) {
        double diameter = SloppyMath.earthDiameter((double)StrictMath.toRadians(lat));
        double a = StrictMath.sin((distance /= 1000.0) / diameter);
        double h = StrictMath.min(1.0, a);
        h *= h;
        return StrictMath.toDegrees(StrictMath.acos(1.0 - 2.0 * h));
    }
}

