/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.ReadUserKeywordsHashNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadRestArgumentNode
extends RubyNode {
    private final int startIndex;
    private final int negativeEndIndex;
    private final boolean keywordArguments;
    private final int minimumForKWargs;
    private final BranchProfile noArgumentsLeftProfile = BranchProfile.create();
    private final BranchProfile subsetOfArgumentsProfile = BranchProfile.create();
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;

    public ReadRestArgumentNode(RubyContext context, SourceSection sourceSection, int startIndex, int negativeEndIndex, boolean keywordArguments, int minimumForKWargs) {
        super(context, sourceSection);
        this.startIndex = startIndex;
        this.negativeEndIndex = negativeEndIndex;
        this.keywordArguments = keywordArguments;
        this.minimumForKWargs = minimumForKWargs;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(context, sourceSection, minimumForKWargs);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int resultLength;
        Object[] resultStore;
        Object[] arguments;
        Object lastArgument;
        int count = RubyArguments.getArgumentsCount(frame.getArguments());
        int endIndex = count + this.negativeEndIndex;
        if (this.keywordArguments && RubyGuards.isRubyHash(lastArgument = RubyArguments.getArgument(frame.getArguments(), RubyArguments.getArgumentsCount(frame.getArguments()) - 1))) {
            --endIndex;
        }
        int length = endIndex - this.startIndex;
        if (this.startIndex == 0) {
            resultStore = arguments = RubyArguments.getArguments(frame.getArguments());
            resultLength = length;
        } else if (this.startIndex >= endIndex) {
            this.noArgumentsLeftProfile.enter();
            resultStore = null;
            resultLength = 0;
        } else {
            this.subsetOfArgumentsProfile.enter();
            arguments = RubyArguments.getArguments(frame.getArguments());
            resultStore = ArrayUtils.extractRange(arguments, this.startIndex, endIndex);
            resultLength = length;
        }
        DynamicObject rest = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), resultStore, resultLength);
        if (this.keywordArguments) {
            CompilerDirectives.transferToInterpreter();
            Object kwargsHash = this.readUserKeywordsHashNode.execute(frame);
            if (kwargsHash == null) {
                kwargsHash = this.nil();
            }
            this.getContext().inlineRubyHelper((Node)this, "Truffle::Primitive.add_rejected_kwargs_to_rest(rest, kwargs)", "rest", rest, "kwargs", kwargsHash);
        }
        return rest;
    }
}

