// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var E, KeyPatcher, constants, env, iced, load_key, log, make_esc, master_ring, prompt_for_int, prompt_passphrase, __iced_k, __iced_k_noop, _ref, _ref1;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  constants = require('./constants').constants;

  make_esc = require('iced-error').make_esc;

  _ref = require('./keyring'), load_key = _ref.load_key, master_ring = _ref.master_ring;

  _ref1 = require('./prompter'), prompt_passphrase = _ref1.prompt_passphrase, prompt_for_int = _ref1.prompt_for_int;

  env = require('./env').env;

  log = require('./log');

  E = require('./err').E;

  exports.KeyPatcher = KeyPatcher = (function() {
    function KeyPatcher(_arg) {
      var kbpgp;
      this.key = _arg.key, this.opts = _arg.opts;
      this.ring || (this.ring = master_ring());
      kbpgp = require('kbpgp');
      this.lib = {
        KeyManager: kbpgp.KeyManager,
        UserID: kbpgp.opkts.UserID,
        parse: kbpgp.parser.parse
      };
      this.did_patch = false;
      this.em = env().keybase_email();
    }

    KeyPatcher.prototype.import_key = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
            funcname: "KeyPatcher.import_key"
          });
          _this.lib.KeyManager.import_from_armored_pgp({
            raw: _this.key.key_data()
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.km = arguments[1];
              };
            })(_this),
            lineno: 28
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    KeyPatcher.prototype.import_secret_key = function(cb) {
      var esc, k, passphrase, uid, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyPatcher::import_secret_key");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
            funcname: "KeyPatcher.import_secret_key"
          });
          load_key({
            fingerprint: _this.key.fingerprint(),
            secret: true
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return k = arguments[0];
              };
            })(),
            lineno: 35
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
              funcname: "KeyPatcher.import_secret_key"
            });
            _this.lib.KeyManager.import_from_armored_pgp({
              raw: k.key_data()
            }, esc(__iced_deferrals.defer({
              assign_fn: (function(__slot_1) {
                return function() {
                  return __slot_1.skm = arguments[0];
                };
              })(_this),
              lineno: 36
            })));
            __iced_deferrals._fulfill();
          })(function() {
            uid = _this.lib.UserID.make(k.uid());
            (function(__iced_k) {
              if (_this.skm.is_pgp_locked()) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                    funcname: "KeyPatcher.import_secret_key"
                  });
                  prompt_passphrase({
                    prompt: "Passphrase for key '" + (uid.utf8()) + "'",
                    short: true
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return passphrase = arguments[0];
                      };
                    })(),
                    lineno: 39
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  log.debug("+ unlock_pgp");
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                      funcname: "KeyPatcher.import_secret_key"
                    });
                    _this.skm.unlock_pgp({
                      passphrase: passphrase
                    }, esc(__iced_deferrals.defer({
                      lineno: 41
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return __iced_k(log.debug("- unlock_pgp"));
                  });
                });
              } else {
                return __iced_k();
              }
            })(function() {
              return cb(null);
            });
          });
        };
      })(this));
    };

    KeyPatcher.prototype.needs_patch = function() {
      return !this.key.has_canonical_username();
    };

    KeyPatcher.prototype.export_patch = function(cb) {
      var esc, msg, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ KeyPatcher::export_patch");
      esc = make_esc(cb, "KeyPatcher::export_patch");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
            funcname: "KeyPatcher.export_patch"
          });
          _this.skm.export_pgp_public({
            regen: true
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return msg = arguments[0];
              };
            })(),
            lineno: 54
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
              funcname: "KeyPatcher.export_patch"
            });
            _this.ring.gpg({
              args: ["--import"],
              quiet: true,
              stdin: msg
            }, esc(__iced_deferrals.defer({
              lineno: 55
            })));
            __iced_deferrals._fulfill();
          })(function() {
            log.debug("- KeyPatcher::export_patch");
            return cb(null);
          });
        };
      })(this));
    };

    KeyPatcher.prototype.reload_key = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
            funcname: "KeyPatcher.reload_key"
          });
          load_key({
            fingerprint: _this.key.fingerprint(),
            secret: false
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.key = arguments[1];
              };
            })(_this),
            lineno: 62
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    KeyPatcher.prototype.verify = function(cb) {
      var err;
      err = this.key.has_canonical_username() ? null : new E.PatchError("Key update filaed; please report this bug");
      return cb(err);
    };

    KeyPatcher.prototype.run_patch_sequence = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyPatcher::run_patch_sequence");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
            funcname: "KeyPatcher.run_patch_sequence"
          });
          _this.import_secret_key(esc(__iced_deferrals.defer({
            lineno: 76
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
              funcname: "KeyPatcher.run_patch_sequence"
            });
            _this.patch_key(esc(__iced_deferrals.defer({
              lineno: 77
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                funcname: "KeyPatcher.run_patch_sequence"
              });
              _this.export_patch(esc(__iced_deferrals.defer({
                lineno: 78
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                  funcname: "KeyPatcher.run_patch_sequence"
                });
                _this.reload_key(esc(__iced_deferrals.defer({
                  lineno: 79
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                    funcname: "KeyPatcher.run_patch_sequence"
                  });
                  _this.verify(esc(__iced_deferrals.defer({
                    lineno: 80
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  return cb(null);
                });
              });
            });
          });
        };
      })(this));
    };

    KeyPatcher.prototype.get_key = function() {
      return this.key;
    };

    KeyPatcher.prototype.patch_key = function(cb) {
      var esc, pgp, uid, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyPatcher::run_patch");
      pgp = this.skm.pgp;
      uid = this.lib.UserID.make(env().make_pgp_uid());
      pgp.userids = [uid];
      pgp.subkeys = [];
      pgp.primary.lifespan.expire_in = 0;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
            funcname: "KeyPatcher.patch_key"
          });
          _this.skm.sign({}, esc(__iced_deferrals.defer({
            lineno: 100
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    KeyPatcher.prototype.prompt_patch = function(cb) {
      var args, diff, do_warning, em, err, go, i, line, msg, prompt, spc, w, width, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      em = this.uid.get_email();
      width = 70;
      line = ((function() {
        var _i, _results;
        _results = [];
        for (i = _i = 0; 0 <= width ? _i < width : _i > width; i = 0 <= width ? ++_i : --_i) {
          _results.push("-");
        }
        return _results;
      })()).join('');
      msg = "Enabling " + em;
      diff = width - msg.length;
      spc = diff > 0 ? ((function() {
        var _i, _ref2, _results;
        _results = [];
        for (i = _i = 0, _ref2 = diff >> 1; 0 <= _ref2 ? _i < _ref2 : _i > _ref2; i = 0 <= _ref2 ? ++_i : --_i) {
          _results.push(' ');
        }
        return _results;
      })()).join('') : '';
      msg = "\n" + line + "\n" + spc + msg + "\n" + line + "\n\nAll keybase users get a free @keybase.io address, which \nforwards incoming mail and acts, for privacy, as the return\naddress on outgoing mail generated via `keybase email`.\n\nThis feature works **much** better with existing GPG clients\nif you add " + em + " to your public key.\n\nYou have 3 options:\n\n  (1) Exit now; I can add " + em + " with GPG or my own software\n  (2) Allow keybase to add it for me\n  (3) Skip this step and do it later (not recommended)\n";
      (function(_this) {
        return (function(__iced_k) {
          if (_this.opts.skip_add_email) {
            return __iced_k(go = false);
          } else {
            (function(__iced_k) {
              if (_this.opts.add_email) {
                return __iced_k(go = true);
              } else {
                do_warning = false;
                log.console.log(msg);
                prompt = "Your choice";
                err = null;
                go = false;
                args = {
                  prompt: "Your choice",
                  low: 1,
                  hi: 3,
                  defint: 2,
                  hint: "pick 1,2 or 3",
                  first_prompt: " (2)"
                };
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                    funcname: "KeyPatcher.prompt_patch"
                  });
                  prompt_for_int(args, __iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        err = arguments[0];
                        return i = arguments[1];
                      };
                    })(),
                    lineno: 148
                  }));
                  __iced_deferrals._fulfill();
                })(function() {
                  if (err == null) {
                    switch (i) {
                      case 1:
                        err = new E.CancelError("please edit your key and rerun this command");
                        break;
                      case 2:
                        do_warning = true;
                        go = true;
                        break;
                      case 3:
                        go = false;
                    }
                  }
                  return __iced_k(do_warning ? (w = "\n" + line + "\n\nOK. Keybase will now modify your public key by merging\n" + em + " into its approved list of emails.  This\noperation requires temporary local access to your secret \nkey and then throws it away. The client will not write\nyour decrypted secret key to disk or to the server.\n", log.console.log(w)) : void 0);
                });
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, go);
        };
      })(this));
    };

    KeyPatcher.prototype.run = function(_arg, cb) {
      var esc, go_patch, interactive, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      interactive = _arg.interactive;
      esc = make_esc(cb, "KeyPatcher::run_patch");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
            funcname: "KeyPatcher.run"
          });
          _this.import_key(esc(__iced_deferrals.defer({
            lineno: 178
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (_this.needs_patch()) {
              _this.uid = _this.lib.UserID.make(env().make_pgp_uid());
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                  funcname: "KeyPatcher.run"
                });
                _this.prompt_patch(esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return go_patch = arguments[0];
                    };
                  })(),
                  lineno: 182
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  if (go_patch) {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/node-client/src/keypatch.iced",
                        funcname: "KeyPatcher.run"
                      });
                      _this.run_patch_sequence(esc(__iced_deferrals.defer({
                        lineno: 183
                      })));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  } else {
                    return __iced_k();
                  }
                })(__iced_k);
              });
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(null, go_patch);
          });
        };
      })(this));
    };

    return KeyPatcher;

  })();

}).call(this);
