// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ACCTYPES, BTC, CHECK, E, Link, LinkTable, Proof, ProofSet, SHA256, ST, SigCache, SigChain, Warnings, asyncify, athrow, bitcoyne, cheerio, colors, constants, date_to_unix, db, deq, dict_union, env, format_fingerprint, fs, iced, libkeybase, log, make_email, make_esc, merkle_client, proofs, req, request, scrapemod, util, __iced_k, __iced_k_noop, _ref, _ref1, _ref2, _ref3, _ref4;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  db = require('./db');

  req = require('./req');

  log = require('./log');

  constants = require('./constants').constants;

  SHA256 = require('./keyutils').SHA256;

  E = require('./err').E;

  _ref = require('pgp-utils').util, format_fingerprint = _ref.format_fingerprint, Warnings = _ref.Warnings, asyncify = _ref.asyncify;

  make_esc = require('iced-error').make_esc;

  ST = constants.signature_types;

  ACCTYPES = constants.allowed_cryptocurrency_types;

  _ref1 = require('./util'), dict_union = _ref1.dict_union, date_to_unix = _ref1.date_to_unix, make_email = _ref1.make_email;

  proofs = require('keybase-proofs');

  cheerio = require('cheerio');

  request = require('request');

  colors = require('./colors');

  deq = require('deep-equal');

  util = require('util');

  fs = require('fs');

  env = require('./env').env;

  scrapemod = require('./scrapers');

  _ref2 = require('./display'), CHECK = _ref2.CHECK, BTC = _ref2.BTC;

  athrow = require('iced-utils').util.athrow;

  merkle_client = require('./merkle_client').merkle_client;

  bitcoyne = require('bitcoyne');

  _ref3 = require('./chainlink'), Link = _ref3.Link, LinkTable = _ref3.LinkTable;

  _ref4 = require('libkeybase').assertion, Proof = _ref4.Proof, ProofSet = _ref4.ProofSet;

  libkeybase = require('libkeybase');

  exports.SigChain = SigChain = (function() {
    function SigChain(uid, username, _links) {
      this.uid = uid;
      this.username = username;
      this._links = _links != null ? _links : [];
      this._lookup = {};
      this._index_links(this._links);
      this._true_last = null;
    }

    SigChain.prototype._index_links = function(list) {
      var l, _i, _len, _results;
      _results = [];
      for (_i = 0, _len = list.length; _i < _len; _i++) {
        l = list[_i];
        _results.push(this._lookup[l.id] = l);
      }
      return _results;
    };

    SigChain.prototype.lookup = function(id) {
      return this._lookup[id];
    };

    SigChain.load = function(uid, username, curr, cb) {
      var err, link, links, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ " + uid + ": load signature chain");
      links = [];
      err = null;
      ret = null;
      (function(_this) {
        return (function(__iced_k) {
          var _results, _while;
          _results = [];
          _while = function(__iced_k) {
            var _break, _continue, _next;
            _break = function() {
              return __iced_k(_results);
            };
            _continue = function() {
              return iced.trampoline(function() {
                return _while(__iced_k);
              });
            };
            _next = function(__iced_next_arg) {
              _results.push(__iced_next_arg);
              return _continue();
            };
            if (!(curr && (err == null))) {
              return _break();
            } else {
              log.debug("| " + uid + ": Loading link " + curr);
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/sigchain.iced",
                  funcname: "SigChain.load"
                });
                Link.load(curr, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      err = arguments[0];
                      return link = arguments[1];
                    };
                  })(),
                  lineno: 56
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return _next(err != null ? (log.error("Couldn't find link: " + last), log.debug("| -> error")) : typeof link !== "undefined" && link !== null ? (links.push(link), curr = link.prev(), log.debug("| -> found link and previous; prev=" + curr)) : (log.debug("| -> reached the chain end"), curr = null));
              });
            }
          };
          _while(__iced_k);
        });
      })(this)((function(_this) {
        return function() {
          if (err == null) {
            ret = new SigChain(uid, username, links.reverse());
          }
          log.debug("- " + uid + ": loaded signature chain");
          return cb(err, ret);
        };
      })(this));
    };

    SigChain.prototype.last_seqno = function() {
      var l;
      if ((l = this.last()) != null) {
        return l.seqno();
      } else {
        return null;
      }
    };

    SigChain.prototype._update = function(cb) {
      var args, body, did_update, esc, link, new_links, obj, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ sigchain::_update");
      esc = make_esc(cb, "_update");
      args = {
        uid: this.uid,
        low: this.last_seqno() + 1
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigchain.iced",
            funcname: "SigChain._update"
          });
          req.get({
            endpoint: "sig/get",
            args: args
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return body = arguments[0];
              };
            })(),
            lineno: 82
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.debug("| found " + body.sigs.length + " new signatures");
          new_links = [];
          did_update = false;
          (function(__iced_k) {
            var _i, _len, _ref5, _results, _while;
            _ref5 = body.sigs;
            _len = _ref5.length;
            _i = 0;
            _results = [];
            _while = function(__iced_k) {
              var _break, _continue, _next;
              _break = function() {
                return __iced_k(_results);
              };
              _continue = function() {
                return iced.trampoline(function() {
                  ++_i;
                  return _while(__iced_k);
                });
              };
              _next = function(__iced_next_arg) {
                _results.push(__iced_next_arg);
                return _continue();
              };
              if (!(_i < _len)) {
                return _break();
              } else {
                obj = _ref5[_i];
                link = Link.alloc({
                  obj: obj
                });
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/node-client/src/sigchain.iced",
                    funcname: "SigChain._update"
                  });
                  asyncify(link.verify(), esc(__iced_deferrals.defer({
                    lineno: 88
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  new_links.push(link);
                  return _next(did_update = true);
                });
              }
            };
            _while(__iced_k);
          })(function() {
            _this._links = _this._links.concat(new_links);
            _this._new_links = new_links;
            _this._index_links(new_links);
            log.debug("- sigchain::_update");
            return cb(null, did_update);
          });
        };
      })(this));
    };

    SigChain.prototype.store = function(cb) {
      var err, link, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          var _ref5;
          if ((_ref5 = _this._new_links) != null ? _ref5.length : void 0) {
            log.debug("+ writing dirty signature chain");
            (function(__iced_k) {
              var _i, _len, _ref6, _results, _while;
              _ref6 = _this._new_links;
              _len = _ref6.length;
              _i = 0;
              _results = [];
              _while = function(__iced_k) {
                var _break, _continue, _next;
                _break = function() {
                  return __iced_k(_results);
                };
                _continue = function() {
                  return iced.trampoline(function() {
                    ++_i;
                    return _while(__iced_k);
                  });
                };
                _next = function(__iced_next_arg) {
                  _results.push(__iced_next_arg);
                  return _continue();
                };
                if (!(_i < _len)) {
                  return _break();
                } else {
                  link = _ref6[_i];
                  if (err == null) {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/jacko/node-client/src/sigchain.iced",
                        funcname: "SigChain.store"
                      });
                      link.store(__iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return err = arguments[0];
                          };
                        })(),
                        lineno: 104
                      }));
                      __iced_deferrals._fulfill();
                    })(_next);
                  } else {
                    return _continue();
                  }
                }
              };
              _while(__iced_k);
            })(function() {
              return __iced_k(log.debug("- wrote signature chain"));
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    SigChain.prototype.update = function(remote_seqno, cb) {
      var a, b, did_update, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      did_update = false;
      (function(_this) {
        return (function(__iced_k) {
          if (((a = remote_seqno) == null) || a > (b = _this.last_seqno())) {
            log.debug("| sigchain update: " + a + " vs. " + b);
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/sigchain.iced",
                funcname: "SigChain.update"
              });
              _this._update(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return did_update = arguments[1];
                  };
                })(),
                lineno: 115
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k((remote_seqno != null) && ((a = remote_seqno) !== (b = _this.last_seqno())) ? err = new E.CorruptionError("failed to appropriately update chain: " + a + " != " + b) : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, did_update);
        };
      })(this));
    };

    SigChain.prototype.last = function() {
      var _ref5;
      if ((_ref5 = this._links) != null ? _ref5.length : void 0) {
        return this._links.slice(-1)[0];
      } else {
        return null;
      }
    };

    SigChain.prototype.true_last = function() {
      return this._true_last || this.last();
    };

    SigChain.prototype.is_track_fresh = function(id) {
      var l, _i, _ref5, _ref6;
      _ref5 = this._links;
      for (_i = _ref5.length - 1; _i >= 0; _i += -1) {
        l = _ref5[_i];
        if (l.id === id) {
          return true;
        } else if (!((_ref6 = l.sig_type()) === ST.TRACK || _ref6 === ST.UNTRACK)) {
          return false;
        }
      }
      return false;
    };

    SigChain.prototype._compress = function(_arg) {
      var index, link, opts, out, seq, verified_links, _i, _len;
      verified_links = _arg.verified_links, opts = _arg.opts;
      log.debug("+ compressing signature chain");
      out = new LinkTable();
      index = {};
      seq = {};
      for (_i = 0, _len = verified_links.length; _i < _len; _i++) {
        link = verified_links[_i];
        index[link.sig_id()] = link;
        seq[link.seqno()] = link;
        link.insert_into_table({
          table: out,
          index: index,
          opts: opts
        });
      }
      if (!opts.show_revoked) {
        out.prune(function(obj) {
          return obj.is_revoked();
        });
      }
      log.debug("- signature chain compressed");
      this.table = out;
      this.index = index;
      return this.seq = seq;
    };

    SigChain.prototype.flattened_remote_proofs = function() {
      var _ref5, _ref6;
      return ((_ref5 = this.table) != null ? (_ref6 = _ref5.get(ST.REMOTE_PROOF)) != null ? _ref6.flatten() : void 0 : void 0) || [];
    };

    SigChain.prototype.remote_proofs_to_track_obj = function() {
      var link, links, _i, _len, _results;
      links = this.flattened_remote_proofs();
      _results = [];
      for (_i = 0, _len = links.length; _i < _len; _i++) {
        link = links[_i];
        if (!link.is_revoked()) {
          _results.push(link.remote_proof_to_track_obj());
        }
      }
      return _results;
    };

    SigChain.prototype.merkle_root_to_track_obj = function() {
      var ret;
      if (this._merkle_root != null) {
        ret = {
          hash: this._merkle_root.hash,
          seqno: this._merkle_root.seqno,
          ctime: this._merkle_root.ctime
        };
      } else {
        ret = null;
      }
      return ret;
    };

    SigChain.prototype.get_track_obj = function(uid) {
      var _ref5, _ref6;
      return (_ref5 = this.table) != null ? (_ref6 = _ref5.get_path([ST.TRACK, uid])) != null ? _ref6.to_table_obj() : void 0 : void 0;
    };

    SigChain.prototype.verify_sig = function(_arg, cb) {
      var debug_file, eldest_kid, esc, key, last_lkb_link, link, lkb_chain_link, lkb_sig_chain, merkle_data, opts, parsed_keys, seqnos, sig_blobs, verified_links, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      opts = _arg.opts, key = _arg.key, parsed_keys = _arg.parsed_keys, merkle_data = _arg.merkle_data;
      esc = make_esc(cb, "SigChain::verify_sig");
      this.pubkey = key;
      log.debug("+ " + this.username + ": verifying sig");
      sig_blobs = (function() {
        var _i, _len, _ref5, _results;
        _ref5 = this._links;
        _results = [];
        for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
          link = _ref5[_i];
          _results.push(link.obj);
        }
        return _results;
      }).call(this);
      eldest_kid = merkle_data.eldest_kid;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigchain.iced",
            funcname: "SigChain.verify_sig"
          });
          libkeybase.SigChain.replay({
            sig_blobs: sig_blobs,
            parsed_keys: parsed_keys,
            uid: _this.uid,
            username: _this.username,
            eldest_kid: eldest_kid,
            sig_cache: SigCache,
            log: log.debug
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return lkb_sig_chain = arguments[0];
              };
            })(),
            lineno: 208
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _i, _len, _ref5;
          last_lkb_link = lkb_sig_chain.get_links().slice(-1)[0];
          if (last_lkb_link != null) {
            if (last_lkb_link.sig_id !== merkle_data.sig_id) {
              cb(new Error("Last sig id (" + last_lkb_link.sig_id + ") doesn't match the Merkle tree (" + merkle_data.sig_id + ")"));
              return;
            }
            if (last_lkb_link.seqno !== merkle_data.seqno) {
              cb(new Error("Last seqno (" + last_lkb_link.seqno + ") doesn't match the Merkle tree (" + merkle_data.seqno + ")"));
              return;
            }
          }
          seqnos = {};
          _ref5 = lkb_sig_chain.get_links();
          for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
            lkb_chain_link = _ref5[_i];
            seqnos[lkb_chain_link.seqno] = true;
          }
          verified_links = (function() {
            var _j, _len1, _ref6, _results;
            _ref6 = this._links;
            _results = [];
            for (_j = 0, _len1 = _ref6.length; _j < _len1; _j++) {
              link = _ref6[_j];
              if (seqnos[link.seqno()]) {
                _results.push(link);
              }
            }
            return _results;
          }).call(_this);
          opts = opts || {};
          _this._compress({
            opts: opts,
            verified_links: verified_links
          });
          debug_file = process.env.KEYBASE_DEBUG_UNBOX_COUNT_FILE;
          (function(__iced_k) {
            if (debug_file != null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/sigchain.iced",
                  funcname: "SigChain.verify_sig"
                });
                fs.writeFile(debug_file, "" + libkeybase.debug.unbox_count, __iced_deferrals.defer({
                  lineno: 236
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            log.debug("- " + _this.username + ": verified sig");
            return cb(null, lkb_sig_chain.get_sibkeys({}));
          });
        };
      })(this));
    };

    SigChain.prototype.list_trackees = function() {
      var k, out, tab, v, _ref5, _ref6;
      out = [];
      if ((tab = (_ref5 = this.table) != null ? (_ref6 = _ref5.get(ST.TRACK)) != null ? _ref6.to_dict() : void 0 : void 0)) {
        for (k in tab) {
          v = tab[k];
          out.push(v.payload_json());
        }
      }
      return out;
    };

    SigChain.prototype.list_cryptocurrency_addresses = function(opts) {
      var k, obj, out, tab, v, _ref5, _ref6;
      if (opts == null) {
        opts = {};
      }
      out = null;
      if ((tab = (_ref5 = this.table) != null ? (_ref6 = _ref5.get(ST.CRYPTOCURRENCY)) != null ? _ref6.to_dict() : void 0 : void 0) != null) {
        for (k in tab) {
          v = tab[k];
          if (!((obj = v.to_cryptocurrency(opts)) != null)) {
            continue;
          }
          out || (out = {});
          out[obj.type] = obj.address;
        }
      }
      return out;
    };

    SigChain.prototype.list_remote_proofs = function(opts) {
      var k, obj, out, tab, type, v, _ref5, _ref6;
      if (opts == null) {
        opts = {};
      }
      out = null;
      if ((tab = (_ref5 = this.table) != null ? (_ref6 = _ref5.get(ST.REMOTE_PROOF)) != null ? _ref6.to_dict() : void 0 : void 0) != null) {
        for (type in tab) {
          obj = tab[type];
          type = proofs.proof_type_to_string[parseInt(type)];
          out || (out = {});
          out[type] = obj.is_leaf() ? obj.to_list_display(opts) : (function() {
            var _ref7, _results;
            _ref7 = obj.to_dict();
            _results = [];
            for (k in _ref7) {
              v = _ref7[k];
              _results.push(v.to_list_display(opts));
            }
            return _results;
          })();
        }
      }
      return out;
    };

    SigChain.prototype.display_cryptocurrency_addresses = function(opts, cb) {
      var esc, k, tab, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "SigChain::display_cryptocurrency_addresses");
      (function(_this) {
        return (function(__iced_k) {
          var _ref5, _ref6;
          if ((tab = (_ref5 = _this.table) != null ? (_ref6 = _ref5.get(ST.CRYPTOCURRENCY)) != null ? _ref6.to_dict() : void 0 : void 0) != null) {
            (function(__iced_k) {
              var _i, _k, _keys, _ref7, _results, _while;
              _ref7 = tab;
              _keys = (function() {
                var _results1;
                _results1 = [];
                for (_k in _ref7) {
                  _results1.push(_k);
                }
                return _results1;
              })();
              _i = 0;
              _results = [];
              _while = function(__iced_k) {
                var _break, _continue, _next;
                _break = function() {
                  return __iced_k(_results);
                };
                _continue = function() {
                  return iced.trampoline(function() {
                    ++_i;
                    return _while(__iced_k);
                  });
                };
                _next = function(__iced_next_arg) {
                  _results.push(__iced_next_arg);
                  return _continue();
                };
                if (!(_i < _keys.length)) {
                  return _break();
                } else {
                  k = _keys[_i];
                  v = _ref7[k];
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/sigchain.iced",
                      funcname: "SigChain.display_cryptocurrency_addresses"
                    });
                    v.display_cryptocurrency(opts, esc(__iced_deferrals.defer({
                      lineno: 282
                    })));
                    __iced_deferrals._fulfill();
                  })(_next);
                }
              };
              _while(__iced_k);
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    SigChain.prototype.check_assertions = function(_arg, cb) {
      var assertions, err, gpg_keys, key, proof_set, proof_vec, username, _i, _len;
      gpg_keys = _arg.gpg_keys, username = _arg.username, assertions = _arg.assertions, proof_vec = _arg.proof_vec;
      err = null;
      for (_i = 0, _len = gpg_keys.length; _i < _len; _i++) {
        key = gpg_keys[_i];
        proof_vec.push(new Proof({
          key: "fingerprint",
          value: key.fingerprint().toString('hex')
        }));
      }
      proof_vec.push(new Proof({
        key: "keybase",
        value: username
      }));
      proof_set = new ProofSet(proof_vec);
      if (!assertions.match_set(proof_set)) {
        err = new E.FailedAssertionError("Assertion set failed");
      }
      return cb(err);
    };

    SigChain.prototype.check_remote_proofs = function(_arg, cb) {
      var assertions, esc, gpg_keys, key, link, links, msg, n, proof_vec, skip, tab, type, v, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k, _i, _len;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      skip = _arg.skip, gpg_keys = _arg.gpg_keys, assertions = _arg.assertions;
      esc = make_esc(cb, "SigChain::check_remote_proofs");
      log.debug("+ " + this.username + ": checking remote proofs (skip=" + skip + ")");
      warnings = new Warnings();
      for (_i = 0, _len = gpg_keys.length; _i < _len; _i++) {
        key = gpg_keys[_i];
        msg = CHECK + " " + colors.green("public key fingerprint: " + (format_fingerprint(key.fingerprint().toString('hex'))));
        log.lconsole("error", log["package"]().INFO, msg);
      }
      n = 0;
      proof_vec = [];
      (function(_this) {
        return (function(__iced_k) {
          var _ref5;
          if ((tab = (_ref5 = _this.table) != null ? _ref5.get(ST.REMOTE_PROOF) : void 0) != null) {
            log.debug("| Loaded table with " + (tab.keys().length) + " keys");
            (function(__iced_k) {
              var _j, _k, _keys, _ref6, _results, _while;
              _ref6 = tab.to_dict();
              _keys = (function() {
                var _results1;
                _results1 = [];
                for (_k in _ref6) {
                  _results1.push(_k);
                }
                return _results1;
              })();
              _j = 0;
              _results = [];
              _while = function(__iced_k) {
                var _break, _continue, _next;
                _break = function() {
                  return __iced_k(_results);
                };
                _continue = function() {
                  return iced.trampoline(function() {
                    ++_j;
                    return _while(__iced_k);
                  });
                };
                _next = function(__iced_next_arg) {
                  _results.push(__iced_next_arg);
                  return _continue();
                };
                if (!(_j < _keys.length)) {
                  return _break();
                } else {
                  type = _keys[_j];
                  v = _ref6[type];
                  type = parseInt(type);
                  links = v.flatten();
                  (function(__iced_k) {
                    var _l, _len1, _ref7, _results1, _while;
                    _ref7 = links;
                    _len1 = _ref7.length;
                    _l = 0;
                    _results1 = [];
                    _while = function(__iced_k) {
                      var _break, _continue, _next;
                      _break = function() {
                        return __iced_k(_results1);
                      };
                      _continue = function() {
                        return iced.trampoline(function() {
                          ++_l;
                          return _while(__iced_k);
                        });
                      };
                      _next = function(__iced_next_arg) {
                        _results1.push(__iced_next_arg);
                        return _continue();
                      };
                      if (!(_l < _len1)) {
                        return _break();
                      } else {
                        link = _ref7[_l];
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/home/jacko/node-client/src/sigchain.iced",
                            funcname: "SigChain.check_remote_proofs"
                          });
                          link.check_remote_proof({
                            skip: skip,
                            type: type,
                            warnings: warnings,
                            proof_vec: proof_vec
                          }, esc(__iced_deferrals.defer({
                            lineno: 323
                          })));
                          __iced_deferrals._fulfill();
                        })(function() {
                          return _next(n++);
                        });
                      }
                    };
                    _while(__iced_k);
                  })(_next);
                }
              };
              _while(__iced_k);
            })(__iced_k);
          } else {
            return __iced_k(log.debug("| No remote proofs found"));
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (assertions != null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/sigchain.iced",
                  funcname: "SigChain.check_remote_proofs"
                });
                _this.check_assertions({
                  gpg_keys: gpg_keys,
                  proof_vec: proof_vec,
                  username: _this.username,
                  assertions: assertions
                }, esc(__iced_deferrals.defer({
                  lineno: 329
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            log.debug("- " + _this.username + ": checked remote proofs");
            return cb(null, warnings, n);
          });
        };
      })(this));
    };

    return SigChain;

  })();

  SigCache = (function() {
    function SigCache() {}

    SigCache.get = function(_arg, cb) {
      var esc, payload_buffer, sig_id, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig_id = _arg.sig_id;
      esc = make_esc(cb, "SigCache::get");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigchain.iced",
            funcname: "SigCache.get"
          });
          db.get({
            type: "sig_cache",
            key: sig_id,
            json: false
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return payload_buffer = arguments[0];
              };
            })(),
            lineno: 341
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(null, payload_buffer);
        };
      })(this));
    };

    SigCache.put = function(_arg, cb) {
      var esc, payload_buffer, sig_id, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig_id = _arg.sig_id, payload_buffer = _arg.payload_buffer;
      esc = make_esc(cb, "SigCache::put");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigchain.iced",
            funcname: "SigCache.put"
          });
          db.put({
            type: "sig_cache",
            key: sig_id,
            value: payload_buffer,
            json: false
          }, esc(__iced_deferrals.defer({
            lineno: 346
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    return SigCache;

  })();

}).call(this);
