// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var XPlatformHash, crypto;

  crypto = require('crypto');


  /*
  
    XPlatform hash returns a dict like this:
    {
      hash:     <some_str>
      alt_hash: <some_str>
    }
  
    alt_hash is the hash with '\r\n' replaced with '\n' thoughout a file.
   */

  XPlatformHash = (function() {
    function XPlatformHash(opts) {
      opts = opts || {};
      this.alg = opts.alg || 'sha256';
      this.encoding = opts.encoding || 'hex';
    }

    XPlatformHash.prototype.hash = function(read_stream, cb) {
      var alt_hash, hash;
      hash = crypto.createHash(this.alg);
      alt_hash = crypto.createHash(this.alg);
      hash.setEncoding(this.encoding);
      alt_hash.setEncoding(this.encoding);
      read_stream.on('end', function() {
        hash.end();
        alt_hash.end();
        return cb(null, {
          hash: hash.read(),
          alt_hash: alt_hash.read()
        });
      });
      read_stream.on('error', function(e) {
        return cb(e, null);
      });
      return read_stream.on('data', function(data) {
        hash.update(data);
        return alt_hash.update(new Buffer(data.toString('utf8').replace(/\r/g, ''), 'utf8'));
      });
    };

    XPlatformHash.prototype.hash_str = function(str, cb) {
      var alt_str;
      alt_str = str.replace(/\r/g, '');
      return cb(null, {
        hash: crypto.createHash(this.alg).update(str).digest(this.encoding),
        alt_hash: crypto.createHash(this.alg).update(alt_str).digest(this.encoding)
      });
    };

    return XPlatformHash;

  })();

  module.exports = XPlatformHash;

}).call(this);
