// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var E, GPG, Message, Packet, Parser, iced, parse, strip, util, __iced_k, __iced_k_noop;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  E = require('./err').E;

  GPG = require('./gpg').GPG;

  util = require('util');

  strip = function(x) {
    var m;
    if ((m = x.match(/^\s*(.*)$/))) {
      return m[1];
    } else {
      return x;
    }
  };

  Packet = (function() {
    function Packet(_arg) {
      this.type = _arg.type, this.options = _arg.options;
      this._subfields = [];
    }

    Packet.prototype.add_subfield = function(f) {
      return this._subfields.push(f);
    };

    Packet.prototype.subfields = function() {
      return this._subfields;
    };

    return Packet;

  })();

  Message = (function() {
    function Message(_packets) {
      this._packets = _packets;
    }

    Message.prototype.packets = function() {
      return this._packets;
    };

    return Message;

  })();

  exports.Parser = Parser = (function() {
    function Parser(pgp_output) {
      this.pgp_output = pgp_output;
    }

    Parser.prototype.run = function() {
      this.preprocess();
      return new Message(this.parse_packets());
    };

    Parser.prototype.preprocess = function() {
      var line;
      return this._lines = (function() {
        var _i, _len, _ref, _results;
        _ref = this.pgp_output.split(/\r?\n/);
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          line = _ref[_i];
          if (line.match(/\S/)) {
            _results.push(line);
          }
        }
        return _results;
      }).call(this);
    };

    Parser.prototype.parse_packets = function() {
      var _results;
      _results = [];
      while (!this.eof()) {
        _results.push(this.parse_packet());
      }
      return _results;
    };

    Parser.prototype.peek = function() {
      return this._lines[0];
    };

    Parser.prototype.get = function() {
      return this._lines.shift();
    };

    Parser.prototype.eof = function() {
      return this._lines.length === 0;
    };

    Parser.prototype.parse_packet = function() {
      var first, m, packet, rxx;
      rxx = /^:([a-zA-Z0-9_ -]+) packet:( (.*))?$/;
      first = this.get();
      if (!(m = first.match(rxx))) {
        throw new E.ParseError("expected ':literal data packet:' style header; got " + first);
      }
      packet = new Packet({
        type: m[1],
        options: m[3]
      });
      while (!(this.eof() || this.peek()[0] === ':')) {
        packet.add_subfield(strip(this.get()));
      }
      return packet;
    };

    return Parser;

  })();

  exports.parse = parse = function(_arg, cb) {
    var buf, e, err, gpg, message, out, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    gpg = _arg.gpg, message = _arg.message;
    gpg || (gpg = new GPG);
    out = null;
    (function(_this) {
      return (function(__iced_k) {
        __iced_deferrals = new iced.Deferrals(__iced_k, {
          parent: ___iced_passed_deferral,
          filename: "/Users/max/src/keybase/gpg-wrapper/src/parse.iced"
        });
        gpg.run({
          args: ["--list-packets"],
          stdin: message
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return buf = arguments[1];
            };
          })(),
          lineno: 52
        }));
        __iced_deferrals._fulfill();
      });
    })(this)((function(_this) {
      return function() {
        if (typeof err === "undefined" || err === null) {
          try {
            out = (new Parser(buf.toString('utf8'))).run();
          } catch (_error) {
            e = _error;
            err = e;
          }
        }
        return cb(err, out);
      };
    })(this));
  };

}).call(this);
