/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.ReadRestArgumentNode;
import org.jruby.truffle.nodes.arguments.ReadUserKeywordsHashNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadOptionalArgumentNode
extends RubyNode {
    private final int index;
    private final int minimum;
    private final boolean considerRejectedKWArgs;
    @Node.Child
    private RubyNode defaultValue;
    @Node.Child
    private ReadRestArgumentNode readRestArgumentNode;
    private final boolean reduceMinimumWhenNoKWargs;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    private final BranchProfile defaultValueProfile = BranchProfile.create();

    public ReadOptionalArgumentNode(RubyContext context, SourceSection sourceSection, int index, int minimum, boolean considerRejectedKWArgs, RubyNode defaultValue, ReadRestArgumentNode readRestArgumentNode, int requiredForKWArgs, boolean reduceMinimumWhenNoKWargs) {
        super(context, sourceSection);
        this.index = index;
        this.minimum = minimum;
        this.considerRejectedKWArgs = considerRejectedKWArgs;
        this.defaultValue = defaultValue;
        this.readRestArgumentNode = readRestArgumentNode;
        this.reduceMinimumWhenNoKWargs = reduceMinimumWhenNoKWargs;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(context, sourceSection, requiredForKWArgs);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int actualMinimum = this.minimum;
        if (this.reduceMinimumWhenNoKWargs) {
            CompilerDirectives.transferToInterpreter();
            if (this.readUserKeywordsHashNode.execute(frame) == null) {
                --actualMinimum;
            }
        }
        if (RubyArguments.getArgumentsCount(frame.getArguments()) < actualMinimum) {
            this.defaultValueProfile.enter();
            if (this.considerRejectedKWArgs) {
                CompilerDirectives.transferToInterpreter();
                Object rest = this.readRestArgumentNode.execute(frame);
                if (RubyGuards.isRubyArray(rest) && Layouts.ARRAY.getSize((DynamicObject)rest) > 0) {
                    return this.ruby("rest[0]", "rest", rest);
                }
            }
            return this.defaultValue.execute(frame);
        }
        return RubyArguments.getArgument(frame.getArguments(), this.index);
    }
}

