/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.format.TrivialDateFormat;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorSample;
import de.intarsys.tools.monitor.MonitorStatistic;
import de.intarsys.tools.monitor.MonitorTrace;
import de.intarsys.tools.monitor.TimeMonitorTrace;
import java.text.Format;
import java.util.Iterator;
import java.util.List;

public class TimeMonitor
extends Monitor {
    private static Format DEFAULT_FORMAT = TrivialDateFormat.getInstance();

    public TimeMonitor() {
    }

    public TimeMonitor(String string) {
        super(string);
    }

    @Override
    protected TimeMonitorTrace createMonitorTrace() {
        return new TimeMonitorTrace(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCalculation(MonitorTrace monitorTrace) {
        long l = monitorTrace.getStart();
        long l2 = monitorTrace.getDifference();
        this.doStatistic(this.statistic, l2);
        List list = monitorTrace.getSamples();
        if (list != null) {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                MonitorStatistic monitorStatistic;
                MonitorSample monitorSample = (MonitorSample)iterator.next();
                l2 = monitorSample.getValue() - l;
                l = monitorSample.getValue();
                TimeMonitor timeMonitor = this;
                synchronized (timeMonitor) {
                    monitorStatistic = (MonitorStatistic)this.sampleStatistics.get(monitorSample.getDescription());
                    if (monitorStatistic == null) {
                        monitorStatistic = new MonitorStatistic(monitorSample.getDescription(), n);
                        this.sampleStatistics.put(monitorSample.getDescription(), monitorStatistic);
                    }
                }
                this.doStatistic(monitorStatistic, l2);
                ++n;
            }
        }
    }

    protected void doStatistic(MonitorStatistic monitorStatistic, long l) {
        if (l < monitorStatistic.min) {
            monitorStatistic.min = l;
        }
        if (l > monitorStatistic.max) {
            monitorStatistic.max = l;
        }
        monitorStatistic.total += l;
        ++monitorStatistic.count;
        monitorStatistic.avg = monitorStatistic.total / monitorStatistic.count;
    }

    @Override
    protected Format getFormat() {
        return DEFAULT_FORMAT;
    }
}

