/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTNameRecord;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;

public class TTFontSerializer {
    private TTFont font;
    private int tableOffset = 0;

    public TTFont getFont() {
        return this.font;
    }

    public void write(IRandomAccess iRandomAccess, TTFont tTFont) throws IOException {
        this.font = tTFont;
        this.writeFontHeader(iRandomAccess);
        this.writeTableDirectory(iRandomAccess);
        this.writeTables(iRandomAccess);
    }

    public void write_loca(IRandomAccess iRandomAccess, int[] nArray, boolean bl) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            if (bl) {
                this.writeShort(iRandomAccess, nArray[n] >> 1);
            } else {
                this.writeInt(iRandomAccess, nArray[n]);
            }
            ++n;
        }
    }

    public void write_name(IRandomAccess iRandomAccess, TTNameRecord[] tTNameRecordArray) throws IOException {
        int n = 6 + tTNameRecordArray.length * 12;
        this.writeShort(iRandomAccess, 0);
        this.writeShort(iRandomAccess, tTNameRecordArray.length);
        this.writeShort(iRandomAccess, n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < tTNameRecordArray.length) {
            this.writeShort(iRandomAccess, tTNameRecordArray[n3].getPlatformID());
            this.writeShort(iRandomAccess, tTNameRecordArray[n3].getEncodingID());
            this.writeShort(iRandomAccess, tTNameRecordArray[n3].getLanguageID());
            this.writeShort(iRandomAccess, tTNameRecordArray[n3].getNameID());
            this.writeShort(iRandomAccess, tTNameRecordArray[n3].getLength());
            this.writeShort(iRandomAccess, n2);
            n2 += tTNameRecordArray[n3].getLength();
            ++n3;
        }
        n3 = 0;
        while (n3 < tTNameRecordArray.length) {
            this.writeBytes(iRandomAccess, tTNameRecordArray[n3].getValue().getBytes("UTF-16BE"), 0, tTNameRecordArray[n3].getLength());
            ++n3;
        }
    }

    public void writeByte(IRandomAccess iRandomAccess, int n) throws IOException {
        iRandomAccess.write(n);
    }

    public void writeBytes(IRandomAccess iRandomAccess, byte[] byArray, int n, int n2) throws IOException {
        iRandomAccess.write(byArray, n, n2);
    }

    protected void writeFontHeader(IRandomAccess iRandomAccess) throws IOException {
        int n = this.getFont().getTables().length;
        int n2 = 1;
        int n3 = 0;
        while (n2 <= n) {
            n2 <<= 1;
            ++n3;
        }
        if (n3 > 0) {
            n2 >>= 1;
            --n3;
        }
        this.writeInt(iRandomAccess, 65536);
        this.writeShort(iRandomAccess, n);
        this.writeShort(iRandomAccess, n2 << 4);
        this.writeShort(iRandomAccess, n3);
        this.writeShort(iRandomAccess, n - n2 << 4);
    }

    public void writeInt(IRandomAccess iRandomAccess, int n) throws IOException {
        iRandomAccess.write((int)((byte)(n >> 24)));
        iRandomAccess.write((int)((byte)(n >> 16)));
        iRandomAccess.write((int)((byte)(n >> 8)));
        iRandomAccess.write((int)((byte)n));
    }

    public void writeShort(IRandomAccess iRandomAccess, int n) throws IOException {
        iRandomAccess.write((int)((byte)(n >> 8)));
        iRandomAccess.write((int)((byte)n));
    }

    protected void writeTableDirectory(IRandomAccess iRandomAccess) throws IOException {
        int n = this.getFont().getTables().length;
        this.tableOffset = n * 16 + 12;
        int n2 = 0;
        while (n2 < n) {
            TTTable tTTable = this.getFont().getTables()[n2];
            this.writeTableDirectoryTable(iRandomAccess, tTTable);
            ++n2;
        }
    }

    protected void writeTableDirectoryTable(IRandomAccess iRandomAccess, TTTable tTTable) throws IOException {
        int n = (int)tTTable.getLength();
        this.writeBytes(iRandomAccess, tTTable.getName(), 0, tTTable.getName().length);
        this.writeInt(iRandomAccess, tTTable.getChecksum());
        this.writeInt(iRandomAccess, this.tableOffset);
        this.writeInt(iRandomAccess, n);
        this.tableOffset = this.tableOffset + n + 3 & 0xFFFFFFFC;
    }

    protected void writeTables(IRandomAccess iRandomAccess) throws IOException {
        int n = this.getFont().getTables().length;
        int n2 = 0;
        while (n2 < n) {
            TTTable tTTable = this.getFont().getTables()[n2];
            this.writeTablesTable(iRandomAccess, tTTable);
            ++n2;
        }
    }

    protected void writeTablesTable(IRandomAccess iRandomAccess, TTTable tTTable) throws IOException {
        IRandomAccess iRandomAccess2 = tTTable.getRandomAccess();
        try {
            iRandomAccess2.seek(0L);
            int n = (int)tTTable.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.writeByte(iRandomAccess, iRandomAccess2.read());
                ++n2;
            }
            n2 = n;
            while (n2 < (n + 3 & 0xFFFFFFFC)) {
                this.writeByte(iRandomAccess, 0);
                ++n2;
            }
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess2);
        }
    }
}

