/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Signature;
import esmska.data.event.ValuedEventSupport;
import esmska.data.event.ValuedListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class Signatures {
    private static Signatures instance;
    private TreeMap<String, Signature> signatures = new TreeMap();
    private LinkedHashMap<String, Signature> special = new LinkedHashMap();
    private ValuedEventSupport<Events, Signature> valuedSupport = new ValuedEventSupport(this);

    public void addValuedListener(ValuedListener<Events, Signature> valuedListener) {
        this.valuedSupport.addValuedListener(valuedListener);
    }

    public void removeValuedListener(ValuedListener<Events, Signature> valuedListener) {
        this.valuedSupport.removeValuedListener(valuedListener);
    }

    private Signatures() {
        this.special.put(Signature.DEFAULT.getProfileName(), Signature.DEFAULT);
        this.special.put(Signature.NONE.getProfileName(), Signature.NONE);
    }

    public static Signatures getInstance() {
        if (instance == null) {
            instance = new Signatures();
        }
        return instance;
    }

    public Signature get(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        if (this.signatures.containsKey(name)) {
            return this.signatures.get(name);
        }
        if (this.special.containsKey(name)) {
            return this.special.get(name);
        }
        return null;
    }

    public boolean add(Signature signature) {
        Validate.notNull(signature);
        if (this.exists(signature.getProfileName())) {
            return false;
        }
        Signature previous = this.signatures.put(signature.getProfileName(), signature);
        assert (previous == null) : "Signature overwritten, shouldn't have happened";
        this.valuedSupport.fireEventOccured(Events.UPDATED, null);
        return true;
    }

    public void remove(String name) {
        Validate.notEmpty(name);
        this.signatures.remove(name);
        this.valuedSupport.fireEventOccured(Events.UPDATED, null);
    }

    public boolean exists(String name) {
        return this.signatures.containsKey(name) || this.special.containsKey(name);
    }

    public Collection<Signature> getAll() {
        return Collections.unmodifiableCollection(this.signatures.values());
    }

    public Collection<Signature> getSpecial() {
        return Collections.unmodifiableCollection(this.special.values());
    }

    public static enum Events {
        UPDATED;

    }
}

