/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;

public class ReadInstanceVariableNode
extends RubyNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ReadHeadObjectFieldNode readNode;
    private final ConditionProfile objectProfile = ConditionProfile.createBinaryProfile();

    public ReadInstanceVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver) {
        super(context, sourceSection);
        this.receiver = receiver;
        this.readNode = ReadHeadObjectFieldNodeGen.create(name, this.nil());
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (this.objectProfile.profile(receiverObject instanceof DynamicObject)) {
            return this.readNode.execute((DynamicObject)receiverObject);
        }
        return this.nil();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof DynamicObject) {
            DynamicObject receiverRubyObject = (DynamicObject)receiverObject;
            if (receiverRubyObject.getShape().hasProperty(this.readNode.getName())) {
                return this.create7BitString(StringOperations.encodeByteList("instance-variable", (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.nil();
        }
        return false;
    }
}

