/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.util;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class FileUtils {
    public static byte[] readAllBytesInterruptedly(RubyContext context, String file) {
        final Path path = Paths.get(file, new String[0]);
        return context.getThreadManager().runUntilResult(null, new ThreadManager.BlockingAction<byte[]>(){

            @Override
            public byte[] block() throws InterruptedException {
                try {
                    return Files.readAllBytes(path);
                }
                catch (ClosedByInterruptException e) {
                    throw new InterruptedException();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

