/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.lib.profiler.global.Platform;

final class JavaInfo {
    private static String CP_JAR;

    public static void main(String[] args) {
        for (String arg : args) {
            System.out.println(System.getProperty(arg));
        }
    }

    static String getCurrentJDKExecutable() {
        return JavaInfo.getJDKExecutable(System.getProperty("java.home"));
    }

    static String getJDKExecutable(String jdkHome) {
        if (jdkHome == null || jdkHome.trim().length() == 0) {
            return null;
        }
        String jreSuffix = File.separator + "jre";
        if (jdkHome.endsWith(jreSuffix)) {
            jdkHome = jdkHome.substring(0, jdkHome.length() - jreSuffix.length());
        }
        String jdkExe = jdkHome + File.separator + "bin" + File.separator + "java" + (Platform.isWindows() ? ".exe" : "");
        return jdkExe;
    }

    static String[] getSystemProperties(File java, String ... keys) {
        if (keys.length == 0) {
            return new String[0];
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(java.getAbsolutePath());
            list.add("-cp");
            list.add(JavaInfo.getCPJar());
            list.add(JavaInfo.class.getName());
            list.addAll(Arrays.asList(keys));
            Process p = Runtime.getRuntime().exec(list.toArray(new String[list.size()]));
            list.clear();
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                list.add(line);
                line = br.readLine();
            }
            br.close();
            return list.toArray(new String[list.size()]);
        }
        catch (Throwable t) {
            System.err.println("Error getting system properties from " + java.toString() + ": " + t.getMessage());
            t.printStackTrace(System.err);
            return null;
        }
    }

    private static synchronized String getCPJar() throws MalformedURLException, URISyntaxException {
        if (CP_JAR == null) {
            String name = JavaInfo.class.getSimpleName() + ".class";
            URL url = JavaInfo.class.getResource(name);
            String path = url.getFile();
            String jar = path.substring(0, path.indexOf("!/"));
            URI uri = new URL(jar).toURI();
            CP_JAR = new File(uri).getAbsolutePath();
        }
        return CP_JAR;
    }

    private JavaInfo() {
    }
}

