/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jcmdline.Parameter;
import jcmdline.StringFormatHelper;
import jcmdline.Strings;
import jcmdline.UsageFormatter;

public class TextUsageFormatter
implements UsageFormatter {
    private int lineLength = 80;
    private StringFormatHelper sHelper = StringFormatHelper.getHelper();

    public String formatUsage(String cmdName, String cmdDesc, Map opts, List args, boolean showHidden) {
        int maxExpectedStringLen = 2048;
        StringBuffer sb = new StringBuffer(maxExpectedStringLen);
        String s = this.sHelper.formatHangingIndent(cmdName + " - " + cmdDesc, cmdName.length() + 3, this.lineLength);
        sb.append(s + "\n\n");
        int lineStartIdx = sb.length();
        sb.append(Strings.get("TextUsageFormatter.usage")).append(" ").append(cmdName).append(" ");
        if (opts.size() > 0) {
            sb.append(this.haveRequiredOpt(opts) ? Strings.get("TextUsageFormatter.usageWReqOpt") : Strings.get("TextUsageFormatter.usageWOReqOpt")).append(" ");
        }
        if (args.size() > 0) {
            StringBuffer sb2 = this.argsOnOneLine(args, showHidden);
            if (sb.length() - lineStartIdx + sb2.length() > this.lineLength) {
                sb2 = this.argsOnSeparateLines(args, sb.length() - lineStartIdx, showHidden);
            }
            sb.append(sb2.toString()).append("\n").append(this.getArgDescriptions(args, showHidden));
        }
        if (opts.size() > 0) {
            sb.append("\n\n");
            if (args.size() > 0) {
                sb.append(Strings.get("TextUsageFormatter.optIntroWArgs"));
            } else {
                sb.append(Strings.get("TextUsageFormatter.optIntroNoArgs"));
            }
            sb.append("\n\n").append(this.getOptDescriptions(opts, showHidden));
            sb.append("\n\n").append(this.sHelper.formatHangingIndent(Strings.get("TextUsageFormatter.stdOptionHelp"), 0, this.lineLength));
        }
        return sb.toString();
    }

    public String formatErrorMsg(String msg) {
        String error = Strings.get("TextUsageFormatter.errorPrefix");
        return this.sHelper.formatHangingIndent(error + " " + msg, error.length() + 1, this.lineLength);
    }

    public String formatText(String text, int indent, int lineLen) {
        return this.sHelper.formatBlockedText(text, indent, lineLen);
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    private boolean haveRequiredOpt(Map options) {
        boolean haveRequiredOpt = false;
        Iterator itr = options.values().iterator();
        while (itr.hasNext()) {
            if (((Parameter)itr.next()).isOptional()) continue;
            haveRequiredOpt = true;
            break;
        }
        return haveRequiredOpt;
    }

    private StringBuffer argsOnSeparateLines(List args, int indent, boolean showHidden) {
        int maxExpectedStringLen = 240;
        StringBuffer sb2 = new StringBuffer(maxExpectedStringLen);
        int optIdx = 0;
        sb2 = new StringBuffer(maxExpectedStringLen);
        Iterator itr = args.iterator();
        while (itr.hasNext()) {
            Parameter p = (Parameter)itr.next();
            if (p.isHidden() && !showHidden) continue;
            for (int i = 0; i < optIdx; ++i) {
                sb2.append(' ');
            }
            sb2.append(this.argTagToString(p)).append(" \\\n");
            optIdx = indent;
        }
        return sb2.delete(sb2.length() - 3, sb2.length());
    }

    private StringBuffer argsOnOneLine(List args, boolean showHidden) {
        int maxExpectedStringLen = 800;
        StringBuffer sb2 = new StringBuffer(maxExpectedStringLen);
        Iterator itr = args.iterator();
        while (itr.hasNext()) {
            Parameter p = (Parameter)itr.next();
            if (p.isHidden() && !showHidden) continue;
            sb2.append(this.argTagToString(p)).append(" ");
        }
        if (sb2.length() > 0) {
            sb2.deleteCharAt(sb2.length() - 1);
        }
        return sb2;
    }

    private String argTagToString(Parameter p) {
        int maxExpectedStringLen = 50;
        StringBuffer sb2 = new StringBuffer(maxExpectedStringLen);
        String argstr = p.isOptional() ? "[" + p.getTag() + "]" : p.getTag();
        sb2.append(argstr);
        if (p.isMultiValued()) {
            sb2.append("," + argstr + "...");
        }
        return sb2.toString();
    }

    private String getArgDescriptions(List args, boolean showHidden) {
        StringBuffer sb = new StringBuffer(1024);
        if (args.size() == 0) {
            return "";
        }
        sb.append("\n").append(Strings.get("TextUsageFormatter.where")).append("\n\n");
        ArrayList<String> tags = new ArrayList<String>(args.size());
        ArrayList<String> desc = new ArrayList<String>(args.size());
        Iterator itr = args.iterator();
        while (itr.hasNext()) {
            Parameter p = (Parameter)itr.next();
            if (p.isHidden() && !showHidden) continue;
            tags.add(p.getTag());
            desc.add(p.getDesc() + " (" + (p.isOptional() ? Strings.get("TextUsageFormatter.optional") : Strings.get("TextUsageFormatter.required")) + ")" + (p.isHidden() ? " (" + Strings.get("TextUsageFormatter.hidden") + ")" : ""));
        }
        sb.append(this.sHelper.formatLabeledList(tags.toArray(new String[tags.size()]), desc.toArray(new String[desc.size()]), " = ", 20, this.lineLength));
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private String getOptDescriptions(Map options, boolean showHidden) {
        if (options.size() == 0) {
            return "";
        }
        ArrayList sortedOptions = new ArrayList(options.keySet());
        Collections.sort(sortedOptions);
        ArrayList<String> labels = new ArrayList<String>(options.size());
        ArrayList<String> desc = new ArrayList<String>(options.size());
        Iterator itr = sortedOptions.iterator();
        while (itr.hasNext()) {
            Parameter p = (Parameter)options.get(itr.next());
            if (p.isHidden() && !showHidden) continue;
            labels.add("-" + p.getTag() + " " + p.getOptionLabel());
            desc.add(p.getDesc() + " (" + (p.isOptional() ? Strings.get("TextUsageFormatter.optional") : Strings.get("TextUsageFormatter.required")) + ")" + (p.isHidden() ? " (" + Strings.get("TextUsageFormatter.hidden") + ")" : ""));
        }
        StringBuffer sb = new StringBuffer(this.sHelper.formatLabeledList(labels.toArray(new String[labels.size()]), desc.toArray(new String[desc.size()]), " ", 20, this.lineLength));
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

