/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

class Util {
    private static final int TEMP_BUF_POOL_SIZE = IOUtil.IOV_MAX;
    private static ThreadLocal<BufferCache> bufferCache = new ThreadLocal<BufferCache>(){

        @Override
        protected BufferCache initialValue() {
            return new BufferCache();
        }
    };
    private static ThreadLocal<SoftReference<SelectorWrapper>> localSelector = new ThreadLocal();
    private static ThreadLocal<SelectorWrapper> localSelectorWrapper = new ThreadLocal();
    private static Unsafe unsafe = Unsafe.getUnsafe();
    private static int pageSize = -1;
    private static volatile Constructor directByteBufferConstructor = null;
    private static volatile Constructor directByteBufferRConstructor = null;
    private static volatile String bugLevel = null;
    private static boolean loaded = false;

    Util() {
    }

    static ByteBuffer getTemporaryDirectBuffer(int size) {
        BufferCache cache = bufferCache.get();
        ByteBuffer buf = cache.get(size);
        if (buf != null) {
            return buf;
        }
        if (!cache.isEmpty()) {
            buf = cache.removeFirst();
            Util.free(buf);
        }
        return ByteBuffer.allocateDirect(size);
    }

    static void releaseTemporaryDirectBuffer(ByteBuffer buf) {
        Util.offerFirstTemporaryDirectBuffer(buf);
    }

    static void offerFirstTemporaryDirectBuffer(ByteBuffer buf) {
        assert (buf != null);
        BufferCache cache = bufferCache.get();
        if (!cache.offerFirst(buf)) {
            Util.free(buf);
        }
    }

    static void offerLastTemporaryDirectBuffer(ByteBuffer buf) {
        assert (buf != null);
        BufferCache cache = bufferCache.get();
        if (!cache.offerLast(buf)) {
            Util.free(buf);
        }
    }

    private static void free(ByteBuffer buf) {
        ((DirectBuffer)((Object)buf)).cleaner().clean();
    }

    static Selector getTemporarySelector(SelectableChannel sc) throws IOException {
        SoftReference<SelectorWrapper> ref = localSelector.get();
        SelectorWrapper selWrapper = null;
        Selector sel = null;
        if (ref == null || (selWrapper = ref.get()) == null || (sel = selWrapper.get()) == null || sel.provider() != sc.provider()) {
            sel = sc.provider().openSelector();
            selWrapper = new SelectorWrapper(sel);
            localSelector.set(new SoftReference<SelectorWrapper>(selWrapper));
        }
        localSelectorWrapper.set(selWrapper);
        return sel;
    }

    static void releaseTemporarySelector(Selector sel) throws IOException {
        sel.selectNow();
        assert (sel.keys().isEmpty()) : "Temporary selector not empty";
        localSelectorWrapper.set(null);
    }

    static ByteBuffer[] subsequence(ByteBuffer[] bs, int offset, int length) {
        if (offset == 0 && length == bs.length) {
            return bs;
        }
        int n = length;
        ByteBuffer[] bs2 = new ByteBuffer[n];
        for (int i = 0; i < n; ++i) {
            bs2[i] = bs[offset + i];
        }
        return bs2;
    }

    static <E> Set<E> ungrowableSet(final Set<E> s) {
        return new Set<E>(){

            @Override
            public int size() {
                return s.size();
            }

            @Override
            public boolean isEmpty() {
                return s.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return s.contains(o);
            }

            @Override
            public Object[] toArray() {
                return s.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return s.toArray(a);
            }

            public String toString() {
                return s.toString();
            }

            @Override
            public Iterator<E> iterator() {
                return s.iterator();
            }

            @Override
            public boolean equals(Object o) {
                return s.equals(o);
            }

            @Override
            public int hashCode() {
                return s.hashCode();
            }

            @Override
            public void clear() {
                s.clear();
            }

            @Override
            public boolean remove(Object o) {
                return s.remove(o);
            }

            @Override
            public boolean containsAll(Collection<?> coll) {
                return s.containsAll(coll);
            }

            @Override
            public boolean removeAll(Collection<?> coll) {
                return s.removeAll(coll);
            }

            @Override
            public boolean retainAll(Collection<?> coll) {
                return s.retainAll(coll);
            }

            @Override
            public boolean add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> coll) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static byte _get(long a) {
        return unsafe.getByte(a);
    }

    private static void _put(long a, byte b) {
        unsafe.putByte(a, b);
    }

    static void erase(ByteBuffer bb) {
        unsafe.setMemory(((DirectBuffer)((Object)bb)).address(), bb.capacity(), (byte)0);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Class<?> cl = Class.forName("java.nio.DirectByteBuffer");
                    Constructor<?> ctor = cl.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
                    ctor.setAccessible(true);
                    directByteBufferConstructor = ctor;
                }
                catch (ClassNotFoundException x) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException x) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException x) {
                    throw new InternalError();
                }
                catch (ClassCastException x) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int size, long addr, FileDescriptor fd, Runnable unmapper) {
        MappedByteBuffer dbb;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            dbb = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Integer(size), new Long(addr), fd, unmapper);
        }
        catch (InstantiationException e) {
            throw new InternalError();
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
        catch (InvocationTargetException e) {
            throw new InternalError();
        }
        return dbb;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Class<?> cl = Class.forName("java.nio.DirectByteBufferR");
                    Constructor<?> ctor = cl.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
                    ctor.setAccessible(true);
                    directByteBufferRConstructor = ctor;
                }
                catch (ClassNotFoundException x) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException x) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException x) {
                    throw new InternalError();
                }
                catch (ClassCastException x) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int size, long addr, FileDescriptor fd, Runnable unmapper) {
        MappedByteBuffer dbb;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            dbb = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Integer(size), new Long(addr), fd, unmapper);
        }
        catch (InstantiationException e) {
            throw new InternalError();
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
        catch (InvocationTargetException e) {
            throw new InternalError();
        }
        return dbb;
    }

    static boolean atBugLevel(String bl) {
        if (bugLevel == null) {
            if (!VM.isBooted()) {
                return false;
            }
            String value = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.bugLevel"));
            bugLevel = value != null ? value : "";
        }
        return bugLevel.equals(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            if (loaded) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            loaded = true;
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            AccessController.doPrivileged(new LoadLibraryAction("nio"));
            IOUtil.initIDs();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class SelectorWrapper {
        private Selector sel;

        private SelectorWrapper(Selector sel) {
            this.sel = sel;
            Cleaner.create(this, new Closer(sel));
        }

        public Selector get() {
            return this.sel;
        }

        private static class Closer
        implements Runnable {
            private Selector sel;

            private Closer(Selector sel) {
                this.sel = sel;
            }

            @Override
            public void run() {
                try {
                    this.sel.close();
                }
                catch (Throwable th) {
                    throw new Error(th);
                }
            }
        }
    }

    private static class BufferCache {
        private ByteBuffer[] buffers = new ByteBuffer[Util.access$000()];
        private int count;
        private int start;

        private int next(int i) {
            return (i + 1) % TEMP_BUF_POOL_SIZE;
        }

        BufferCache() {
        }

        ByteBuffer get(int size) {
            if (this.count == 0) {
                return null;
            }
            ByteBuffer[] buffers = this.buffers;
            ByteBuffer buf = buffers[this.start];
            if (buf.capacity() < size) {
                ByteBuffer bb;
                buf = null;
                int i = this.start;
                while ((i = this.next(i)) != this.start && (bb = buffers[i]) != null) {
                    if (bb.capacity() < size) continue;
                    buf = bb;
                    break;
                }
                if (buf == null) {
                    return null;
                }
                buffers[i] = buffers[this.start];
            }
            buffers[this.start] = null;
            this.start = this.next(this.start);
            --this.count;
            buf.rewind();
            buf.limit(size);
            return buf;
        }

        boolean offerFirst(ByteBuffer buf) {
            if (this.count >= TEMP_BUF_POOL_SIZE) {
                return false;
            }
            this.start = (this.start + TEMP_BUF_POOL_SIZE - 1) % TEMP_BUF_POOL_SIZE;
            this.buffers[this.start] = buf;
            ++this.count;
            return true;
        }

        boolean offerLast(ByteBuffer buf) {
            if (this.count >= TEMP_BUF_POOL_SIZE) {
                return false;
            }
            int next = (this.start + this.count) % TEMP_BUF_POOL_SIZE;
            this.buffers[next] = buf;
            ++this.count;
            return true;
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        ByteBuffer removeFirst() {
            assert (this.count > 0);
            ByteBuffer buf = this.buffers[this.start];
            this.buffers[this.start] = null;
            this.start = this.next(this.start);
            --this.count;
            return buf;
        }
    }
}

