/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.net.SocketPermission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.NamingManager;
import sun.misc.SharedSecrets;
import sun.security.krb5.internal.Krb5;

class KrbServiceLocator {
    private static final String SRV_RR = "SRV";
    private static final String[] SRV_RR_ATTR = new String[]{"SRV"};
    private static final String SRV_TXT = "TXT";
    private static final String[] SRV_TXT_ATTR = new String[]{"TXT"};
    private static final Random random = new Random();
    private static final boolean DEBUG = Krb5.DEBUG;

    private KrbServiceLocator() {
    }

    static String[] getKerberosService(String realmName) {
        final String dnsUrl = "dns:///_kerberos." + realmName;
        String[] records = null;
        try {
            Attribute attr;
            final Context ctx = NamingManager.getURLContext("dns", new Hashtable(0));
            if (!(ctx instanceof DirContext)) {
                return null;
            }
            Attributes attrs = null;
            try {
                attrs = SharedSecrets.getJavaSecurityAccess().doPrivileged(new PrivilegedExceptionAction<Attributes>(){

                    @Override
                    public Attributes run() throws Exception {
                        return ((DirContext)ctx).getAttributes(dnsUrl, SRV_TXT_ATTR);
                    }
                }, null, new SocketPermission("*", "connect,accept"));
            }
            catch (PrivilegedActionException e) {
                throw (NamingException)e.getCause();
            }
            if (attrs != null && (attr = attrs.get(SRV_TXT)) != null) {
                int numValues = attr.size();
                int numRecords = 0;
                String[] txtRecords = new String[numValues];
                int j = 0;
                for (int i = 0; i < numValues; ++i) {
                    try {
                        txtRecords[j] = (String)attr.get(i);
                        ++j;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                numRecords = j;
                if (numRecords < numValues) {
                    String[] trimmed = new String[numRecords];
                    System.arraycopy(txtRecords, 0, trimmed, 0, numRecords);
                    records = trimmed;
                } else {
                    records = txtRecords;
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return records;
    }

    static String[] getKerberosService(String realmName, String protocol) {
        final String dnsUrl = "dns:///_kerberos." + protocol + "." + realmName;
        String[] hostports = null;
        try {
            Attribute attr;
            final Context ctx = NamingManager.getURLContext("dns", new Hashtable(0));
            if (!(ctx instanceof DirContext)) {
                return null;
            }
            Attributes attrs = null;
            try {
                attrs = SharedSecrets.getJavaSecurityAccess().doPrivileged(new PrivilegedExceptionAction<Attributes>(){

                    @Override
                    public Attributes run() throws Exception {
                        return ((DirContext)ctx).getAttributes(dnsUrl, SRV_RR_ATTR);
                    }
                }, null, new SocketPermission("*", "connect,accept"));
            }
            catch (PrivilegedActionException e) {
                throw (NamingException)e.getCause();
            }
            if (attrs != null && (attr = attrs.get(SRV_RR)) != null) {
                int numValues = attr.size();
                int numRecords = 0;
                Object[] srvRecords = new SrvRecord[numValues];
                int j = 0;
                for (int i = 0; i < numValues; ++i) {
                    try {
                        srvRecords[j] = new SrvRecord((String)attr.get(i));
                        ++j;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                numRecords = j;
                if (numRecords < numValues) {
                    SrvRecord[] trimmed = new SrvRecord[numRecords];
                    System.arraycopy(srvRecords, 0, trimmed, 0, numRecords);
                    srvRecords = trimmed;
                }
                if (numRecords > 1) {
                    Arrays.sort(srvRecords);
                }
                hostports = KrbServiceLocator.extractHostports((SrvRecord[])srvRecords);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return hostports;
    }

    private static String[] extractHostports(SrvRecord[] srvRecords) {
        String[] hostports = null;
        int head = 0;
        int tail = 0;
        int sublistLength = 0;
        int k = 0;
        for (int i = 0; i < srvRecords.length; ++i) {
            if (hostports == null) {
                hostports = new String[srvRecords.length];
            }
            head = i;
            while (i < srvRecords.length - 1 && srvRecords[i].priority == srvRecords[i + 1].priority) {
                ++i;
            }
            tail = i;
            sublistLength = tail - head + 1;
            for (int j = 0; j < sublistLength; ++j) {
                hostports[k++] = KrbServiceLocator.selectHostport(srvRecords, head, tail);
            }
        }
        return hostports;
    }

    private static String selectHostport(SrvRecord[] srvRecords, int head, int tail) {
        if (head == tail) {
            return srvRecords[head].hostport;
        }
        int sum = 0;
        for (int i = head; i <= tail; ++i) {
            if (srvRecords[i] == null) continue;
            srvRecords[i].sum = sum += srvRecords[i].weight;
        }
        String hostport = null;
        int target = sum == 0 ? 0 : random.nextInt(sum + 1);
        for (int i = head; i <= tail; ++i) {
            if (srvRecords[i] == null || srvRecords[i].sum < target) continue;
            hostport = srvRecords[i].hostport;
            srvRecords[i] = null;
            break;
        }
        return hostport;
    }

    static class SrvRecord
    implements Comparable {
        int priority;
        int weight;
        int sum;
        String hostport;

        SrvRecord(String srvRecord) throws Exception {
            StringTokenizer tokenizer = new StringTokenizer(srvRecord, " ");
            if (tokenizer.countTokens() != 4) {
                throw new IllegalArgumentException();
            }
            this.priority = Integer.parseInt(tokenizer.nextToken());
            this.weight = Integer.parseInt(tokenizer.nextToken());
            String port = tokenizer.nextToken();
            this.hostport = tokenizer.nextToken() + ":" + port;
        }

        public int compareTo(Object o) {
            SrvRecord that = (SrvRecord)o;
            if (this.priority > that.priority) {
                return 1;
            }
            if (this.priority < that.priority) {
                return -1;
            }
            if (this.weight == 0 && that.weight != 0) {
                return -1;
            }
            if (this.weight != 0 && that.weight == 0) {
                return 1;
            }
            return 0;
        }
    }
}

