/*
 * Decompiled with CFR 0.152.
 */
package sun.security.smartcardio;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.util.Debug;

class PlatformPCSC {
    static final Debug debug = Debug.getInstance("pcsc");
    static final Throwable initException = AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

        @Override
        public Throwable run() {
            try {
                System.loadLibrary("j2pcsc");
                String library = PlatformPCSC.getLibraryName();
                if (debug != null) {
                    debug.println("Using PC/SC library: " + library);
                }
                PlatformPCSC.initialize(library);
                return null;
            }
            catch (Throwable e) {
                return e;
            }
        }
    });
    private static final String PROP_NAME = "sun.security.smartcardio.library";
    private static final String LIB1 = "/usr/$LIBISA/libpcsclite.so.1";
    private static final String LIB2 = "/usr/local/$LIBISA/libpcsclite.so.1";
    private static final String LIB3 = "/usr/lib/$ARCH-linux-gnu/libpcsclite.so.1";
    private static final String LIB4 = "/usr/lib/arm-linux-gnueabi/libpcsclite.so.1";
    private static final String LIB5 = "/usr/lib/arm-linux-gnueabihf/libpcsclite.so.1";
    private static final String LIB6 = "/usr/lib/$ARCH-kfreebsd-gnu/libpcsclite.so.1";
    private static final String PCSC_FRAMEWORK = "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC";
    static final int SCARD_PROTOCOL_T0 = 1;
    static final int SCARD_PROTOCOL_T1 = 2;
    static final int SCARD_PROTOCOL_RAW = 4;
    static final int SCARD_UNKNOWN = 1;
    static final int SCARD_ABSENT = 2;
    static final int SCARD_PRESENT = 4;
    static final int SCARD_SWALLOWED = 8;
    static final int SCARD_POWERED = 16;
    static final int SCARD_NEGOTIABLE = 32;
    static final int SCARD_SPECIFIC = 64;

    PlatformPCSC() {
    }

    private static String expand(String lib) {
        int k = lib.indexOf("$LIBISA");
        if (k != -1) {
            String libDir = "64".equals(System.getProperty("sun.arch.data.model")) ? ("SunOS".equals(System.getProperty("os.name")) ? "lib/64" : "lib64") : "lib";
            lib = PlatformPCSC.replace(k, lib, "$LIBISA", libDir);
        }
        if ((k = lib.indexOf("$ARCH")) != -1) {
            String arch;
            switch (arch = System.getProperty("os.arch")) {
                case "amd64": {
                    arch = "x86_64";
                    break;
                }
                case "ppc": {
                    arch = "powerpc";
                    break;
                }
                case "ppc64": {
                    arch = "powerpc64";
                    break;
                }
                case "ppc64le": {
                    arch = "powerpc64le";
                }
            }
            lib = PlatformPCSC.replace(k, lib, "$ARCH", arch);
        }
        return lib;
    }

    private static String replace(int k, String text, String template, String replacement) {
        String s1 = text.substring(0, k);
        String s2 = text.substring(k + template.length());
        return s1 + replacement + s2;
    }

    private static String getLibraryName() throws IOException {
        String lib = PlatformPCSC.expand(System.getProperty(PROP_NAME, "").trim());
        if (lib.length() != 0) {
            return lib;
        }
        lib = PlatformPCSC.expand(LIB1);
        if (new File(lib).isFile()) {
            return lib;
        }
        lib = PlatformPCSC.expand(LIB2);
        if (new File(lib).isFile()) {
            return lib;
        }
        lib = PlatformPCSC.expand(LIB3);
        if (new File(lib).isFile()) {
            return lib;
        }
        lib = LIB4;
        if (new File(lib).isFile()) {
            return lib;
        }
        lib = LIB5;
        if (new File(lib).isFile()) {
            return lib;
        }
        lib = PlatformPCSC.expand(LIB6);
        if (new File(lib).isFile()) {
            return lib;
        }
        lib = PCSC_FRAMEWORK;
        if (new File(lib).isFile()) {
            return lib;
        }
        throw new IOException("No PC/SC library found on this system");
    }

    private static native void initialize(String var0);
}

