/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.Http11Nio2Processor;
import org.apache.coyote.http11.upgrade.Nio2Processor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Nio2Protocol
extends AbstractHttp11JsseProtocol<Nio2Channel> {
    private static final Log log = LogFactory.getLog(Http11Nio2Protocol.class);
    private final Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11Nio2Protocol() {
        this.endpoint = new Nio2Endpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((Nio2Endpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public Nio2Endpoint getEndpoint() {
        return (Nio2Endpoint)this.endpoint;
    }

    public void setAcceptorThreadPriority(int threadPriority) {
        ((Nio2Endpoint)this.endpoint).setAcceptorThreadPriority(threadPriority);
    }

    public void setPollerThreadPriority(int threadPriority) {
        ((Nio2Endpoint)this.endpoint).setPollerThreadPriority(threadPriority);
    }

    public int getAcceptorThreadPriority() {
        return ((Nio2Endpoint)this.endpoint).getAcceptorThreadPriority();
    }

    public int getPollerThreadPriority() {
        return ((Nio2Endpoint)this.endpoint).getThreadPriority();
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        ((Nio2Endpoint)this.endpoint).setUseSendfile(useSendfile);
    }

    public void setOomParachute(int oomParachute) {
        ((Nio2Endpoint)this.endpoint).setOomParachute(oomParachute);
    }

    @Override
    protected String getNamePrefix() {
        return "http-nio2";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<Nio2Channel, Http11Nio2Processor>
    implements Nio2Endpoint.Handler {
        protected Http11Nio2Protocol proto;

        Http11ConnectionHandler(Http11Nio2Protocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol<Nio2Channel> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void release(SocketWrapper<Nio2Channel> socket) {
            Processor processor = (Processor)this.connections.remove(socket.getSocket());
            if (processor != null) {
                processor.recycle(true);
                this.recycledProcessors.push(processor);
            }
        }

        @Override
        public void release(SocketWrapper<Nio2Channel> socket, Processor<Nio2Channel> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.push(processor);
            if (socket.isAsync()) {
                ((Nio2Endpoint)this.proto.endpoint).removeTimeout(socket);
            }
            if (addToPoller) {
                ((Nio2Endpoint)this.proto.endpoint).awaitBytes(socket);
            }
        }

        @Override
        protected void initSsl(SocketWrapper<Nio2Channel> socket, Processor<Nio2Channel> processor) {
            if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null && socket.getSocket() instanceof SecureNio2Channel) {
                SecureNio2Channel ch = (SecureNio2Channel)socket.getSocket();
                processor.setSslSupport(this.proto.sslImplementation.getSSLSupport(ch.getSslEngine().getSession()));
            } else {
                processor.setSslSupport(null);
            }
        }

        @Override
        protected void longPoll(SocketWrapper<Nio2Channel> socket, Processor<Nio2Channel> processor) {
            if (processor.isAsync()) {
                socket.setAsync(true);
                ((Nio2Endpoint)this.proto.endpoint).addTimeout(socket);
            } else if (processor.isUpgrade() && ((Nio2Endpoint.Nio2SocketWrapper)socket).isUpgradeInit()) {
                try {
                    ((Nio2Endpoint)this.proto.endpoint).awaitBytes(socket);
                }
                catch (ReadPendingException readPendingException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Http11Nio2Processor createProcessor() {
            Http11Nio2Processor processor = new Http11Nio2Processor(this.proto.getMaxHttpHeaderSize(), (Nio2Endpoint)this.proto.endpoint, this.proto.getMaxTrailerSize(), this.proto.getAllowedTrailerHeadersAsSet(), this.proto.getMaxExtensionSize(), this.proto.getMaxSwallowSize());
            this.proto.configureProcessor(processor);
            this.register(processor);
            return processor;
        }

        @Override
        protected Processor<Nio2Channel> createUpgradeProcessor(SocketWrapper<Nio2Channel> socket, ByteBuffer leftoverInput, UpgradeToken upgradeToken) throws IOException {
            return new Nio2Processor(this.proto.endpoint, socket, leftoverInput, upgradeToken, this.proto.getUpgradeAsyncWriteBufferSize());
        }

        @Override
        public void closeAll() {
            for (Nio2Channel channel : this.connections.keySet()) {
                ((Nio2Endpoint)this.proto.endpoint).closeSocket(channel.getSocket(), SocketStatus.STOP);
            }
        }
    }
}

