/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.admin;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.admin.CacheElementInfo;
import org.apache.commons.jcs.admin.CacheRegionInfo;
import org.apache.commons.jcs.admin.CountingOnlyOutputStream;
import org.apache.commons.jcs.admin.JCSJMXBean;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.CacheElementSerialized;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;

public class JCSAdminBean
implements JCSJMXBean {
    private final CompositeCacheManager cacheHub;

    public JCSAdminBean() {
        try {
            this.cacheHub = CompositeCacheManager.getInstance();
        }
        catch (CacheException cacheException) {
            throw new RuntimeException("Could not retrieve cache manager instance", cacheException);
        }
    }

    public JCSAdminBean(CompositeCacheManager compositeCacheManager) {
        this.cacheHub = compositeCacheManager;
    }

    @Override
    public CacheElementInfo[] buildElementInfo(String string) throws Exception {
        CompositeCache compositeCache = this.cacheHub.getCache(string);
        Object[] objectArray = compositeCache.getMemoryCache().getKeySet().toArray(new Serializable[0]);
        try {
            Arrays.sort(objectArray);
        }
        catch (Exception exception) {
            objectArray = compositeCache.getMemoryCache().getKeySet().toArray(new Serializable[0]);
        }
        LinkedList<CacheElementInfo> linkedList = new LinkedList<CacheElementInfo>();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        long l = System.currentTimeMillis();
        for (Object object : objectArray) {
            ICacheElement iCacheElement = compositeCache.getMemoryCache().getQuiet(object);
            IElementAttributes iElementAttributes = iCacheElement.getElementAttributes();
            CacheElementInfo cacheElementInfo = new CacheElementInfo(String.valueOf(object), iElementAttributes.getIsEternal(), dateFormat.format(new Date(iElementAttributes.getCreateTime())), iElementAttributes.getMaxLife(), (l - iElementAttributes.getCreateTime() - iElementAttributes.getMaxLife() * 1000L) / -1000L);
            linkedList.add(cacheElementInfo);
        }
        return linkedList.toArray(new CacheElementInfo[0]);
    }

    @Override
    public CacheRegionInfo[] buildCacheInfo() throws Exception {
        Object[] objectArray = this.cacheHub.getCacheNames();
        Arrays.sort(objectArray);
        LinkedList<CacheRegionInfo> linkedList = new LinkedList<CacheRegionInfo>();
        for (int i = 0; i < objectArray.length; ++i) {
            CompositeCache compositeCache = this.cacheHub.getCache((String)objectArray[i]);
            CacheRegionInfo cacheRegionInfo = new CacheRegionInfo(compositeCache.getCacheName(), compositeCache.getSize(), compositeCache.getStatus().toString(), compositeCache.getStats(), compositeCache.getHitCountRam(), compositeCache.getHitCountAux(), compositeCache.getMissCountNotFound(), compositeCache.getMissCountExpired(), this.getByteCount(compositeCache));
            linkedList.add(cacheRegionInfo);
        }
        return linkedList.toArray(new CacheRegionInfo[0]);
    }

    @Override
    public int getByteCount(String string) {
        return this.getByteCount(this.cacheHub.getCache(string));
    }

    public <K, V> int getByteCount(CompositeCache<K, V> compositeCache) {
        if (compositeCache == null) {
            throw new IllegalArgumentException("The cache object specified was null.");
        }
        long l = 0L;
        IMemoryCache<K, V> iMemoryCache = compositeCache.getMemoryCache();
        for (K k : iMemoryCache.getKeySet()) {
            ICacheElement<K, V> iCacheElement = null;
            try {
                iCacheElement = iMemoryCache.get(k);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException while trying to get a cached element", iOException);
            }
            if (iCacheElement == null) continue;
            if (iCacheElement instanceof CacheElementSerialized) {
                l += (long)((CacheElementSerialized)iCacheElement).getSerializedValue().length;
                continue;
            }
            V v = iCacheElement.getVal();
            CountingOnlyOutputStream countingOnlyOutputStream = new CountingOnlyOutputStream();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(countingOnlyOutputStream);
                objectOutputStream.writeObject(v);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException while trying to measure the size of the cached element", iOException);
            }
            finally {
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    countingOnlyOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            l = l + (long)countingOnlyOutputStream.getCount() - 4L;
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException("The size of cache " + compositeCache.getCacheName() + " (" + l + " bytes) is too large to be represented as an integer.");
        }
        return (int)l;
    }

    @Override
    public void clearAllRegions() throws IOException {
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            String[] stringArray = this.cacheHub.getCacheNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.cacheHub.getCache(stringArray[i]).removeAll();
            }
        } else {
            try {
                String[] stringArray = this.cacheHub.getCacheNames();
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    remoteCacheServer.removeAll(string);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Failed to remove all elements from all cache regions: " + iOException, iOException);
            }
        }
    }

    @Override
    public void clearRegion(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("The cache name specified was null.");
        }
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            this.cacheHub.getCache(string).removeAll();
        } else {
            try {
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                remoteCacheServer.removeAll(string);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Failed to remove all elements from cache region [" + string + "]: " + iOException, iOException);
            }
        }
    }

    @Override
    public void removeItem(String string, String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("The cache name specified was null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The key specified was null.");
        }
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            this.cacheHub.getCache(string).remove(string2);
        } else {
            try {
                Object var3_3 = null;
                CompositeCache compositeCache = CompositeCacheManager.getInstance().getCache(string);
                Set set = compositeCache.getMemoryCache().getKeySet();
                for (Object k : set) {
                    if (!k.toString().equals(string2)) continue;
                    if (var3_3 == null) {
                        var3_3 = k;
                        continue;
                    }
                    throw new IllegalStateException("Unexpectedly found duplicate keys in the cache region matching the key specified.");
                }
                if (var3_3 == null) {
                    throw new IllegalStateException("No match for this key could be found in the set of keys retrieved from the memory cache.");
                }
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                remoteCacheServer.remove(string, string2);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to remove element with key [" + string2 + ", " + string2.getClass() + "] from cache region [" + string + "]: " + exception, exception);
            }
        }
    }
}

