/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.date.PrimaryDateParser;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class WayPoint
extends WithAttributes
implements Comparable<WayPoint>,
TemplateEngineDataProvider {
    private static ThreadLocal<PrimaryDateParser> dateParser = new ThreadLocal<PrimaryDateParser>(){

        @Override
        protected PrimaryDateParser initialValue() {
            return new PrimaryDateParser();
        }
    };
    public double time;
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    private final double lat;
    private final double lon;
    private double east = Double.NaN;
    private double north = Double.NaN;

    public WayPoint(WayPoint wayPoint) {
        this.attr.putAll(wayPoint.attr);
        this.lat = wayPoint.lat;
        this.lon = wayPoint.lon;
        this.east = wayPoint.east;
        this.north = wayPoint.north;
        this.time = wayPoint.time;
        this.customColoring = wayPoint.customColoring;
        this.drawLine = wayPoint.drawLine;
        this.dir = wayPoint.dir;
    }

    public WayPoint(LatLon latLon) {
        this.lat = latLon.lat();
        this.lon = latLon.lon();
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }

    public final LatLon getCoor() {
        return new LatLon(this.lat, this.lon);
    }

    public final EastNorth getEastNorth() {
        if (Double.isNaN(this.east) || Double.isNaN(this.north)) {
            EastNorth eastNorth = Projections.project(new LatLon(this.lat, this.lon));
            this.east = eastNorth.east();
            this.north = eastNorth.north();
        }
        return new EastNorth(this.east, this.north);
    }

    public String toString() {
        return "WayPoint (" + (this.attr.containsKey("name") ? this.get("name") + ", " : "") + this.getCoor() + ", " + this.attr + ')';
    }

    public void setTime() {
        if (this.attr.containsKey("time")) {
            try {
                this.time = (double)dateParser.get().parse(this.get("time").toString()).getTime() / 1000.0;
            }
            catch (Exception exception) {
                this.time = 0.0;
            }
        }
    }

    @Override
    public int compareTo(WayPoint wayPoint) {
        return Double.compare(this.time, wayPoint.time);
    }

    public Date getTime() {
        return new Date((long)(this.time * 1000.0));
    }

    @Override
    public Object getTemplateValue(String string, boolean bl) {
        if (!bl) {
            return this.get(string);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match match) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTemplateKeys() {
        return new ArrayList<String>(this.attr.keySet());
    }
}

