/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.widgets.MultiSplitLayout;
import org.openstreetmap.josm.gui.widgets.MultiSplitPane;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Destroyable;

public class DialogsPanel
extends JPanel
implements Destroyable {
    protected List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    protected MultiSplitPane mSpltPane = new MultiSplitPane();
    protected static final int DIVIDER_SIZE = 5;
    private final List<JPanel> panels = new ArrayList<JPanel>();
    private final JSplitPane parent;
    public boolean initialized;

    public DialogsPanel(JSplitPane jSplitPane) {
        this.parent = jSplitPane;
    }

    public void initialize(List<ToggleDialog> list) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.initialized = true;
        this.allDialogs = new ArrayList<ToggleDialog>();
        for (ToggleDialog toggleDialog : list) {
            this.add(toggleDialog, false);
        }
        this.add(this.mSpltPane);
        this.reconstruct(Action.ELEMENT_SHRINKS, null);
    }

    public void add(ToggleDialog toggleDialog) {
        this.add(toggleDialog, true);
    }

    public void add(ToggleDialog toggleDialog, boolean bl) {
        this.allDialogs.add(toggleDialog);
        int n = this.allDialogs.size() - 1;
        toggleDialog.setDialogsPanel(this);
        toggleDialog.setVisible(false);
        JPanel jPanel = new JPanel(){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 40);
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setVisible(false);
        this.mSpltPane.add((Component)jPanel, "L" + n);
        this.panels.add(jPanel);
        if (toggleDialog.isDialogShowing()) {
            toggleDialog.showDialog();
            if (toggleDialog.isDialogInCollapsedView()) {
                toggleDialog.isCollapsed = false;
                toggleDialog.collapse();
            }
            if (bl) {
                this.reconstruct(Action.INVISIBLE_TO_DEFAULT, toggleDialog);
            }
            toggleDialog.showNotify();
        } else {
            toggleDialog.hideDialog();
        }
    }

    public void reconstruct(Action action, ToggleDialog toggleDialog) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.allDialogs.size();
        for (JPanel jPanel : this.panels) {
            jPanel.removeAll();
            jPanel.setVisible(false);
        }
        Object object = this.panels.get(n5 - 1);
        int n6 = -1;
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            ToggleDialog toggleDialog2 = this.allDialogs.get(n4);
            if (toggleDialog2.isDialogInDefaultView()) {
                if (n6 == -1) {
                    n6 = n5 - 1;
                } else {
                    object = this.panels.get(--n6);
                }
                ((Container)object).add((Component)toggleDialog2, 0);
                ((JComponent)object).setVisible(true);
                continue;
            }
            if (!toggleDialog2.isDialogInCollapsedView()) continue;
            ((Container)object).add((Component)toggleDialog2, 0);
            ((JComponent)object).setVisible(true);
        }
        if (n6 == -1) {
            n6 = n5 - 1;
        }
        n4 = n5 - n6;
        if (action == Action.ELEMENT_SHRINKS) {
            for (n3 = 0; n3 < n5; ++n3) {
                ToggleDialog toggleDialog3 = this.allDialogs.get(n3);
                if (!toggleDialog3.isDialogInDefaultView()) continue;
                n2 = toggleDialog3.getPreferredHeight();
                n = toggleDialog3.getSize().height;
                toggleDialog3.setPreferredSize(new Dimension(Integer.MAX_VALUE, n < 20 ? n2 : n));
            }
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            ToggleDialog toggleDialog4;
            int n11;
            CheckParameterUtil.ensureParameterNotNull(toggleDialog, "triggeredBy");
            n3 = 0;
            int n12 = 0;
            n2 = 0;
            for (ToggleDialog toggleDialog5 : this.allDialogs) {
                if (toggleDialog5.isDialogInDefaultView()) {
                    if (toggleDialog5 == toggleDialog) continue;
                    n3 += toggleDialog5.getPreferredHeight();
                    n12 += toggleDialog5.getHeight();
                    continue;
                }
                if (!toggleDialog5.isDialogInCollapsedView()) continue;
                n2 += toggleDialog5.getHeight();
            }
            if (n12 == 0) {
                this.reconstruct(Action.ELEMENT_SHRINKS, null);
                return;
            }
            n = this.mSpltPane.getMultiSplitLayout().getModel().getBounds().getSize().height;
            int n13 = n - (n4 - 1) * 5 - n2;
            int n14 = toggleDialog.getPreferredHeight();
            if (n14 <= 0) {
                throw new IllegalStateException();
            }
            int n15 = n14 * n13 / (n14 + n3);
            toggleDialog.setPreferredSize(new Dimension(Integer.MAX_VALUE, n15));
            int n16 = n13 - n15;
            int n17 = 0;
            int n18 = 0;
            for (n11 = 0; n11 < n5; ++n11) {
                toggleDialog4 = this.allDialogs.get(n11);
                if (!toggleDialog4.isDialogInDefaultView() || toggleDialog4 == toggleDialog) continue;
                n10 = toggleDialog4.getSize().height;
                n9 = n10 * n16 / n12;
                n8 = toggleDialog4.getPreferredHeight() * n13 / (n3 + n14);
                if (n9 < n8) {
                    n7 = Math.min(n10, n8);
                    n17 += n7 - n9;
                    continue;
                }
                n18 += n9 - n8;
            }
            for (n11 = 0; n11 < n5; ++n11) {
                toggleDialog4 = this.allDialogs.get(n11);
                if (!toggleDialog4.isDialogInDefaultView() || toggleDialog4 == toggleDialog) continue;
                n10 = toggleDialog4.getHeight();
                n9 = n10 * n16 / n12;
                if (n9 < (n8 = toggleDialog4.getPreferredHeight() * n13 / (n3 + n14))) {
                    n7 = Math.min(n10, n8);
                    toggleDialog4.setPreferredSize(new Dimension(Integer.MAX_VALUE, n7));
                    continue;
                }
                try {
                    n7 = (n9 - n8) * n17 / n18;
                }
                catch (ArithmeticException arithmeticException) {
                    n7 = 0;
                }
                toggleDialog4.setPreferredSize(new Dimension(Integer.MAX_VALUE, n9 - n7));
            }
        }
        ArrayList<MultiSplitLayout.Node> arrayList = new ArrayList<MultiSplitLayout.Node>();
        for (int i = n6; i <= n5 - 1; ++i) {
            if (i != n6) {
                arrayList.add(new MultiSplitLayout.Divider());
            }
            MultiSplitLayout.Leaf leaf = new MultiSplitLayout.Leaf("L" + i);
            leaf.setWeight(1.0 / (double)n4);
            arrayList.add(leaf);
        }
        if (n4 == 1) {
            MultiSplitLayout.Node node = (MultiSplitLayout.Node)arrayList.get(0);
            this.mSpltPane.getMultiSplitLayout().setModel(node);
        } else {
            MultiSplitLayout.Split split = new MultiSplitLayout.Split();
            split.setRowLayout(false);
            split.setChildren(arrayList);
            this.mSpltPane.getMultiSplitLayout().setModel(split);
        }
        this.mSpltPane.getMultiSplitLayout().setDividerSize(5);
        this.mSpltPane.getMultiSplitLayout().setFloatingDividers(true);
        this.mSpltPane.revalidate();
        if (n4 == 1 && this.panels.get(n5 - 1).getComponents().length == 0) {
            this.parent.setDividerSize(0);
            this.setVisible(false);
        } else {
            if (this.getWidth() != 0) {
                this.setPreferredSize(new Dimension(this.getWidth(), 0));
            }
            this.setVisible(true);
            this.parent.setDividerSize(5);
            this.parent.resetToPreferredSizes();
        }
    }

    @Override
    public void destroy() {
        for (ToggleDialog toggleDialog : this.allDialogs) {
            toggleDialog.destroy();
        }
    }

    public <T> T getToggleDialog(Class<T> clazz) {
        for (ToggleDialog toggleDialog : this.allDialogs) {
            if (!clazz.isInstance(toggleDialog)) continue;
            return clazz.cast(toggleDialog);
        }
        return null;
    }

    public static enum Action {
        INVISIBLE_TO_DEFAULT,
        COLLAPSED_TO_DEFAULT,
        ELEMENT_SHRINKS;

    }
}

