/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class LanguagePreference
implements SubPreferenceSetting {
    private JosmComboBox<Locale> langCombo;

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        LanguageComboBoxModel languageComboBoxModel = new LanguageComboBoxModel();
        languageComboBoxModel.selectLanguage(Main.pref.get("language"));
        this.langCombo = new JosmComboBox<Locale>(languageComboBoxModel);
        this.langCombo.setRenderer(new LanguageCellRenderer());
        LafPreference lafPreference = preferenceTabbedPane.getSetting(LafPreference.class);
        JPanel jPanel = lafPreference.panel;
        jPanel.add((Component)new JLabel(I18n.tr("Language", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add(this.langCombo, GBC.eol().fill(2));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        TabPreferenceSetting tabPreferenceSetting = lafPreference.getTabPreferenceSetting(preferenceTabbedPane);
        tabPreferenceSetting.registerSubTab(this, tabPreferenceSetting.getSubTab(lafPreference));
    }

    @Override
    public boolean ok() {
        if (this.langCombo.getSelectedItem() == null) {
            return Main.pref.put("language", null);
        }
        return Main.pref.put("language", LanguageInfo.getJOSMLocaleCode((Locale)this.langCombo.getSelectedItem()));
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getSetting(LafPreference.class).getTabPreferenceSetting(preferenceTabbedPane);
    }

    private static class LanguageCellRenderer
    implements ListCellRenderer<Locale> {
        private final DefaultListCellRenderer dispatch = new DefaultListCellRenderer();

        LanguageCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Locale> jList, Locale locale, int n, boolean bl, boolean bl2) {
            return this.dispatch.getListCellRendererComponent(jList, locale == null ? I18n.tr("Default (Auto determined)", new Object[0]) : LanguageInfo.getDisplayName(locale), n, bl, bl2);
        }
    }

    private static class LanguageComboBoxModel
    extends DefaultComboBoxModel<Locale> {
        private final List<Locale> data = new ArrayList<Locale>();

        LanguageComboBoxModel() {
            this.data.add(0, null);
            this.data.addAll(Arrays.asList(I18n.getAvailableTranslations()));
        }

        public void selectLanguage(String string) {
            this.setSelectedItem(null);
            if (string != null) {
                string = LanguageInfo.getJavaLocaleCode(string);
                for (Locale locale : this.data) {
                    if (locale == null || !locale.toString().equals(string)) continue;
                    this.setSelectedItem(locale);
                    return;
                }
            }
        }

        @Override
        public Locale getElementAt(int n) {
            return this.data.get(n);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new LanguagePreference();
        }
    }
}

