"use strict";

var _interopRequireDefault = require("babel-runtime/helpers/interop-require-default")["default"];

exports.__esModule = true;

var _module2 = require("module");

var _module3 = _interopRequireDefault(_module2);

var relativeModules = {};

exports["default"] = function (loc /*: string*/) /*: ?string*/ {
  var relative /*: string*/ = arguments.length <= 1 || arguments[1] === undefined ? process.cwd() : arguments[1];

  // we're in the browser, probably
  if (typeof _module3["default"] === "object") return null;

  var relativeMod = relativeModules[relative];

  if (!relativeMod) {
    relativeMod = new _module3["default"]();
    relativeMod.paths = _module3["default"]._nodeModulePaths(relative);
    relativeModules[relative] = relativeMod;
  }

  try {
    return _module3["default"]._resolveFilename(loc, relativeMod);
  } catch (err) {
    return null;
  }
};

module.exports = exports["default"];