/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.text.CSCharacterParser;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class CSTextExtractor
extends CSCharacterParser {
    private StringBuilder content;
    private double maxDX = 5.0;
    private double maxDY = 5.0;

    private void append(char c) {
        if (c > '\u0000') {
            this.content.append(c);
        } else {
            this.content.append(' ');
        }
    }

    private void append(char[] cArray) {
        this.content.append(cArray);
    }

    private void append(String string) {
        this.content.append(string);
    }

    public String getContent() {
        return this.content.toString();
    }

    @Override
    protected void onCharacterFound(PDGlyphs pDGlyphs, Rectangle2D rectangle2D) {
        char[] cArray = pDGlyphs.getChars();
        if (cArray == null) {
            cArray = new char[]{' '};
        }
        double d = this.lastStopX - this.lastStartX;
        double d2 = this.lastStopY - this.lastStartY;
        if (Math.abs(d) < this.maxDX) {
            if (Math.abs(d2) > this.maxDY && this.content.length() > 0) {
                this.append(System.getProperty("line.separator"));
            }
        } else if (this.content.length() > 0) {
            if (Math.abs(d2) < this.maxDY) {
                this.append(" ");
            } else {
                this.append(System.getProperty("line.separator"));
            }
        }
        this.append(cArray);
    }

    @Override
    public void open(ICSInterpreter iCSInterpreter) {
        super.open(iCSInterpreter);
        this.content = new StringBuilder();
    }

    @Override
    public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
        super.textSetFont(cOSName, pDFont, f);
        AffineTransform affineTransform = (AffineTransform)this.getDeviceTransform().clone();
        affineTransform.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * affineTransform.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * affineTransform.getScaleY();
    }

    @Override
    public void textSetTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        super.textSetTransform(f, f2, f3, f4, f5, f6);
        AffineTransform affineTransform = (AffineTransform)this.getDeviceTransform().clone();
        affineTransform.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * affineTransform.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * affineTransform.getScaleY();
    }
}

