/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSDocumentListener;
import de.intarsys.pdf.cos.ICOSExceptionHandler;
import de.intarsys.pdf.cos.ICOSMonitor;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.st.STDocType;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class COSDocument
implements ICOSContainer,
ICOSExceptionHandler,
IAttributeSupport,
ILocatorSupport {
    public static final Object SLOT_ALL = new Attribute("_all_");
    public static final Object SLOT_DIRTY = new Attribute("dirty");
    public static final Object SLOT_LOCATOR = new Attribute("locator");
    public static final Object SLOT_TRAILER = new Attribute("trailer");
    private List<ICOSDocumentListener> documentListeners;
    private ICOSExceptionHandler exceptionHandler;
    private INotificationListener listenSTChange = new INotificationListener(){

        public void handleEvent(Event event) {
            COSDocument.this.onStDocumentChange((AttributeChangedEvent)event);
        }
    };
    private List<ICOSMonitor> monitors;
    private STDocument stDoc;

    public static COSDocument createFromLocator(ILocator iLocator) throws IOException, COSLoadException {
        return COSDocument.createFromLocator(iLocator, null);
    }

    public static COSDocument createFromLocator(ILocator iLocator, Map map) throws IOException, COSLoadException {
        STDocument sTDocument = STDocument.createFromLocator(iLocator, map);
        try {
            return COSDocument.createFromST(sTDocument);
        }
        catch (COSLoadException cOSLoadException) {
            if (sTDocument != null) {
                try {
                    sTDocument.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw cOSLoadException;
        }
    }

    public static COSDocument createFromST(STDocument sTDocument) throws COSLoadException {
        COSDocument cOSDocument = new COSDocument(sTDocument);
        cOSDocument.initializeFromST();
        cOSDocument.checkConsistency();
        return cOSDocument;
    }

    public static COSDocument createNew() {
        return COSDocument.createNew(STDocument.DOCTYPE_PDF);
    }

    public static COSDocument createNew(STDocType sTDocType) {
        STDocument sTDocument = STDocument.createNew(sTDocType);
        COSDocument cOSDocument = new COSDocument(sTDocument);
        cOSDocument.initializeFromScratch();
        return cOSDocument;
    }

    protected COSDocument() {
        this(STDocument.createNew());
    }

    protected COSDocument(STDocument sTDocument) {
        this.stDoc = sTDocument;
        this.stDoc.setDoc(this);
        this.stDoc.addNotificationListener(AttributeChangedEvent.ID, this.listenSTChange);
    }

    public void add(COSDocumentElement cOSDocumentElement) {
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        cOSDocumentElement2.addContainer(this);
    }

    public void addDocumentListener(ICOSDocumentListener iCOSDocumentListener) {
        ArrayList<ICOSDocumentListener> arrayList = this.documentListeners == null ? new ArrayList<ICOSDocumentListener>() : new ArrayList<ICOSDocumentListener>(this.documentListeners);
        arrayList.add(iCOSDocumentListener);
        this.documentListeners = arrayList;
    }

    public void addMonitor(ICOSMonitor iCOSMonitor) {
        ArrayList<ICOSMonitor> arrayList = this.monitors == null ? new ArrayList<ICOSMonitor>() : new ArrayList<ICOSMonitor>(this.monitors);
        arrayList.add(iCOSMonitor);
        this.monitors = arrayList;
    }

    @Override
    public ICOSContainer associate(ICOSContainer iCOSContainer, COSObject cOSObject) {
        if (iCOSContainer == this) {
            return this;
        }
        throw new IllegalStateException("object may only be contained once (use indirect object)");
    }

    protected void checkConsistency() throws COSLoadError {
        if (this.getCatalog() == null) {
            throw new COSLoadError("Catalog missing");
        }
    }

    public void close() throws IOException {
        this.stDoc.close();
    }

    @Override
    public COSDocumentElement containable(COSObject cOSObject) {
        return cOSObject;
    }

    public COSDocument copyDeep() {
        try {
            return COSDocument.createFromST(this.stGetDoc().copyDeep());
        }
        catch (COSLoadException cOSLoadException) {
            throw new COSRuntimeException(cOSLoadException);
        }
    }

    @Override
    public ICOSContainer disassociate(ICOSContainer iCOSContainer, COSObject cOSObject) {
        if (iCOSContainer == this) {
            cOSObject.basicSetContainer(COSObject.NULL_CONTAINER);
            return COSObject.NULL_CONTAINER;
        }
        throw new IllegalStateException("association inconsistent");
    }

    public IAccessPermissions getAccessPermissions() {
        return this.stGetDoc().getAccessPermissions();
    }

    public synchronized Object getAttribute(Object object) {
        return this.stDoc.getAttribute(object);
    }

    public COSCatalog getCatalog() {
        return this.getTrailer().getRoot();
    }

    @Override
    public COSDocument getDoc() {
        return this;
    }

    public ICOSExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public int getIncrementalCount() {
        return this.stGetDoc().getIncrementalCount();
    }

    public COSInfoDict getInfoDict() {
        return this.getTrailer().getInfoDict();
    }

    public ILocator getLocator() {
        return this.stDoc.getLocator();
    }

    public String getName() {
        return this.stDoc.getName();
    }

    public COSTrailer getTrailer() {
        return this.stGetDoc().getTrailer();
    }

    public EnumWriteMode getWriteModeHint() {
        return this.stDoc.getWriteModeHint();
    }

    @Override
    public void handleException(COSRuntimeException cOSRuntimeException) throws COSRuntimeException {
        if (this.exceptionHandler == null) {
            throw cOSRuntimeException;
        }
        this.exceptionHandler.handleException(cOSRuntimeException);
    }

    @Override
    public void harden(COSObject cOSObject) {
    }

    protected void initializeFromScratch() {
    }

    protected void initializeFromST() {
    }

    public boolean isDirty() {
        return this.stGetDoc().isDirty();
    }

    public boolean isEncrypted() {
        return this.stGetDoc().isEncrypted();
    }

    public boolean isNew() {
        return this.stDoc.isNew();
    }

    public boolean isReadOnly() {
        return this.stDoc.isReadOnly();
    }

    public Iterator<COSObject> objects() {
        Iterator iterator = new Iterator(){
            private Iterator indirectObjects;
            COSIndirectObject io;
            {
                this.indirectObjects = COSDocument.this.stGetDoc().objects();
                this.io = null;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.io == null) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    var1_1 = (COSIndirectObject)this.indirectObjects.next();
                    if (var1_1.dereference().isDangling()) continue;
                    this.io = var1_1;
                    break;
lbl7:
                    // 2 sources

                    ** while (this.indirectObjects.hasNext())
                }
lbl8:
                // 2 sources

                return this.io != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                COSIndirectObject cOSIndirectObject = this.io;
                this.io = null;
                return cOSIndirectObject.dereference();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iterator;
    }

    protected void onStDocumentChange(AttributeChangedEvent attributeChangedEvent) {
        if ("xRefSection".equals(attributeChangedEvent.getAttribute())) {
            STXRefSection sTXRefSection = (STXRefSection)attributeChangedEvent.getOldValue();
            STXRefSection sTXRefSection2 = (STXRefSection)attributeChangedEvent.getNewValue();
            COSDictionary cOSDictionary = sTXRefSection == null ? null : sTXRefSection.cosGetDict();
            COSDictionary cOSDictionary2 = sTXRefSection2 == null ? null : sTXRefSection2.cosGetDict();
            this.triggerChanged(SLOT_TRAILER, cOSDictionary, cOSDictionary2);
        }
    }

    @Override
    public int referenceCount() {
        return 1;
    }

    @Override
    public COSIndirectObject referenceIndirect(COSObject cOSObject) {
        throw new IllegalStateException("document can not have indirect references");
    }

    @Override
    public void register(COSDocumentElement cOSDocumentElement) {
        cOSDocumentElement.registerWith(this);
    }

    public synchronized Object removeAttribute(Object object) {
        return this.stDoc.removeAttribute(object);
    }

    public void removeDocumentListener(ICOSDocumentListener iCOSDocumentListener) {
        if (this.documentListeners == null) {
            return;
        }
        ArrayList<ICOSDocumentListener> arrayList = new ArrayList<ICOSDocumentListener>(this.documentListeners);
        arrayList.remove(iCOSDocumentListener);
        this.documentListeners = arrayList;
    }

    public void removeMonitor(ICOSMonitor iCOSMonitor) {
        if (this.monitors == null) {
            return;
        }
        ArrayList<ICOSMonitor> arrayList = new ArrayList<ICOSMonitor>(this.monitors);
        arrayList.remove(iCOSMonitor);
        this.monitors = arrayList;
    }

    public void restore(ILocator iLocator) throws IOException, COSLoadException {
        this.stDoc.restore(iLocator);
    }

    @Override
    public ICOSContainer restoreStateContainer(ICOSContainer iCOSContainer) {
        return iCOSContainer;
    }

    public void save() throws IOException {
        this.save(this.getLocator(), null);
    }

    public void save(ILocator iLocator) throws IOException {
        this.save(iLocator, null);
    }

    public void save(ILocator iLocator, Map map) throws IOException {
        ILocator iLocator2 = this.getLocator();
        this.stDoc.save(iLocator, map);
        this.triggerChangedLocator(iLocator2, iLocator);
    }

    @Override
    public ICOSContainer saveStateContainer() {
        return this;
    }

    public synchronized Object setAttribute(Object object, Object object2) {
        return this.stDoc.setAttribute(object, object2);
    }

    public void setCatalog(COSCatalog cOSCatalog) {
        this.getTrailer().setRoot(cOSCatalog);
    }

    protected void setDirty(boolean bl) {
        boolean bl2 = this.stGetDoc().isDirty();
        this.stGetDoc().setDirty(bl);
        if (bl2 != bl) {
            this.triggerChangedDirty();
        }
    }

    public void setExceptionHandler(ICOSExceptionHandler iCOSExceptionHandler) {
        this.exceptionHandler = iCOSExceptionHandler;
    }

    public void setInfoDict(COSInfoDict cOSInfoDict) {
        this.getTrailer().setInfoDict(cOSInfoDict);
    }

    public void setName(String string) {
        this.stDoc.setName(string);
        this.triggerChangedLocator(this.getLocator(), this.getLocator());
    }

    public void setWriteModeHint(EnumWriteMode enumWriteMode) {
        this.stDoc.setWriteModeHint(enumWriteMode);
    }

    @Override
    public void soften(COSObject cOSObject) {
    }

    public STDocument stGetDoc() {
        return this.stDoc;
    }

    protected void triggerChanged(Object object, Object object2, Object object3) {
        if (this.documentListeners == null) {
            return;
        }
        for (ICOSDocumentListener iCOSDocumentListener : this.documentListeners) {
            iCOSDocumentListener.changed(this, object, object2, object3);
        }
    }

    public void triggerChangedAll() {
        this.triggerChanged(SLOT_ALL, null, null);
    }

    protected void triggerChangedDirty() {
        Boolean bl = this.isDirty();
        Boolean bl2 = !this.isDirty();
        this.triggerChanged(SLOT_DIRTY, bl2, bl);
    }

    protected void triggerChangedLocator(Object object, Object object2) {
        this.triggerChanged(SLOT_LOCATOR, object, object2);
    }

    @Override
    public void willChange(COSObject cOSObject) {
        this.setDirty(true);
        if (this.monitors == null) {
            return;
        }
        for (ICOSMonitor iCOSMonitor : this.monitors) {
            iCOSMonitor.willChange(cOSObject);
        }
    }
}

