/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.CMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IdentityCMap
extends CMap {
    public static final COSName CN_Identity_H = COSName.constant("Identity-H");
    public static final COSName CN_Identity_V = COSName.constant("Identity-V");
    public static IdentityCMap SINGLETON = new IdentityCMap();

    public static CMap getSingleton(COSName cOSName) {
        if (cOSName.equals(CN_Identity_H)) {
            return SINGLETON;
        }
        if (cOSName.equals(CN_Identity_V)) {
            return SINGLETON;
        }
        return null;
    }

    protected IdentityCMap() {
        super(null);
    }

    @Override
    public char[] getChars(int n) {
        int n2 = this.getDecoded(n);
        if (n2 == -1) {
            return null;
        }
        return new char[]{(char)n2};
    }

    @Override
    public int getDecoded(int n) {
        return n;
    }

    @Override
    public int getEncoded(int n) {
        return n;
    }

    @Override
    public int getNextDecoded(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == -1 || n2 == -1) {
            return -1;
        }
        return (n << 8) + n2;
    }

    @Override
    public int getNextEncoded(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == -1 || n2 == -1) {
            return -1;
        }
        return (n << 8) + n2;
    }

    @Override
    public void putNextDecoded(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    @Override
    public void putNextEncoded(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }
}

