/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.FileParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class EncryptCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Encrypt pdf documents.";
    private final List encryptOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "output directory", 65526, false, false), new PdfFileParam("f", "pdf files to encrypt: a list of existing pdf files (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf)", 65519, true, true), new StringParam("p", "prefix for the output files name", true), new StringParam("apwd", "administrator password for the document", true), new StringParam("upwd", "user password for the document", true), new FileParam("d", "directory containing pdf files to encrypt.", 65511, true, false), new StringParam("allow", "permissions: a list of permissions. { print, modify, copy, modifyannotations, fill, screenreaders, assembly, degradedprinting} ", new String[]{"print", "modify", "copy", "modifyannotations", "fill", "screenreaders", "assembly", "degradedprinting"}, true, true), new StringParam("etype", "encryption angorithm {rc4_40, rc4_128, aes_128}. If omitted it uses rc4_128", new String[]{"rc4_40", "rc4_128", "aes_128"}, true, false)));
    private final List encryptArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[encrypt]}", new String[]{"encrypt"}, false)));
    private static final String ENCRYPT_HELP_TEXT = "Encrypt pdf files. \nYou must specify '-o /home/user' to set the output directory.\nYou must specify '-f /tmp/file1.pdf /tmp/file2.pdf:password -f /tmp/file3.pdf [...]' to specify a file list to encrypt (use filename:password if the file is password protected).\n'-apwd password' to set the owner password.\n'-upwd password' to set the user password.\n'-d /tmp' a directory containing the pdf files to encrypt.\n'-allow permission' to set the permissions list. Possible values {[print], [modifyannotations], [assembly], [copy], [degradedprinting], [fill], [modify], [screenreaders]}\n'-p prefix_' to specify a prefix for output names of files. If it contains \"[TIMESTAMP]\" it performs variable substitution. (Ex. [BASENAME]_prefix_[TIMESTAMP] generates FileName_prefix_20070517_113423471.pdf)\nAvailable prefix variables: [TIMESTAMP], [BASENAME].\n'-etype ' to set the encryption angorithm. If omitted it uses rc4_128. Possible values {[aes_128], [rc4_128], [rc4_40]}\n";
    private static final String ENCRYPT_EXAMPLE = "Example: java -jar pdfsam-console-2.4.3e.jar -f /tmp/1.pdf -o /tmp -apwd hello -upwd word -allow print -allow fill -etype rc4_128 -p encrypted_ encrypt\n";

    public Collection getArguments() {
        return this.encryptArguments;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }

    public String getHelpExamples() {
        return ENCRYPT_EXAMPLE;
    }

    public Collection getOptions() {
        return this.encryptOptions;
    }

    public String getHelpMessage() {
        return ENCRYPT_HELP_TEXT;
    }
}

