/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.pdfsam.guiclient.business.environment.Environment;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.utils.FileExtensionUtility;
import org.pdfsam.i18n.GettextResource;

public class SaveEnvironmentAction
extends AbstractAction {
    private static final long serialVersionUID = 1375968616826513096L;
    private Environment environment;
    private JFrame parent;

    public SaveEnvironmentAction(Environment environment, JFrame parent) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Save environment"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Save environment"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/filesave.png")));
        this.environment = environment;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.XML_FILE, 0);
        if (fileChooser.showSaveDialog(this.parent) == 0) {
            File selectedFile = FileExtensionUtility.ensureExtension(fileChooser.getSelectedFile(), "xml");
            int savePwd = JOptionPane.showConfirmDialog(this.parent, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Save passwords informations (they will be readable opening the output file)?"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Confirm password saving"), 0);
            this.environment.saveEnvironment(selectedFile, savePwd == 0);
        }
    }
}

