/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.SingleObjectIterator;
import de.intarsys.tools.number.NumberWrapper;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;

public class NumberInstance
extends NumberWrapper {
    private Number n;

    public NumberInstance(double d) {
        this.n = new Double(d);
    }

    public NumberInstance(int n) {
        this.n = new Integer(n);
    }

    public NumberInstance(Number number) {
        this.n = number;
    }

    public NumberInstance(String string) {
        int n = Integer.parseInt(string);
        this.n = new Integer(n);
    }

    @Override
    public boolean add(Object object) {
        if (object instanceof Number) {
            this.n = (Number)object;
            return true;
        }
        if (object instanceof NumberWrapper && !((NumberWrapper)object).isEmpty()) {
            this.n = ((NumberWrapper)object).getFirst();
            return true;
        }
        throw new IllegalArgumentException("Only objects of type Number or NumberWrapper are supported.");
    }

    @Override
    public boolean addAll(Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        Object e = collection.iterator().next();
        if (e instanceof Number) {
            this.n = (Number)((Object)collection);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue() == this.n.doubleValue();
        }
        if (object instanceof NumberWrapper && !((NumberWrapper)object).isEmpty()) {
            return ((NumberWrapper)object).getFirst().doubleValue() == this.n.doubleValue();
        }
        return false;
    }

    @Override
    protected double getMax() {
        return this.n.doubleValue();
    }

    @Override
    protected double getMin() {
        return this.n.doubleValue();
    }

    public Number getN() {
        return this.n;
    }

    @Override
    public NumberWrapper increment(int n) {
        this.n = new Integer(this.getN().intValue() + n);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SingleObjectIterator(this.getN());
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object[] toArray() {
        return new Number[]{this.n};
    }

    public String toString() {
        return NumberFormat.getInstance().format(this.getN());
    }
}

