/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.version2;

import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPBend;
import dguitar.codecs.guitarPro.GPBendPoint;
import dguitar.codecs.guitarPro.GPBendType;
import dguitar.codecs.guitarPro.GPChordDiagram;
import dguitar.codecs.guitarPro.GPChordNote;
import dguitar.codecs.guitarPro.GPChordType;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPDynamic;
import dguitar.codecs.guitarPro.GPEffectsOnBeat;
import dguitar.codecs.guitarPro.GPEffectsOnNote;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPGraceNote;
import dguitar.codecs.guitarPro.GPHarmonic;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPKey;
import dguitar.codecs.guitarPro.GPMIDIChannel;
import dguitar.codecs.guitarPro.GPMeasure;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPMixTableChange;
import dguitar.codecs.guitarPro.GPMixTableElement;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.codecs.guitarPro.GPSlide;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.GPTonalityType;
import dguitar.codecs.guitarPro.GPTrack;
import dguitar.codecs.guitarPro.GPVibrato;
import dguitar.codecs.guitarPro.version2.GP2EffectsOnBeat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GP2InputStream
extends GPInputStream {
    private static final String[] supportedVersions = new String[]{"FICHIER GUITAR PRO v2.20", "FICHIER GUITAR PRO v2.21"};
    private static final List _files = new ArrayList();
    private static int _total = 0;

    public GP2InputStream(InputStream in) {
        super(in);
    }

    public GP2InputStream(GPInputStream gpIn) {
        super(gpIn);
    }

    public static boolean supportedVersion(String version) {
        boolean correct = false;
        int i = 0;
        while (i < supportedVersions.length && !correct) {
            correct = version.equals(supportedVersions[i]);
            ++i;
        }
        return correct;
    }

    public static String supportedVersions() {
        String s = "";
        int i = 0;
        while (i < supportedVersions.length) {
            s = String.valueOf(s) + supportedVersions[i];
            if (i + 1 < supportedVersions.length) {
                s = String.valueOf(s) + "\n";
            }
            ++i;
        }
        return s;
    }

    public GPSong readPiece() throws IOException {
        GPSong piece = new GPSong();
        if (this.__version.equals("")) {
            this.__version = this.readStringByte(30);
        }
        piece.setVersion(this.__version);
        String s = this.readStringByteMaxLengthPlusOne();
        piece.setTitle(s);
        s = this.readStringByteMaxLengthPlusOne();
        piece.setAuthorSong(s);
        s = this.readStringByteMaxLengthPlusOne();
        piece.setInstruction(s);
        piece.setTempo(this.readInt());
        piece.tripletFeel = this.readInt() == 1;
        GPKey key = GPKey.valueOf(this.readInt());
        piece.setKey(key);
        piece.setOctave(0);
        List tracks = piece.getTracks();
        int i = 0;
        while (i < 8) {
            GPTrack track = new GPTrack();
            tracks.add(track);
            int numStrings = this.readInt();
            track.setNumberOfStrings(numStrings);
            int j = 0;
            while (j < numStrings) {
                track.setStringsTuning(j, this.readInt());
                ++j;
            }
            ++i;
        }
        int numberOfMeasures = this.readInt();
        int i2 = 0;
        while (i2 < 8) {
            GPTrack track = (GPTrack)tracks.get(i2);
            track.setPort(1);
            track.setChannel(i2 + 1);
            GPMIDIChannel channel = this.readTrack(track);
            piece.setChannels(i2, channel);
            ++i2;
        }
        this.skip(1L);
        int b = this.readByte();
        int n = this.readInt();
        int soloTrackNumber = this.readInt();
        List measures = piece.getMeasures();
        List measuresTracksPairs = piece.getMeasuresTracksPairs();
        int i3 = 0;
        while (i3 < numberOfMeasures) {
            GPMeasure measure = new GPMeasure();
            measure.setNumber(i3 + 1);
            measures.add(measure);
            this.readMeasureTrackPairs(tracks, measure, measuresTracksPairs);
            ++i3;
        }
        i3 = 0;
        int numBytes = 1;
        boolean different = false;
        b = this.read();
        while (b != -1) {
            if (!different && ++i3 > 4) {
                different = true;
            }
            b = this.read();
            ++numBytes;
        }
        if (different) {
            System.err.println("GP2InputStream: This GTP file has something special (" + numBytes + " additional bytes)...");
        }
        return piece;
    }

    private GPBeat readBeat(int trackNumberOfStrings) throws IOException {
        GP2EffectsOnBeat gp2effects = new GP2EffectsOnBeat();
        GPBeat beat = new GPBeat();
        int beatDuration = this.readInt();
        GPDuration duration = GPDuration.valueOf(this.readByte());
        beat.setDuration(duration);
        int effectBeat = this.readUnsignedByte();
        int specialEffects = this.readUnsignedByte();
        if ((specialEffects & 2) != 0) {
            beat.mixTableChange = this.readMixTableChange();
        }
        if ((specialEffects & 1) != 0) {
            int strokeType = this.readUnsignedByte();
            int d = this.readUnsignedByte();
            d = (int)(Math.log(d) / Math.log(2.0));
            duration = GPDuration.valueOf(d);
            beat.effects = new GPEffectsOnBeat();
            if (strokeType == 1) {
                beat.effects.upStroke = duration;
            } else if (strokeType == 2) {
                beat.effects.downStroke = duration;
            }
        }
        boolean returnNow = false;
        if (effectBeat != 0) {
            if ((effectBeat & 0x40) != 0) {
                List notes = beat.getNotes();
                GPNote note = new GPNote();
                note.setTieNote(true);
                notes.add(note);
                returnNow = true;
            }
            if ((effectBeat & 0x20) != 0) {
                beat.setNTuplet(3);
                int n = this.readUnsignedByte();
                n += 0;
            }
            if ((effectBeat & 0x10) != 0) {
                beat.dottedNotes = true;
            }
            if ((effectBeat & 8) != 0) {
                beat.setRestBeat(true);
                returnNow = true;
            }
            if ((effectBeat & 4) != 0) {
                this.readEffectsOnBeat(gp2effects, beat.effects);
            }
            if ((effectBeat & 2) != 0) {
                beat.chordDiagram = this.readChordDiagram();
            }
            if ((effectBeat & 1) != 0) {
                beat.text = this.readStringByte(0);
            }
        }
        if (returnNow) {
            return beat;
        }
        int stringsPlayed = this.readUnsignedByte();
        int effectsHeader = this.readUnsignedByte();
        int graceNotePresent = this.readUnsignedByte();
        List notes = beat.getNotes();
        int numberOfStrings = 0;
        int i = 5;
        while (i >= 0) {
            GPNote note = null;
            if ((stringsPlayed & 1 << i) != 0) {
                note = this.readNote();
                notes.add(note);
                if ((effectsHeader & 1 << i) != 0) {
                    note.effects = this.readEffectsOnNote();
                }
                if (gp2effects.hasEffects()) {
                    if (note.effects == null) {
                        note.effects = new GPEffectsOnNote();
                    }
                    note.effects.harmonic = gp2effects.harmonic;
                    note.effects.leftHandVibrato = gp2effects.vibrato;
                    note.effects.wideVibrato = gp2effects.wideVibrato;
                }
                ++numberOfStrings;
                beat.setString(i + (7 - trackNumberOfStrings), true);
            }
            if ((graceNotePresent & 1 << i) != 0) {
                if (note == null) {
                    note = new GPNote();
                    notes.add(note);
                }
                if (note.effects == null) {
                    note.effects = new GPEffectsOnNote();
                }
                note.effects.graceNote = this.readGraceNote();
            }
            --i;
        }
        return beat;
    }

    private GPBend readBend(GPBendType bendType) throws IOException {
        GPBend bend = new GPBend();
        int value = (int)(this.readDouble() * 100.0);
        bend.setType(bendType);
        bend.setValue(value);
        List points = bend.getPoints();
        GPBendPoint bendPoint = new GPBendPoint();
        bendPoint.setPosition(0);
        bendPoint.setValue(0);
        bendPoint.setVibrato(GPVibrato.NONE);
        points.add(bendPoint);
        bendPoint = new GPBendPoint();
        bendPoint.setPosition(30);
        bendPoint.setValue(-value);
        bendPoint.setVibrato(GPVibrato.NONE);
        points.add(bendPoint);
        bendPoint = new GPBendPoint();
        bendPoint.setPosition(60);
        bendPoint.setValue(0);
        bendPoint.setVibrato(GPVibrato.NONE);
        points.add(bendPoint);
        return bend;
    }

    private GPChordDiagram readChordDiagram() throws IOException {
        GPChordDiagram cd = new GPChordDiagram();
        cd.setName(this.readStringByte(0));
        cd.setSharp(this.readBoolean());
        int root = this.readInt();
        if (root <= 11 && root >= 0) {
            cd.setRoot(GPChordNote.valueOf(root));
            cd.setChordType(GPChordType.valueOf(this.readInt()));
            cd.setNineElevenThirteen(this.readInt());
            cd.setBass(GPChordNote.valueOf(this.readInt()));
            cd.setTonalityType(GPTonalityType.valueOf(this.readInt()));
            cd.setTonalityFive(GPTonalityType.valueOf(this.readInt()));
            cd.setTonalityNine(GPTonalityType.valueOf(this.readInt()));
            cd.setTonalityEleven(GPTonalityType.valueOf(this.readInt()));
            this.readUnsignedByte();
            this.skip(3L);
        } else {
            cd.setRoot(GPChordNote.USER);
        }
        int base = this.readInt();
        cd.setBaseFret(base);
        if (base != 0) {
            int i = 0;
            while (i < 6) {
                cd.setFret(i + 1, this.readInt());
                ++i;
            }
        }
        return cd;
    }

    private void readEffectsOnBeat(GP2EffectsOnBeat gp2effects, GPEffectsOnBeat eob) throws IOException {
        if (eob == null) {
            eob = new GPEffectsOnBeat();
        }
        int header = this.readUnsignedByte();
        switch (header) {
            case 1: {
                gp2effects.vibrato = true;
                break;
            }
            case 2: {
                gp2effects.wideVibrato = true;
                break;
            }
            case 3: {
                eob.tremoloBar = this.readBend(GPBendType.DIP);
                break;
            }
            case 4: {
                eob.fadeIn = true;
                break;
            }
            case 5: {
                eob.tapping = true;
                break;
            }
            case 6: {
                eob.slapping = true;
                break;
            }
            case 7: {
                eob.popping = true;
                break;
            }
            case 8: {
                gp2effects.harmonic = GPHarmonic.NATURAL;
                break;
            }
            case 9: {
                gp2effects.harmonic = GPHarmonic.ARTIFICIAL_12;
            }
        }
    }

    private GPEffectsOnNote readEffectsOnNote() throws IOException {
        GPEffectsOnNote eon = new GPEffectsOnNote();
        int effect = this.readUnsignedByte();
        switch (effect) {
            case 1: {
                eon.hammerOnPullOff = true;
                break;
            }
            case 2: {
                eon.hammerOnPullOff = true;
                break;
            }
            case 3: {
                eon.slide = GPSlide.SHIFT_SLIDE;
                break;
            }
            case 4: {
                eon.slide = GPSlide.OUT_DOWNWARD;
                break;
            }
            case 5: {
                eon.bend = this.readBend(GPBendType.BEND);
                break;
            }
            case 6: {
                eon.bend = this.readBend(GPBendType.BEND_RELEASE);
                break;
            }
            case 7: {
                eon.letRing = true;
            }
        }
        return eon;
    }

    private GPGraceNote readGraceNote() throws IOException {
        GPGraceNote gn = new GPGraceNote();
        byte[] b = new byte[3];
        this.read(b);
        gn.setFret(b[0]);
        gn.setDynamic(GPDynamic.valueOf(b[1]));
        gn.setDuration(GPDuration.valueOf(5 - b[2]));
        return gn;
    }

    private void readMeasureTrackPairs(List tracks, GPMeasure measure, List mtpList) throws IOException {
        int d;
        int n;
        int numerator = this.readUnsignedByte();
        measure.setNumerator(numerator);
        int denominator = this.readUnsignedByte();
        measure.setDenominator(denominator);
        this.skip(6L);
        int[] numberOfBeats = new int[8];
        int i = 0;
        while (i < 8) {
            n = this.readUnsignedByte();
            d = this.readUnsignedByte();
            numberOfBeats[i] = this.readUnsignedByte();
            this.skip(9L);
            ++i;
        }
        n = this.readUnsignedByte();
        d = this.readUnsignedByte();
        int measureHeader = this.readUnsignedByte();
        if ((measureHeader & 1) != 0) {
            measure.repeatStart = true;
        }
        if ((measureHeader & 2) != 0) {
            int numberOfRepetitions = this.readUnsignedByte();
            measure.setNumberOfRepetitions(numberOfRepetitions);
        }
        if ((measureHeader & 4) != 0) {
            int numberOfAlternateEndings = this.readUnsignedByte();
            measure.setNumberOfAlternateEnding(numberOfAlternateEndings);
        }
        int i2 = 0;
        while (i2 < 8) {
            GPTrack track = (GPTrack)tracks.get(i2);
            GPMeasureTrackPair mtp = new GPMeasureTrackPair();
            mtpList.add(mtp);
            List beats = mtp.getBeats();
            int j = 0;
            while (j < numberOfBeats[i2]) {
                GPBeat beat = this.readBeat(track.getNumberOfStrings());
                beats.add(beat);
                ++j;
            }
            ++i2;
        }
    }

    private GPMixTableChange readMixTableChange() throws IOException {
        GPMixTableChange mtc = new GPMixTableChange();
        int changes = this.readUnsignedByte();
        if ((changes & 0x20) != 0) {
            mtc.tempo = new GPMixTableElement();
            mtc.tempo.setNewValue(this.readInt());
            mtc.tempo.setChangeDuration(this.readUnsignedByte());
        }
        if ((changes & 0x10) != 0) {
            mtc.reverb = new GPMixTableElement();
            mtc.reverb.setNewValue(this.readUnsignedByte());
            mtc.reverb.setChangeDuration(this.readUnsignedByte());
        }
        if ((changes & 8) != 0) {
            mtc.chorus = new GPMixTableElement();
            mtc.chorus.setNewValue(this.readUnsignedByte());
            mtc.chorus.setChangeDuration(this.readUnsignedByte());
        }
        if ((changes & 4) != 0) {
            mtc.balance = new GPMixTableElement();
            mtc.balance.setNewValue(this.readUnsignedByte());
            mtc.balance.setChangeDuration(this.readUnsignedByte());
        }
        if ((changes & 2) != 0) {
            mtc.volume = new GPMixTableElement();
            mtc.volume.setNewValue(this.readUnsignedByte());
            mtc.volume.setChangeDuration(this.readUnsignedByte());
        }
        if ((changes & 1) != 0) {
            mtc.instrument = new GPMixTableElement();
            mtc.instrument.setNewValue(this.readUnsignedByte());
        }
        return mtc;
    }

    private GPNote readNote() throws IOException {
        GPNote note = new GPNote();
        int fret = this.readUnsignedByte();
        if (fret == 100) {
            note.setDeadNote(true);
        } else {
            note.setFretNumber(fret);
        }
        GPDynamic dynamic = GPDynamic.valueOf(this.readUnsignedByte());
        note.setDynamic(dynamic);
        return note;
    }

    private GPMIDIChannel readTrack(GPTrack track) throws IOException {
        GPMIDIChannel channel = new GPMIDIChannel();
        channel.setInstrument(this.readInt());
        track.setNumberOfFrets(this.readInt());
        track.setName(this.readStringByteMaxLengthPlusOne());
        boolean isSolo = this.readBoolean();
        channel.setVolume(this.readInt());
        channel.setBalance(this.readInt());
        channel.setChorus(this.readInt());
        channel.setReverb(this.readInt());
        track.setCapo(this.readInt());
        return channel;
    }

    public static void main(String[] args) {
        try {
            GPSong p = (GPSong)new GPInputStream("D:\\Partoches\\PopRock\\Vai Steve\\Hand On Heart.gtp").readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File dir = new File("D:\\Partoches");
        GP2InputStream.decodeGP2InDirectory(dir);
        float p = 1.0f - (float)_files.size() / (float)_total;
        System.out.println(String.valueOf(_total) + " files read.");
        System.out.println("Ratio of files read correctly: " + p);
        Iterator it = _files.iterator();
        while (it.hasNext()) {
            System.err.println(it.next());
        }
    }

    private static void decodeGP2InDirectory(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            String name;
            int index;
            File f = files[i];
            if (f.isDirectory()) {
                GP2InputStream.decodeGP2InDirectory(f);
            } else if (f.isFile() && (index = (name = f.getName()).lastIndexOf(".gtp")) == name.length() - 4) {
                try {
                    GPInputStream gpIs = new GPInputStream(f);
                    GPSong p = (GPSong)gpIs.readObject();
                    ++_total;
                }
                catch (AssertionError e) {
                    ((Throwable)((Object)e)).printStackTrace();
                    System.err.println(f.getAbsolutePath());
                }
                catch (GPFormatException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println(f.getAbsolutePath());
                    _files.add(f.getAbsolutePath());
                    ++_total;
                }
            }
            ++i;
        }
    }
}

