/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.convert.StringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum JDKStringConverter implements StringConverter<Object>
{
    STRING((Class)String.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return string;
        }
    }
    ,
    CHAR_SEQUENCE((Class)CharSequence.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return string;
        }
    }
    ,
    STRING_BUFFER((Class)StringBuffer.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new StringBuffer(string);
        }
    }
    ,
    STRING_BUILDER((Class)StringBuilder.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new StringBuilder(string);
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new Long(string);
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new Integer(string);
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new Short(string);
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new Byte(string);
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            if (string.length() != 1) {
                throw new IllegalArgumentException("Character value must be a string length 1");
            }
            return new Character(string.charAt(0));
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            if ("true".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new Double(string);
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new Float(string);
        }
    }
    ,
    BIG_INTEGER((Class)BigInteger.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new BigInteger(string);
        }
    }
    ,
    BIG_DECIMAL((Class)BigDecimal.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new BigDecimal(string);
        }
    }
    ,
    ATOMIC_LONG((Class)AtomicLong.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            long l = Long.parseLong(string);
            return new AtomicLong(l);
        }
    }
    ,
    ATOMIC_INTEGER((Class)AtomicInteger.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            int n = Integer.parseInt(string);
            return new AtomicInteger(n);
        }
    }
    ,
    ATOMIC_BOOLEAN((Class)AtomicBoolean.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            if ("true".equalsIgnoreCase(string)) {
                return new AtomicBoolean(true);
            }
            if ("false".equalsIgnoreCase(string)) {
                return new AtomicBoolean(false);
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    LOCALE((Class)Locale.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            String[] stringArray = string.split("_", 3);
            switch (stringArray.length) {
                case 1: {
                    return new Locale(stringArray[0]);
                }
                case 2: {
                    return new Locale(stringArray[0], stringArray[1]);
                }
                case 3: {
                    return new Locale(stringArray[0], stringArray[1], stringArray[2]);
                }
            }
            throw new IllegalArgumentException("Unable to parse Locale: " + string);
        }
    }
    ,
    CLASS((Class)Class.class){

        @Override
        public String convertToString(Object object) {
            return ((Class)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            try {
                return this.getClass().getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Unable to create class: " + string, classNotFoundException);
            }
        }
    }
    ,
    PACKAGE((Class)Package.class){

        @Override
        public String convertToString(Object object) {
            return ((Package)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return Package.getPackage(string);
        }
    }
    ,
    CURRENCY((Class)Currency.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return Currency.getInstance(string);
        }
    }
    ,
    TIME_ZONE((Class)TimeZone.class){

        @Override
        public String convertToString(Object object) {
            return ((TimeZone)object).getID();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return TimeZone.getTimeZone(string);
        }
    }
    ,
    UUID((Class)UUID.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return java.util.UUID.fromString(string);
        }
    }
    ,
    URL((Class)URL.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException.getMessage(), malformedURLException);
            }
        }
    }
    ,
    URI((Class)URI.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return java.net.URI.create(string);
        }
    }
    ,
    INET_ADDRESS((Class)InetAddress.class){

        @Override
        public String convertToString(Object object) {
            return ((InetAddress)object).getHostAddress();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            try {
                return InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException(unknownHostException);
            }
        }
    }
    ,
    FILE((Class)File.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            return new File(string);
        }
    }
    ,
    DATE((Class)Date.class){

        @Override
        public String convertToString(Object object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String string = simpleDateFormat.format(object);
            return string.substring(0, 26) + ":" + string.substring(26);
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            if (string.length() != 29) {
                throw new IllegalArgumentException("Unable to parse date: " + string);
            }
            string = string.substring(0, 26) + string.substring(27);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            try {
                return simpleDateFormat.parseObject(string);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    }
    ,
    CALENDAR((Class)Calendar.class){

        @Override
        public String convertToString(Object object) {
            if (!(object instanceof GregorianCalendar)) {
                throw new RuntimeException("Unable to convert calendar as it is not a GregorianCalendar");
            }
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            simpleDateFormat.setCalendar(gregorianCalendar);
            String string = simpleDateFormat.format(gregorianCalendar.getTime());
            return string.substring(0, 26) + ":" + string.substring(26) + "[" + gregorianCalendar.getTimeZone().getID() + "]";
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string) {
            if (string.length() < 31 || string.charAt(26) != ':' || string.charAt(29) != '[' || string.charAt(string.length() - 1) != ']') {
                throw new IllegalArgumentException("Unable to parse date: " + string);
            }
            TimeZone timeZone = TimeZone.getTimeZone(string.substring(30, string.length() - 1));
            string = string.substring(0, 26) + string.substring(27, 29);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setTimeInMillis(0L);
            simpleDateFormat.setCalendar(gregorianCalendar);
            try {
                simpleDateFormat.parseObject(string);
                return simpleDateFormat.getCalendar();
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    }
    ,
    ENUM((Class)Enum.class){

        public String convertToString(Object object) {
            return ((Enum)object).name();
        }

        public Object convertFromString(Class clazz, String string) {
            return Enum.valueOf(clazz, string);
        }
    };

    private Class<?> type;

    private JDKStringConverter(Class<?> clazz) {
        this.type = clazz;
    }

    Class<?> getType() {
        return this.type;
    }

    @Override
    public String convertToString(Object object) {
        return object.toString();
    }
}

